/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodePair;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.GraphChange;
import edu.cmu.tetrad.search.IonHittingSet;
import edu.cmu.tetrad.search.PossibleDConnectingPath;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class Ion {
    private boolean pathLengthSearch = false;
    private boolean adjacencySearch = true;
    private List<Graph> input = new ArrayList<Graph>();
    private List<Graph> output = new ArrayList<Graph>();
    private List<Node> variables = new ArrayList<Node>();
    private Set<Triple> definiteNoncolliders = new HashSet<Triple>();
    private Set<IonIndependenceFacts> separations;
    private Set<IonIndependenceFacts> associations;
    private boolean changeFlag = true;
    private Set<Graph> discrimGraphs = new HashSet<Graph>();
    private Set<Graph> finalResult = new HashSet<Graph>();
    private List<Integer> recGraphs = new ArrayList<Integer>();
    private List<Double> recHitTimes = new ArrayList<Double>();
    private double runtime;

    public Ion(List<Graph> pags) {
        for (Graph pag : pags) {
            this.input.add(pag);
        }
        for (Graph pag : this.input) {
            for (Node node : pag.getNodes()) {
                if (this.variables.contains(node)) continue;
                this.variables.add(node);
            }
            for (Triple triple : this.getAllTriples(pag)) {
                if (!pag.isDefNoncollider(triple.getX(), triple.getY(), triple.getZ())) continue;
                pag.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
            }
        }
    }

    public void setPathLengthSearch(boolean b) {
        this.pathLengthSearch = b;
    }

    public void setAdjacencySearch(boolean b) {
        this.adjacencySearch = b;
    }

    public List<Graph> search() {
        long start = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Starting ION Search.");
        this.logGraphs("\nInitial Pags: ", this.input);
        TetradLogger.getInstance().log("info", "Transfering local information.");
        long steps = System.currentTimeMillis();
        EdgeListGraph graph = new EdgeListGraph(this.variables);
        this.transferLocal(graph);
        for (NodePair pair : this.nonIntersection()) {
            graph.addEdge(new Edge(pair.getFirst(), pair.getSecond(), Endpoint.CIRCLE, Endpoint.CIRCLE));
        }
        TetradLogger.getInstance().log("info", "Steps 1-2: " + (double)(System.currentTimeMillis() - steps) / 1000.0 + "s");
        System.out.println("step2");
        System.out.println(graph);
        steps = System.currentTimeMillis();
        LinkedList<EdgeListGraph> searchPags = new LinkedList<EdgeListGraph>();
        searchPags.offer(graph);
        List<Set<IonIndependenceFacts>> sepAndAssoc = this.findSepAndAssoc();
        this.separations = sepAndAssoc.get(0);
        this.associations = sepAndAssoc.get(1);
        LinkedList<Graph> step3Pags = new LinkedList<Graph>();
        HashSet<Graph> reject = new HashSet<Graph>();
        if (this.separations.isEmpty()) {
            step3Pags.add(graph);
        }
        int numNodes = graph.getNumNodes();
        int pl = numNodes - 1;
        if (this.pathLengthSearch) {
            pl = 2;
        }
        block1: for (int l = pl; l < numNodes; ++l) {
            if (this.pathLengthSearch) {
                TetradLogger.getInstance().log("info", "Braching over path lengths: " + l + " of " + (numNodes - 1));
            }
            int seps = this.separations.size();
            int currentSep = 1;
            int numAdjacencies = this.separations.size();
            for (IonIndependenceFacts fact : this.separations) {
                if (this.adjacencySearch) {
                    TetradLogger.getInstance().log("info", "Braching over path nonadjacencies: " + currentSep + " of " + numAdjacencies);
                }
                --seps;
                searchPags.addAll(step3Pags);
                this.recGraphs.add(searchPags.size());
                step3Pags.clear();
                while (!searchPags.isEmpty()) {
                    System.out.println("ION Step 3 size: " + searchPags.size());
                    Graph pag = (Graph)searchPags.poll();
                    ArrayList<PossibleDConnectingPath> dConnections = new ArrayList<PossibleDConnectingPath>();
                    if (this.adjacencySearch) {
                        for (List list : fact.getZ()) {
                            if (this.pathLengthSearch) {
                                dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, fact.getX(), fact.getY(), list, l));
                                continue;
                            }
                            dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, fact.getX(), fact.getY(), list));
                        }
                    } else {
                        for (IonIndependenceFacts ionIndependenceFacts : this.separations) {
                            for (List<Node> conditions : ionIndependenceFacts.getZ()) {
                                if (this.pathLengthSearch) {
                                    dConnections.addAll(PossibleDConnectingPath.findDConnectingPathsOfLength(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), conditions, l));
                                    continue;
                                }
                                dConnections.addAll(PossibleDConnectingPath.findDConnectingPaths(pag, ionIndependenceFacts.getX(), ionIndependenceFacts.getY(), conditions));
                            }
                        }
                    }
                    if (dConnections.isEmpty()) {
                        step3Pags.add(pag);
                        continue;
                    }
                    HashMap<Collection<Node>, List<PossibleDConnectingPath>> paths = new HashMap<Collection<Node>, List<PossibleDConnectingPath>>();
                    for (PossibleDConnectingPath possibleDConnectingPath : dConnections) {
                        LinkedList<PossibleDConnectingPath> p = (LinkedList<PossibleDConnectingPath>)paths.get(possibleDConnectingPath.getConditions());
                        if (p == null) {
                            p = new LinkedList<PossibleDConnectingPath>();
                        }
                        p.add(possibleDConnectingPath);
                        paths.put(possibleDConnectingPath.getConditions(), p);
                    }
                    ArrayList<Set<GraphChange>> possibleChanges = new ArrayList<Set<GraphChange>>();
                    for (Set<GraphChange> changes : this.findChanges(paths)) {
                        HashSet<GraphChange> newChanges = new HashSet<GraphChange>();
                        for (GraphChange gc : changes) {
                            boolean okay = true;
                            for (Triple collider : gc.getColliders()) {
                                if (!pag.isUnderlineTriple(collider.getX(), collider.getY(), collider.getZ())) continue;
                                okay = false;
                                break;
                            }
                            if (!okay) continue;
                            for (Triple collider : gc.getNoncolliders()) {
                                if (!pag.isDefCollider(collider.getX(), collider.getY(), collider.getZ())) continue;
                                okay = false;
                                break;
                            }
                            if (!okay) continue;
                            newChanges.add(gc);
                        }
                        if (!newChanges.isEmpty()) {
                            possibleChanges.add(newChanges);
                            continue;
                        }
                        possibleChanges.clear();
                        break;
                    }
                    float f = System.currentTimeMillis();
                    List<GraphChange> hittingSets = IonHittingSet.findHittingSet(possibleChanges);
                    this.recHitTimes.add((double)((float)System.currentTimeMillis() - f) / 1000.0);
                    for (GraphChange gc : hittingSets) {
                        Graph changed;
                        boolean badhittingset = false;
                        for (Edge edge : gc.getRemoves()) {
                            Node node1 = edge.getNode1();
                            Node node2 = edge.getNode2();
                            HashSet<Triple> triples = new HashSet<Triple>();
                            triples.addAll(gc.getColliders());
                            triples.addAll(gc.getNoncolliders());
                            if (triples.size() != gc.getColliders().size() + gc.getNoncolliders().size()) {
                                badhittingset = true;
                                break;
                            }
                            for (Triple triple : triples) {
                                if (((Object)node1).equals(triple.getY()) && (((Object)node2).equals(triple.getX()) || ((Object)node2).equals(triple.getZ()))) {
                                    badhittingset = true;
                                    break;
                                }
                                if (!((Object)node2).equals(triple.getY()) || !((Object)node1).equals(triple.getX()) && !((Object)node1).equals(triple.getZ())) continue;
                                badhittingset = true;
                                break;
                            }
                            if (badhittingset) break;
                            for (NodePair pair : gc.getOrients()) {
                                if ((!((Object)node1).equals(pair.getFirst()) || !((Object)node2).equals(pair.getSecond())) && (!((Object)node2).equals(pair.getFirst()) || !((Object)node1).equals(pair.getSecond()))) continue;
                                badhittingset = true;
                                break;
                            }
                            if (!badhittingset) continue;
                            break;
                        }
                        if (!badhittingset) {
                            for (NodePair pair : gc.getOrients()) {
                                for (Triple triple : gc.getNoncolliders()) {
                                    if (((Object)pair.getSecond()).equals(triple.getY())) {
                                        if (((Object)pair.getFirst()).equals(triple.getX()) && pag.getEndpoint(triple.getZ(), triple.getY()).equals(Endpoint.ARROW)) {
                                            badhittingset = true;
                                            break;
                                        }
                                        if (((Object)pair.getFirst()).equals(triple.getZ()) && pag.getEndpoint(triple.getX(), triple.getY()).equals(Endpoint.ARROW)) {
                                            badhittingset = true;
                                            break;
                                        }
                                    }
                                    if (!badhittingset) continue;
                                    break;
                                }
                                if (!badhittingset) continue;
                                break;
                            }
                        }
                        if (badhittingset || reject.contains(changed = gc.applyTo(pag)) || step3Pags.contains(changed)) continue;
                        if (this.predictsFalseIndependence(this.associations, changed) || changed.existsDirectedCycle()) {
                            reject.add(changed);
                        }
                        step3Pags.add(changed);
                    }
                }
                if (this.adjacencySearch) continue;
                continue block1;
            }
        }
        TetradLogger.getInstance().log("info", "Step 3: " + (double)(System.currentTimeMillis() - steps) / 1000.0 + "s");
        steps = System.currentTimeMillis();
        Set<Graph> outputPags = new HashSet<Graph>();
        while (!step3Pags.isEmpty()) {
            Graph pag = (Graph)step3Pags.poll();
            HashMap<Edge, Boolean> necEdges = new HashMap<Edge, Boolean>();
            for (Edge edge : pag.getEdges()) {
                necEdges.put(edge, false);
            }
            block20: for (IonIndependenceFacts fact : this.associations) {
                for (List<Node> nodes : fact.getZ()) {
                    if (!nodes.isEmpty()) continue;
                    List<List<Node>> treks = GraphUtils.treks(pag, fact.x, fact.y);
                    if (treks.size() != 1) continue block20;
                    List<Node> trek = treks.get(0);
                    ArrayList arrayList = new ArrayList();
                    for (int i = 1; i < trek.size(); ++i) {
                        necEdges.put(pag.getEdge(trek.get(i - 1), trek.get(i)), true);
                        if (i == 1) continue;
                        pag.addUnderlineTriple(trek.get(i - 2), trek.get(i - 1), trek.get(i));
                    }
                    continue block20;
                }
            }
            for (Graph newPag : this.possRemove(pag, necEdges)) {
                boolean elimTreks = false;
                block24: for (IonIndependenceFacts fact : this.associations) {
                    for (List list : fact.getZ()) {
                        if (!list.isEmpty()) continue;
                        if (!GraphUtils.treks(newPag, fact.x, fact.y).isEmpty()) continue block24;
                        elimTreks = true;
                        continue block24;
                    }
                }
                if (elimTreks) continue;
                outputPags.add(newPag);
            }
        }
        outputPags = this.removeMoreSpecific(outputPags);
        TetradLogger.getInstance().log("info", "Step 4: " + (double)(System.currentTimeMillis() - steps) / 1000.0 + "s");
        steps = System.currentTimeMillis();
        HashSet<Graph> outputSet = new HashSet<Graph>();
        for (Graph pag : outputPags) {
            HashSet<Triple> unshieldedPossibleColliders = new HashSet<Triple>();
            for (Triple triple : this.getPossibleTriples(pag)) {
                if (pag.isAdjacentTo(triple.getX(), triple.getZ())) continue;
                unshieldedPossibleColliders.add(triple);
            }
            PowerSet pset = new PowerSet(unshieldedPossibleColliders);
            for (Set set : pset) {
                EdgeListGraph edgeListGraph = new EdgeListGraph(pag);
                for (Triple triple : set) {
                    edgeListGraph.setEndpoint(triple.getX(), triple.getY(), Endpoint.ARROW);
                    edgeListGraph.setEndpoint(triple.getZ(), triple.getY(), Endpoint.ARROW);
                }
                this.doFinalOrientation(edgeListGraph);
            }
            for (Graph outputPag : this.finalResult) {
                if (this.predictsFalseIndependence(this.associations, outputPag)) continue;
                HashSet<Triple> hashSet = new HashSet<Triple>(outputPag.getUnderLines());
                for (Triple triple : hashSet) {
                    outputPag.removeUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
                }
                outputSet.add(outputPag);
            }
        }
        this.output.addAll(outputSet);
        TetradLogger.getInstance().log("info", "Step 5: " + (double)(System.currentTimeMillis() - steps) / 1000.0 + "s");
        this.runtime = (double)(System.currentTimeMillis() - start) / 1000.0;
        this.logGraphs("\nReturning output (" + this.output.size() + " Graphs):", this.output);
        return this.output;
    }

    public List<String> getRuntime() {
        double totalhit = 0.0;
        double longesthit = 0.0;
        double averagehit = 0.0;
        for (Double i : this.recHitTimes) {
            totalhit += i.doubleValue();
            averagehit += i / (double)this.recHitTimes.size();
            if (!(i > longesthit)) continue;
            longesthit = i;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(Double.toString(this.runtime));
        list.add(Double.toString(totalhit));
        list.add(Double.toString(longesthit));
        list.add(Double.toString(averagehit));
        return list;
    }

    public List<Integer> getIterations() {
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i / this.recGraphs.size();
            if (i <= largestit) continue;
            largestit = i;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(totalit);
        list.add(largestit);
        list.add(averageit);
        return list;
    }

    public String getStats() {
        String stats = "Total running time:  " + this.runtime + "\\\\";
        int totalit = 0;
        int largestit = 0;
        int averageit = 0;
        for (Integer i : this.recGraphs) {
            totalit += i.intValue();
            averageit += i.intValue();
            if (i <= largestit) continue;
            largestit = i;
        }
        averageit /= this.recGraphs.size();
        double totalhit = 0.0;
        double longesthit = 0.0;
        double averagehit = 0.0;
        for (Double i : this.recHitTimes) {
            totalhit += i.doubleValue();
            averagehit += i / (double)this.recHitTimes.size();
            if (!(i > longesthit)) continue;
            longesthit = i;
        }
        stats = stats + "Total iterations in step 3:  " + totalit + "\\\\";
        stats = stats + "Largest set of iterations in step 3:  " + largestit + "\\\\";
        stats = stats + "Average iterations set in step 3:  " + averageit + "\\\\";
        stats = stats + "Total hitting sets calculation time:  " + totalhit + "\\\\";
        stats = stats + "Average hitting set calculation time:  " + averagehit + "\\\\";
        stats = stats + "Longest hitting set calculation time:  " + longesthit + "\\\\";
        return stats;
    }

    private void logGraphs(String message, List<? extends Graph> graphs) {
        if (message != null) {
            TetradLogger.getInstance().log("graph", message);
        }
        for (Graph graph : graphs) {
            TetradLogger.getInstance().log("graph", ((Object)graph).toString());
        }
    }

    private List<NodePair> allNodePairs(List<Node> nodes) {
        ArrayList<NodePair> nodePairs = new ArrayList<NodePair>();
        for (int j = 0; j < nodes.size() - 1; ++j) {
            for (int k = j + 1; k < nodes.size(); ++k) {
                nodePairs.add(new NodePair(nodes.get(j), nodes.get(k)));
            }
        }
        return nodePairs;
    }

    private Set<NodePair> nonadjacencies() {
        HashSet<NodePair> nonadjacencies = new HashSet<NodePair>();
        for (Graph graph : this.input) {
            for (NodePair pair : this.allNodePairs(graph.getNodes())) {
                if (graph.isAdjacentTo(pair.getFirst(), pair.getSecond())) continue;
                nonadjacencies.add(pair);
            }
        }
        return nonadjacencies;
    }

    private void transferLocal(Graph graph) {
        Set<NodePair> nonadjacencies = this.nonadjacencies();
        for (Graph pag : this.input) {
            for (Edge edge : pag.getEdges()) {
                if (nonadjacencies.contains(new NodePair(edge.getNode1(), edge.getNode2()))) continue;
                if (!graph.isAdjacentTo(edge.getNode1(), edge.getNode2())) {
                    graph.addEdge(edge);
                    continue;
                }
                Endpoint first = edge.getEndpoint1();
                Endpoint firstCurrent = graph.getEndpoint(edge.getNode2(), edge.getNode1());
                if (!first.equals(Endpoint.CIRCLE)) {
                    if (first.equals(Endpoint.ARROW) && firstCurrent.equals(Endpoint.TAIL) || first.equals(Endpoint.TAIL) && firstCurrent.equals(Endpoint.ARROW)) {
                        graph.setEndpoint(edge.getNode2(), edge.getNode1(), Endpoint.CIRCLE);
                    } else {
                        graph.setEndpoint(edge.getNode2(), edge.getNode1(), edge.getEndpoint1());
                    }
                }
                Endpoint second = edge.getEndpoint2();
                Endpoint secondCurrent = graph.getEndpoint(edge.getNode1(), edge.getNode2());
                if (second.equals(Endpoint.CIRCLE)) continue;
                if (second.equals(Endpoint.ARROW) && secondCurrent.equals(Endpoint.TAIL) || second.equals(Endpoint.TAIL) && secondCurrent.equals(Endpoint.ARROW)) {
                    graph.setEndpoint(edge.getNode1(), edge.getNode2(), Endpoint.CIRCLE);
                    continue;
                }
                graph.setEndpoint(edge.getNode1(), edge.getNode2(), edge.getEndpoint2());
            }
            for (Triple triple : pag.getUnderLines()) {
                if (!triple.alongPathIn(graph)) continue;
                graph.addUnderlineTriple(triple.getX(), triple.getY(), triple.getZ());
                this.definiteNoncolliders.add(triple);
            }
        }
    }

    private Set<Triple> getAllTriples(Graph graph) {
        HashSet<Triple> triples = new HashSet<Triple>();
        for (Node node : graph.getNodes()) {
            List<Node> adjNodes = graph.getAdjacentNodes(node);
            for (int i = 0; i < adjNodes.size() - 1; ++i) {
                for (int j = i + 1; j < adjNodes.size(); ++j) {
                    triples.add(new Triple(adjNodes.get(i), node, adjNodes.get(j)));
                }
            }
        }
        return triples;
    }

    private List<NodePair> nonIntersection() {
        ArrayList<HashSet<Node>> varsets = new ArrayList<HashSet<Node>>();
        for (Graph graph : this.input) {
            varsets.add(new HashSet<Node>(graph.getNodes()));
        }
        ArrayList<NodePair> pairs = new ArrayList<NodePair>();
        for (int i = 0; i < this.variables.size() - 1; ++i) {
            Node node1 = this.variables.get(i);
            for (int j = i + 1; j < this.variables.size(); ++j) {
                boolean intersection = false;
                Node node2 = this.variables.get(j);
                for (Set set : varsets) {
                    if (!set.containsAll(Arrays.asList(node1, node2))) continue;
                    intersection = true;
                    break;
                }
                if (intersection) continue;
                pairs.add(new NodePair(node1, node2));
            }
        }
        return pairs;
    }

    private List<Set<IonIndependenceFacts>> findSepAndAssoc() {
        HashSet<IonIndependenceFacts> separations = new HashSet<IonIndependenceFacts>();
        HashSet<IonIndependenceFacts> associations = new HashSet<IonIndependenceFacts>();
        List<NodePair> allNodes = this.allNodePairs(this.variables);
        for (NodePair pair : allNodes) {
            Node x = pair.getFirst();
            Node y = pair.getSecond();
            ArrayList<Node> variables = new ArrayList<Node>(this.variables);
            variables.remove(x);
            variables.remove(y);
            List<Set<Node>> subsets = SearchGraphUtils.powerSet(variables);
            IonIndependenceFacts indep = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            IonIndependenceFacts assoc = new IonIndependenceFacts(x, y, new HashSet<List<Node>>());
            boolean addIndep = false;
            boolean addAssoc = false;
            for (Graph pag : this.input) {
                for (Set<Node> subset : subsets) {
                    if (!this.containsAll(pag, subset, pair)) continue;
                    if (pag.isDSeparatedFrom(x, y, new ArrayList<Node>(subset))) {
                        if (pag.isAdjacentTo(x, y)) continue;
                        addIndep = true;
                        indep.addMoreZ(new ArrayList<Node>(subset));
                        continue;
                    }
                    addAssoc = true;
                    assoc.addMoreZ(new ArrayList<Node>(subset));
                }
            }
            if (addIndep) {
                separations.add(indep);
            }
            if (!addAssoc) continue;
            associations.add(assoc);
        }
        ArrayList<Set<IonIndependenceFacts>> ret = new ArrayList<Set<IonIndependenceFacts>>(2);
        ret.add(0, separations);
        ret.add(1, associations);
        return ret;
    }

    private boolean containsAll(Graph g, Set<Node> nodes, NodePair pair) {
        if (!g.containsNode(pair.getFirst()) || !g.containsNode(pair.getSecond())) {
            return false;
        }
        for (Node node : nodes) {
            if (g.containsNode(node)) continue;
            return false;
        }
        return true;
    }

    private boolean predictsFalseIndependence(Set<IonIndependenceFacts> associations, Graph pag) {
        for (IonIndependenceFacts assocFact : associations) {
            for (List<Node> conditioningSet : assocFact.getZ()) {
                if (!pag.isDSeparatedFrom(assocFact.getX(), assocFact.getY(), conditioningSet)) continue;
                return true;
            }
        }
        return false;
    }

    private Set<Triple> getPossibleTriples(Graph pag) {
        HashSet<Triple> possibleTriples = new HashSet<Triple>();
        for (Triple triple : this.getAllTriples(pag)) {
            if (!pag.isAdjacentTo(triple.getX(), triple.getY()) || !pag.isAdjacentTo(triple.getY(), triple.getZ()) || pag.isUnderlineTriple(triple.getX(), triple.getY(), triple.getZ()) || this.definiteNoncolliders.contains(triple) || pag.isDefCollider(triple.getX(), triple.getY(), triple.getZ())) continue;
            possibleTriples.add(triple);
        }
        return possibleTriples;
    }

    private List<Set<GraphChange>> findChanges(Map<Collection<Node>, List<PossibleDConnectingPath>> paths) {
        ArrayList<Set<GraphChange>> pagChanges = new ArrayList<Set<GraphChange>>();
        Set<Map.Entry<Collection<Node>, List<PossibleDConnectingPath>>> entries = paths.entrySet();
        for (Map.Entry<Collection<Node>, List<PossibleDConnectingPath>> entry : entries) {
            Collection<Node> conditions = entry.getKey();
            List<PossibleDConnectingPath> dConnecting = entry.getValue();
            for (PossibleDConnectingPath possible : dConnecting) {
                List<Node> possPath = possible.getPath();
                HashSet<GraphChange> pathChanges = new HashSet<GraphChange>(2 * possPath.size());
                ArrayList<Node> outsidePath = new ArrayList<Node>(conditions.size());
                for (Node condition : conditions) {
                    if (possPath.contains(condition)) continue;
                    outsidePath.add(condition);
                }
                for (int i = 0; i < possPath.size() - 1; ++i) {
                    Node current = possPath.get(i);
                    Node next = possPath.get(i + 1);
                    GraphChange gc = new GraphChange();
                    gc.addRemove(possible.getPag().getEdge(current, next));
                    pathChanges.add(gc);
                    if (conditions.contains(current) && i > 0) {
                        gc = new GraphChange();
                        Triple nonColider = new Triple(possPath.get(i - 1), current, next);
                        gc.addNonCollider(nonColider);
                        pathChanges.add(gc);
                    }
                    if (conditions.contains(current) || i <= 0) continue;
                    Triple colider = new Triple(possPath.get(i - 1), current, next);
                    if (possible.getPag().isUnderlineTriple(possPath.get(i - 1), current, next)) continue;
                    Edge edge1 = possible.getPag().getEdge(colider.getX(), colider.getY());
                    Edge edge2 = possible.getPag().getEdge(colider.getZ(), colider.getY());
                    if (!((Object)edge1.getNode1()).equals(colider.getY()) ? ((Object)edge1.getNode2()).equals(colider.getY()) && edge1.getEndpoint2().equals(Endpoint.TAIL) : edge1.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (!((Object)edge2.getNode1()).equals(colider.getY()) ? ((Object)edge2.getNode2()).equals(colider.getY()) && edge2.getEndpoint2().equals(Endpoint.TAIL) : edge2.getEndpoint1().equals(Endpoint.TAIL)) continue;
                    if (outsidePath.size() == 0) {
                        gc = new GraphChange();
                        gc.addCollider(colider);
                        pathChanges.add(gc);
                        continue;
                    }
                    for (Node outside : outsidePath) {
                        List<Object> decendantPaths = new ArrayList();
                        decendantPaths = PossibleDConnectingPath.findDConnectingPaths(possible.getPag(), current, outside, new ArrayList<Node>());
                        if (decendantPaths.isEmpty()) {
                            gc = new GraphChange();
                            gc.addCollider(colider);
                            pathChanges.add(gc);
                            continue;
                        }
                        for (PossibleDConnectingPath possibleDConnectingPath : decendantPaths) {
                            List<Node> decendantPath = possibleDConnectingPath.getPath();
                            boolean impliesDecendant = true;
                            HashSet<GraphChange> colideChanges = new HashSet<GraphChange>();
                            for (int j = 0; j < decendantPath.size() - 1; ++j) {
                                Node from = decendantPath.get(j);
                                Node to = decendantPath.get(j + 1);
                                Edge currentEdge = possible.getPag().getEdge(from, to);
                                if (currentEdge.getEndpoint1().equals(Endpoint.ARROW)) {
                                    impliesDecendant = false;
                                    break;
                                }
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addRemove(currentEdge);
                                colideChanges.add(gc);
                                gc = new GraphChange();
                                gc.addCollider(colider);
                                gc.addOrient(to, from);
                                colideChanges.add(gc);
                            }
                            if (!impliesDecendant) continue;
                            pathChanges.addAll(colideChanges);
                        }
                    }
                }
                pagChanges.add(pathChanges);
            }
        }
        return pagChanges;
    }

    private List<Graph> possRemove(Graph pag, Map<Edge, Boolean> necEdges) {
        ArrayList<Edge> remEdges = new ArrayList<Edge>();
        for (Edge remEdge : necEdges.keySet()) {
            if (necEdges.get(remEdge).booleanValue()) continue;
            remEdges.add(remEdge);
        }
        PowerSet pset = new PowerSet(remEdges);
        ArrayList<Graph> possRemove = new ArrayList<Graph>();
        for (Set set : pset) {
            EdgeListGraph newPag = new EdgeListGraph(pag);
            for (Edge edge : set) {
                newPag.removeEdge(edge);
            }
            possRemove.add(newPag);
        }
        return possRemove;
    }

    private void doFinalOrientation(Graph graph) {
        this.discrimGraphs.clear();
        HashSet<Graph> currentDiscrimGraphs = new HashSet<Graph>();
        currentDiscrimGraphs.add(graph);
        while (this.changeFlag) {
            this.changeFlag = false;
            currentDiscrimGraphs.addAll(this.discrimGraphs);
            this.discrimGraphs.clear();
            for (Graph newGraph : currentDiscrimGraphs) {
                this.doubleTriangle(newGraph);
                this.awayFromColliderAncestorCycle(newGraph);
                if (this.discrimPaths(newGraph)) continue;
                if (this.changeFlag) {
                    this.discrimGraphs.add(newGraph);
                    continue;
                }
                this.finalResult.add(newGraph);
            }
            currentDiscrimGraphs.clear();
        }
        this.changeFlag = true;
    }

    private void doubleTriangle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            List<Node> intoBArrows = graph.getNodesInTo(B, Endpoint.ARROW);
            List<Node> intoBCircles = graph.getNodesInTo(B, Endpoint.CIRCLE);
            LinkedList<Node> possA = new LinkedList<Node>(intoBArrows);
            LinkedList<Node> possC = new LinkedList<Node>(intoBArrows);
            for (Node D : intoBCircles) {
                for (Node A : possA) {
                    for (Node C : possC) {
                        if (C == A || !graph.isAdjacentTo(A, D) || !graph.isAdjacentTo(C, D) || graph.isDefCollider(A, D, C) || !this.isArrowpointAllowed(graph, D, B)) continue;
                        graph.setEndpoint(D, B, Endpoint.ARROW);
                        this.changeFlag = true;
                    }
                }
            }
        }
    }

    private void awayFromAncestorCycle(Graph graph) {
        while (this.changeFlag) {
            this.changeFlag = false;
            List<Node> nodes = graph.getNodes();
            for (Node B : nodes) {
                int[] combination;
                List<Node> adj = graph.getAdjacentNodes(B);
                if (adj.size() < 2) continue;
                ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
                while ((combination = cg.next()) != null) {
                    Node A = adj.get(combination[0]);
                    Node C = adj.get(combination[1]);
                    this.awayFromAncestor(graph, A, B, C);
                    this.awayFromAncestor(graph, C, B, A);
                    this.awayFromCycle(graph, A, B, C);
                    this.awayFromCycle(graph, C, B, A);
                }
            }
        }
        this.changeFlag = true;
    }

    private void awayFromColliderAncestorCycle(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.awayFromCollider(graph, A, B, C);
                this.awayFromCollider(graph, C, B, A);
                this.awayFromAncestor(graph, A, B, C);
                this.awayFromAncestor(graph, C, B, A);
                this.awayFromCycle(graph, A, B, C);
                this.awayFromCycle(graph, C, B, A);
            }
        }
    }

    private boolean isArrowpointAllowed(Graph graph, Node x, Node y) {
        if (graph.getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (graph.getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (graph.getEndpoint(y, x) == Endpoint.ARROW && graph.getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return true;
    }

    private void awayFromCollider(Graph graph, Node a, Node b, Node c) {
        Endpoint BC = graph.getEndpoint(b, c);
        Endpoint CB = graph.getEndpoint(c, b);
        if (!graph.isAdjacentTo(a, c) && graph.getEndpoint(a, b) == Endpoint.ARROW) {
            if ((CB == Endpoint.CIRCLE || CB == Endpoint.TAIL) && BC == Endpoint.CIRCLE) {
                if (!this.isArrowpointAllowed(graph, b, c)) {
                    return;
                }
                graph.setEndpoint(b, c, Endpoint.ARROW);
                this.changeFlag = true;
            }
            if ((BC == Endpoint.CIRCLE || BC == Endpoint.ARROW) && CB == Endpoint.CIRCLE) {
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.changeFlag = true;
            }
        }
    }

    private void awayFromAncestor(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.CIRCLE && graph.getEndpoint(a, b) == Endpoint.ARROW && graph.getEndpoint(b, c) == Endpoint.ARROW && (graph.getEndpoint(b, a) == Endpoint.TAIL || graph.getEndpoint(c, b) == Endpoint.TAIL)) {
            if (!this.isArrowpointAllowed(graph, a, c)) {
                return;
            }
            graph.setEndpoint(a, c, Endpoint.ARROW);
            this.changeFlag = true;
        }
    }

    private void awayFromCycle(Graph graph, Node a, Node b, Node c) {
        if (graph.isAdjacentTo(a, c) && graph.getEndpoint(a, c) == Endpoint.ARROW && graph.getEndpoint(c, a) == Endpoint.CIRCLE && graph.isDirectedFromTo(a, b) && graph.isDirectedFromTo(b, c)) {
            graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
        }
    }

    private boolean discrimPaths(Graph graph) {
        List<Node> nodes = graph.getNodes();
        for (Node b : nodes) {
            List<Node> possAandC = graph.getNodesOutTo(b, Endpoint.ARROW);
            LinkedList<Node> possA = new LinkedList<Node>(possAandC);
            possA.removeAll(graph.getNodesInTo(b, Endpoint.TAIL));
            LinkedList<Node> possC = new LinkedList<Node>(possAandC);
            possC.retainAll(graph.getNodesInTo(b, Endpoint.CIRCLE));
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    if (!this.reachablePathFindOrient(graph, a, b, c, reachable)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private boolean reachablePathFindOrient(Graph graph, Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node l : pathExtensions) {
                if (!graph.isAdjacentTo(l, c)) {
                    this.doDdpOrientation(graph, l, a, b, c);
                    return true;
                }
                if (!cParents.contains(l) || graph.getEndpoint(x, l) != Endpoint.ARROW) continue;
                reachable.add(l);
            }
        }
        return false;
    }

    private void doDdpOrientation(Graph graph, Node l, Node a, Node b, Node c) {
        this.changeFlag = true;
        for (IonIndependenceFacts iif : this.separations) {
            if ((!((Object)iif.getX()).equals(l) || !((Object)iif.getY()).equals(c)) && (!((Object)iif.getY()).equals(l) || !((Object)iif.getX()).equals(c))) continue;
            for (List<Node> condSet : iif.getZ()) {
                if (!condSet.contains(b)) continue;
                graph.setEndpoint(c, b, Endpoint.TAIL);
                this.discrimGraphs.add(graph);
                return;
            }
        }
        EdgeListGraph newGraph1 = new EdgeListGraph(graph);
        newGraph1.setEndpoint(a, b, Endpoint.ARROW);
        newGraph1.setEndpoint(c, b, Endpoint.ARROW);
        this.discrimGraphs.add(newGraph1);
        EdgeListGraph newGraph2 = new EdgeListGraph(graph);
        newGraph2.setEndpoint(c, b, Endpoint.TAIL);
        this.discrimGraphs.add(newGraph2);
    }

    private Set<Graph> removeMoreSpecific(Set<Graph> outputPags) {
        HashSet<Graph> moreSpecific = new HashSet<Graph>();
        block0: for (Graph pag : outputPags) {
            for (Graph pag2 : outputPags) {
                if (((Object)pag).equals(pag2) || pag.getEdges().size() != pag2.getEdges().size()) continue;
                boolean sameAdjacencies = true;
                for (Edge edge1 : pag.getEdges()) {
                    if (pag2.isAdjacentTo(edge1.getNode1(), edge1.getNode2())) continue;
                    sameAdjacencies = false;
                }
                if (!sameAdjacencies) continue;
                boolean arrowstails = true;
                boolean circles = true;
                for (Edge edge2 : pag2.getEdges()) {
                    Edge edge1 = pag.getEdge(edge2.getNode1(), edge2.getNode2());
                    if (((Object)edge1.getNode1()).equals(edge2.getNode1())) {
                        if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                            if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                                arrowstails = false;
                            }
                        } else if (!edge1.getEndpoint1().equals(edge2.getEndpoint1())) {
                            circles = false;
                        }
                        if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                            if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                            arrowstails = false;
                            continue;
                        }
                        if (edge1.getEndpoint2().equals(edge2.getEndpoint2())) continue;
                        circles = false;
                        continue;
                    }
                    if (!((Object)edge1.getNode1()).equals(edge2.getNode2())) continue;
                    if (!edge2.getEndpoint1().equals(Endpoint.CIRCLE)) {
                        if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                            arrowstails = false;
                        }
                    } else if (!edge1.getEndpoint2().equals(edge2.getEndpoint1())) {
                        circles = false;
                    }
                    if (!edge2.getEndpoint2().equals(Endpoint.CIRCLE)) {
                        if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                        arrowstails = false;
                        continue;
                    }
                    if (edge1.getEndpoint1().equals(edge2.getEndpoint2())) continue;
                    circles = false;
                }
                if (!arrowstails || circles) continue;
                moreSpecific.add(pag);
                continue block0;
            }
        }
        for (Graph pag : moreSpecific) {
            outputPags.remove(pag);
        }
        return outputPags;
    }

    private class PowerSet<E>
    implements Iterable<Set<E>> {
        Collection<E> all;

        public PowerSet(Collection<E> all) {
            this.all = all;
        }

        @Override
        public Iterator<Set<E>> iterator() {
            return new PowerSetIterator(this);
        }

        class PowerSetIterator<InE>
        implements Iterator<Set<InE>> {
            PowerSet<InE> powerSet;
            List<InE> canonicalOrder = new ArrayList<InE>();
            List<InE> mask = new ArrayList<InE>();
            boolean hasNext = true;

            PowerSetIterator(PowerSet<InE> powerSet2) {
                this.powerSet = powerSet2;
                this.canonicalOrder.addAll(powerSet2.all);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private boolean allOnes() {
                for (InE bit : this.mask) {
                    if (bit != null) continue;
                    return false;
                }
                return true;
            }

            private void increment() {
                int i;
                for (i = 0; i < this.mask.size(); ++i) {
                    InE bit = this.mask.get(i);
                    if (bit == null) {
                        this.mask.set(i, this.canonicalOrder.get(i));
                        return;
                    }
                    this.mask.set(i, null);
                }
                this.mask.add(this.canonicalOrder.get(i));
            }

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public Set<InE> next() {
                HashSet<InE> result = new HashSet<InE>();
                result.addAll(this.mask);
                result.remove(null);
                boolean bl = this.hasNext = this.mask.size() < this.powerSet.all.size() || !this.allOnes();
                if (this.hasNext) {
                    this.increment();
                }
                return result;
            }
        }
    }

    private final class IonIndependenceFacts {
        private Node x;
        private Node y;
        private Collection<List<Node>> z;

        public IonIndependenceFacts(Node x, Node y, Collection<List<Node>> z) {
            if (x == null || y == null || z == null) {
                throw new NullPointerException();
            }
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public final Node getX() {
            return this.x;
        }

        public final Node getY() {
            return this.y;
        }

        public final Collection<List<Node>> getZ() {
            return this.z;
        }

        public void addMoreZ(List<Node> moreZ) {
            this.z.add(moreZ);
        }

        public final int hashCode() {
            int hash = 17;
            hash += 19 * ((Object)this.x).hashCode() * ((Object)this.y).hashCode();
            return hash += 23 * ((Object)this.z).hashCode();
        }

        public final boolean equals(Object obj) {
            if (!(obj instanceof IonIndependenceFacts)) {
                return false;
            }
            IonIndependenceFacts fact = (IonIndependenceFacts)obj;
            return ((Object)this.x).equals(fact.x) && ((Object)this.y).equals(fact.y) && ((Object)this.z).equals(fact.z) || ((Object)this.x).equals(fact.y) & ((Object)this.y).equals(fact.x) && ((Object)this.z).equals(fact.z);
        }

        public String toString() {
            return "I(" + this.x + ", " + this.y + " | " + this.z + ")";
        }
    }
}

