/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.search.GraphChange;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IonHittingSet {
    public static List<GraphChange> findHittingSet(List<Set<GraphChange>> Forig) {
        LinkedList<HsNode> currentLevel = new LinkedList<HsNode>();
        LinkedList<HsNode> nextLevel = new LinkedList<HsNode>();
        ArrayList<GraphChange> hittingSets = new ArrayList<GraphChange>();
        List F = IonHittingSet.precompute(Forig);
        currentLevel.addFirst(new HsNode(new GraphChange(), 0));
        while (!currentLevel.isEmpty()) {
            HsNode n = (HsNode)currentLevel.removeFirst();
            if (!IonHittingSet.nodeRedundant(n, hittingSets)) {
                int nextUCSigma = IonHittingSet.findNextUCSigma(F, n);
                if (nextUCSigma == -1) {
                    hittingSets.add(n.getPath());
                } else {
                    n.updateLabel(nextUCSigma);
                    for (GraphChange nextLCSigma : (Set)F.get(nextUCSigma)) {
                        GraphChange newPath = new GraphChange(n.getPath());
                        if (!newPath.isConsistent(nextLCSigma)) continue;
                        newPath.union(nextLCSigma);
                        if (!IonHittingSet.pathNecessary(newPath, nextLevel)) continue;
                        nextLevel.add(new HsNode(newPath, n.getLabel()));
                    }
                }
            }
            if (!currentLevel.isEmpty()) continue;
            currentLevel = nextLevel;
            nextLevel = new LinkedList();
        }
        return hittingSets;
    }

    private static boolean pathNecessary(GraphChange path, LinkedList<HsNode> nextLevel) {
        boolean necessary = true;
        for (HsNode m : nextLevel) {
            if (!m.getPath().equals(path)) continue;
            necessary = false;
            break;
        }
        return necessary;
    }

    private static boolean nodeRedundant(HsNode n, List<GraphChange> hittingSets) {
        boolean redundant = false;
        for (GraphChange hs : hittingSets) {
            if (!n.getPath().contains(hs)) continue;
            redundant = true;
            break;
        }
        return redundant;
    }

    private static int findNextUCSigma(List<Set<GraphChange>> F, HsNode n) {
        GraphChange path = n.getPath();
        for (int index = n.getLabel(); index < F.size(); ++index) {
            Set<GraphChange> sigma = F.get(index);
            boolean intersect = false;
            for (GraphChange aSigma : sigma) {
                if (!path.contains(aSigma)) continue;
                intersect = true;
                break;
            }
            if (intersect) continue;
            return index;
        }
        return -1;
    }

    private static List precompute(List<Set<GraphChange>> F) {
        int size = F.size();
        ArrayList<Set<GraphChange>> pruned = new ArrayList<Set<GraphChange>>(size);
        for (int i = 0; i < size; ++i) {
            Set<GraphChange> setI = F.get(i);
            for (int j = i + 1; j < size; ++j) {
                boolean notMarked;
                Set<GraphChange> setJ = F.get(j);
                boolean bl = notMarked = !setJ.contains(new GraphChange());
                if (notMarked && setI.containsAll(setJ)) {
                    setI.add(new GraphChange());
                    break;
                }
                if (!notMarked || !setJ.containsAll(setI)) continue;
                setJ.add(new GraphChange());
            }
            if (setI.contains(new GraphChange())) continue;
            pruned.add(F.get(i));
        }
        return pruned;
    }

    private static class HsNode {
        private GraphChange path;
        private int label;

        public HsNode(GraphChange path, int label) {
            this.path = path;
            this.label = label;
        }

        public void updateLabel(int label) {
            this.label = label;
        }

        public GraphChange getPath() {
            return this.path;
        }

        public int getLabel() {
            return this.label;
        }
    }
}

