/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fas;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.DepthChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class Npc
implements GraphSearch {
    private IndependenceTest independenceTest;
    private Knowledge knowledge;
    private int depth = Integer.MAX_VALUE;
    private long elapsedTime;
    private boolean aggressivelyPreventCycles = false;
    private int numIndependenceTests = 0;
    private TetradLogger logger = TetradLogger.getInstance();
    private double alpha;
    private Set<Triple> allTriples;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private Graph trueGraph;
    private SepsetMap sepsetMap = new SepsetMap();
    int n1 = 0;
    int n2 = 0;

    public Npc(IndependenceTest independenceTest, Knowledge knowledge) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.knowledge = knowledge;
        this.allTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
    }

    Npc(double alpha) {
        this.alpha = alpha;
    }

    public boolean isAggressivelyPreventCycles() {
        return this.aggressivelyPreventCycles;
    }

    public void setAggressivelyPreventCycles(boolean aggressivelyPreventCycles) {
        this.aggressivelyPreventCycles = aggressivelyPreventCycles;
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public Graph search() {
        IndependenceTest test = this.getIndependenceTest();
        List<Node> nodes = test.getVariables();
        Graph graph = new EdgeListGraph(nodes);
        graph.fullyConnect(Endpoint.TAIL);
        this.knowledge = new Knowledge();
        HashSet<Edge> addedEdges = new HashSet<Edge>();
        boolean changed = true;
        while (changed) {
            changed = false;
            Fas fas = new Fas(graph, test);
            fas.setKnowledge(this.knowledge);
            graph = fas.search();
            SepsetMap sepsetMap = fas.getSepsets();
            for (int i = 0; i < nodes.size(); ++i) {
                for (int j = i + 1; j < nodes.size(); ++j) {
                    Node x = nodes.get(i);
                    Node y = nodes.get(j);
                    List<Node> sepset = sepsetMap.get(x, y);
                    this.orientPc(graph, this.knowledge, sepsetMap);
                    if (sepset == null) continue;
                    for (Node node : sepset) {
                        List<List<Node>> paths;
                        if (!(graph.isAdjacentTo(x, node) || (paths = GraphUtils.allPathsFromToExcluding(graph, x, node, Collections.singletonList(y))).isEmpty() || addedEdges.contains(Edges.undirectedEdge(x, node)))) {
                            graph.addUndirectedEdge(x, node);
                            addedEdges.add(Edges.undirectedEdge(x, node));
                            changed = true;
                        }
                        if (graph.isAdjacentTo(y, node) || (paths = GraphUtils.allPathsFromToExcluding(graph, y, node, Collections.singletonList(x))).isEmpty() || addedEdges.contains(Edges.undirectedEdge(y, node))) continue;
                        graph.addUndirectedEdge(y, node);
                        addedEdges.add(Edges.undirectedEdge(y, node));
                        changed = true;
                    }
                }
            }
        }
        return graph;
    }

    private List<Node> independent(IndependenceTest test, Graph graph, Node x, Node y) {
        int[] choice;
        List<Node> commonAdjacents = graph.getAdjacentNodes(x);
        commonAdjacents.retainAll(graph.getAdjacentNodes(y));
        commonAdjacents.remove(y);
        DepthChoiceGenerator generator = new DepthChoiceGenerator(commonAdjacents.size(), commonAdjacents.size());
        while ((choice = generator.next()) != null) {
            List<Node> excludes = GraphUtils.asList(choice, commonAdjacents);
            List<Node> sepset = this.getPseudoMarkovBlanket3(graph, x, y, excludes);
            if (!test.isIndependent(x, y, sepset)) continue;
            this.sepsetMap.set(x, y, sepset);
            return sepset;
        }
        this.sepsetMap.set(x, y, null);
        return null;
    }

    private void printTrueDseps(IndependenceTest test, Node x, Node y, List<Node> sepset) {
        if (this.trueGraph != null) {
            IndTestDSep dsep = new IndTestDSep(this.trueGraph);
            Node _x = this.trueGraph.getNode(x.getName());
            Node _y = this.trueGraph.getNode(y.getName());
            LinkedList<Node> _sepset = new LinkedList<Node>();
            for (Node node : sepset) {
                _sepset.add(this.trueGraph.getNode(node.getName()));
            }
            if (dsep.isDSeparated(_x, _y, _sepset)) {
                test.isIndependent(x, y, sepset);
                System.out.println("1\t" + test.getPValue());
            } else {
                test.isIndependent(x, y, sepset);
                System.out.println("0\t" + test.getPValue());
            }
        }
    }

    private List<Node> getPseudoMarkovBlanket(Graph graph, Node x, Node y, List<Node> excludes) {
        List<Node> condSet = graph.getAdjacentNodes(x);
        condSet.remove(y);
        condSet.removeAll(excludes);
        for (Node adj : new LinkedList<Node>(condSet)) {
            if (graph.getEdge(x, adj).getProximalEndpoint(adj) != Endpoint.ARROW) continue;
            List<Node> parents = graph.getNodesInTo(adj, Endpoint.ARROW);
            for (Node parent : parents) {
                if (parent == x || parent == y || excludes.contains(parent) || condSet.contains(parent)) continue;
                condSet.add(parent);
            }
        }
        return condSet;
    }

    private List<Node> getPseudoMarkovBlanket2(Graph graph, Node x, Node y, List<Node> excludes) {
        LinkedList<Node> condSet = new LinkedList<Node>();
        for (Node adj : graph.getAdjacentNodes(x)) {
            if (adj == y || excludes.contains(adj)) continue;
            List<Node> parents = graph.getParents(adj);
            List<Node> adjacents = graph.getAdjacentNodes(adj);
            if (parents.size() < 2) {
                condSet.add(adj);
                continue;
            }
            if (parents.size() >= adjacents.size()) continue;
            condSet.add(adj);
            for (Node parent : parents) {
                if (parent == x || parent == y || condSet.contains(parent)) continue;
                condSet.add(parent);
            }
        }
        return condSet;
    }

    private List<Node> getPseudoMarkovBlanket3(Graph graph, Node x, Node y, List<Node> excludes) {
        LinkedList<Node> condSet = new LinkedList<Node>();
        for (Node adj : graph.getAdjacentNodes(x)) {
            if (adj == y || excludes.contains(adj)) continue;
            List<Node> parents = graph.getParents(adj);
            List<Node> adjacents = graph.getAdjacentNodes(adj);
            for (Node adj2 : graph.getAdjacentNodes(adj)) {
                LinkedList<Node> path = new LinkedList<Node>();
                path.add(x);
                path.add(adj);
                path.add(adj2);
                Node _x = this.trueGraph.getNode(x.getName());
                Node _adj = this.trueGraph.getNode(adj.getName());
                Node _adj2 = this.trueGraph.getNode(adj2.getName());
                LinkedList<Node> _path = new LinkedList<Node>();
                _path.add(_x);
                _path.add(_adj);
                _path.add(_adj2);
                boolean b1 = !graph.isParentOf(adj, x);
                boolean b2 = graph.isUndirectedFromTo(adj, adj2);
                if (this.trueGraph != null && b1 && b2 && !this.trueGraph.isDefCollider(_x, _adj, _adj2)) {
                    ++this.n1;
                }
                if (this.trueGraph == null || !b1 || !b2 || !this.trueGraph.isDefCollider(_x, _adj, _adj2)) continue;
                ++this.n2;
            }
            if (parents.size() < 2) {
                condSet.add(adj);
                continue;
            }
            if (parents.size() >= adjacents.size()) continue;
            condSet.add(adj);
            if (!graph.isChildOf(adj, x)) continue;
            for (Node parent : graph.getAdjacentNodes(adj)) {
                if (parent == x || parent == y || condSet.contains(parent)) continue;
                condSet.add(parent);
            }
        }
        return condSet;
    }

    @Override
    public long getElapsedTime() {
        return this.elapsedTime;
    }

    private Graph orientPc(Graph graph, Knowledge knowledge, SepsetMap sepset) {
        for (Edge edge : graph.getEdges()) {
            graph.removeEdge(edge);
            graph.addUndirectedEdge(edge.getNode1(), edge.getNode2());
        }
        SearchGraphUtils.pcOrientbk(knowledge, graph, graph.getNodes());
        SearchGraphUtils.orientCollidersUsingSepsets(sepset, knowledge, graph);
        MeekRules rules = new MeekRules();
        rules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        rules.setKnowledge(knowledge);
        rules.orientImplied(graph);
        return graph;
    }

    private Graph orientCpc(Graph graph, Knowledge knowledge, int depth) {
        graph = GraphUtils.undirectedGraph(graph);
        SearchGraphUtils.pcOrientbk(knowledge, graph, graph.getNodes());
        graph = this.orientUnshieldedTriples(graph, knowledge, this.getIndependenceTest(), depth);
        MeekRules meekRules = new MeekRules();
        meekRules.setAggressivelyPreventCycles(this.aggressivelyPreventCycles);
        meekRules.setKnowledge(knowledge);
        meekRules.orientImplied(graph);
        return graph;
    }

    private Graph orientUnshieldedTriples(Graph graph, Knowledge knowledge, IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : graph.getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = graph.getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node z;
                Node x = adjacentNodes.get(combination[0]);
                if (graph.isAdjacentTo(x, z = adjacentNodes.get(combination[1]))) continue;
                this.allTriples.add(new Triple(x, y, z));
                SearchGraphUtils.CpcTripleType type = SearchGraphUtils.getCpcTripleType(x, y, z, test, depth, graph);
                if (type == SearchGraphUtils.CpcTripleType.COLLIDER) {
                    if (this.colliderAllowed(x, y, z, knowledge)) {
                        graph.setEndpoint(x, y, Endpoint.ARROW);
                        graph.setEndpoint(z, y, Endpoint.ARROW);
                        TetradLogger.getInstance().log("colliderOrientations", SearchLogUtils.colliderOrientedMsg(x, y, z));
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == SearchGraphUtils.CpcTripleType.AMBIGUOUS) {
                    Triple triple = new Triple(x, y, z);
                    this.ambiguousTriples.add(triple);
                    graph.addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                    continue;
                }
                this.noncolliderTriples.add(new Triple(x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
        return graph;
    }

    private boolean colliderAllowed(Node x, Node y, Node z, Knowledge knowledge) {
        return Npc.isArrowpointAllowed1(x, y, knowledge) && Npc.isArrowpointAllowed1(z, y, knowledge);
    }

    private static boolean isArrowpointAllowed1(Node from, Node to, Knowledge knowledge) {
        if (knowledge == null) {
            return true;
        }
        return !knowledge.edgeRequired(((Object)to).toString(), ((Object)from).toString()) && !knowledge.edgeForbidden(((Object)from).toString(), ((Object)to).toString());
    }

    public void setTrueGraph(Graph trueGraph) {
        this.trueGraph = trueGraph;
    }
}

