/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemOptimizer;
import edu.cmu.tetrad.sem.SemOptimizerRegression;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;

public final class PValueImprover {
    private DataSet dataSet;
    private Knowledge knowledge;
    private SemIm semIm;

    public PValueImprover(SemIm semIm, DataSet data, Knowledge knowledge) {
        this.semIm = semIm;
        this.dataSet = data;
        this.knowledge = knowledge;
    }

    public SemIm search() {
        Score score;
        boolean producesHighP;
        Edge edge;
        Edge _edge;
        double alpha = 0.001;
        SemGraph graph = this.semIm.getSemPm().getGraph();
        SearchGraphUtils.pdagToDag(graph);
        try {
            this.removeHighPCoefs(graph, alpha);
        }
        catch (Exception e) {
            // empty catch block
        }
        boolean changed = true;
        double delta = 0.01;
        double pCutoff = 0.99;
        double bestScore = this.scoreGraph(graph).score;
        List<Node> variables = graph.getNodes();
        while (true) {
            _edge = null;
            double _pValue = Double.NaN;
            for (Node x : variables) {
                for (Node y : variables) {
                    if (x == y) continue;
                    if (((Object)x).equals(y)) {
                        System.out.println();
                    }
                    if ((edge = graph.getEdge(x, y)) == null) continue;
                    graph.removeEdge(edge);
                    producesHighP = this.producesHighPCoefs("Removing " + edge, graph, alpha);
                    score = this.scoreGraph(graph);
                    graph.addEdge(edge);
                    if (!(score.getScore() > bestScore) || score.getEstimatedSem().getPValue() > pCutoff || this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString()) || producesHighP) continue;
                    _edge = edge;
                    bestScore = score.getScore();
                    _pValue = score.getEstimatedSem().getPValue();
                }
            }
            if (_edge == null) break;
            graph.removeEdge(_edge);
            TetradLogger.getInstance().log("info", "P = " + _pValue);
            TetradLogger.getInstance().log("info", "Removed " + _edge + " (" + bestScore + ")");
            TetradLogger.getInstance().flush();
            this.removeHighPCoefs(graph, alpha);
            changed = true;
        }
        while (changed) {
            changed = false;
            while (true) {
                _edge = null;
                double _pValue = Double.NaN;
                for (Node x : variables) {
                    for (Node y : variables) {
                        if (x == y || graph.isAdjacentTo(x, y)) continue;
                        edge = Edges.directedEdge(x, y);
                        graph.addEdge(edge);
                        producesHighP = this.producesHighPCoefs("Adding " + edge, graph, alpha);
                        score = this.scoreGraph(graph);
                        graph.removeEdge(edge);
                        if (producesHighP || !(score.getScore() > bestScore + delta) || score.getEstimatedSem().getPValue() > pCutoff || this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString())) continue;
                        _edge = edge;
                        bestScore = score.getScore();
                        _pValue = score.getEstimatedSem().getPValue();
                    }
                }
                if (_edge == null) break;
                if (graph.isAdjacentTo(_edge.getNode1(), _edge.getNode2())) {
                    throw new IllegalArgumentException();
                }
                graph.addEdge(_edge);
                TetradLogger.getInstance().log("info", "Added " + _edge + " (" + bestScore + ")");
                TetradLogger.getInstance().flush();
                changed = true;
            }
            for (Node x : variables) {
                for (Node y : variables) {
                    Edge edge2;
                    if (x == y || (edge2 = graph.getEdge(x, y)) == null) continue;
                    graph.removeEdge(edge2);
                    Edge edge1 = Edges.directedEdge(x, y);
                    graph.addEdge(edge1);
                    Score score1 = this.scoreGraph(graph);
                    graph.removeEdge(edge1);
                    Edge edge22 = Edges.directedEdge(y, x);
                    graph.addEdge(edge22);
                    Score score2 = this.scoreGraph(graph);
                    graph.removeEdge(edge22);
                    if (score2.getScore() > score1.getScore() && score2.getScore() > bestScore + delta) {
                        if (score2.getEstimatedSem().getPValue() > pCutoff) {
                            graph.addEdge(edge2);
                            continue;
                        }
                        if (this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString())) continue;
                        if (this.producesHighPCoefs("Orienting " + edge22, graph, alpha)) {
                            graph.addEdge(edge2);
                            continue;
                        }
                        graph.addEdge(edge22);
                        if (edge2.equals(edge22)) continue;
                        TetradLogger.getInstance().log("info", "P = " + score2.getEstimatedSem().getPValue());
                        TetradLogger.getInstance().log("info", "Orienting " + edge2 + " to " + edge22 + " (" + score2.getScore() + ")");
                        TetradLogger.getInstance().flush();
                        bestScore = score2.getScore();
                        changed = true;
                        continue;
                    }
                    if (score1.getScore() > score2.getScore() && score1.getScore() > bestScore + delta) {
                        if (score1.getEstimatedSem().getPValue() > pCutoff) {
                            graph.addEdge(edge2);
                            continue;
                        }
                        if (this.knowledge.edgeForbidden(((Object)y).toString(), ((Object)x).toString())) continue;
                        if (this.producesHighPCoefs("Orienting " + edge1, graph, alpha)) {
                            graph.addEdge(edge2);
                            continue;
                        }
                        graph.addEdge(edge1);
                        if (edge2.equals(edge1)) continue;
                        TetradLogger.getInstance().log("info", "P = " + score1.getEstimatedSem().getPValue());
                        TetradLogger.getInstance().log("info", "Orienting " + edge2 + " to " + edge1 + " (" + score1.getScore() + ")");
                        TetradLogger.getInstance().flush();
                        bestScore = score1.getScore();
                        changed = true;
                        continue;
                    }
                    graph.addEdge(edge2);
                }
            }
        }
        this.removeHighPCoefs(graph, alpha);
        Score score2 = this.scoreGraph(graph);
        return score2.getEstimatedSem();
    }

    public SemIm search2() {
        double alpha = 0.05;
        SemGraph graph = this.semIm.getSemPm().getGraph();
        SearchGraphUtils.pdagToDag(graph);
        this.removeHighPCoefs(graph, alpha);
        boolean changed = true;
        double delta = 0.01;
        double pCutoff = 0.99;
        double bestScore = this.scoreGraph(graph).score;
        List<Node> variables = graph.getNodes();
        while (changed) {
            Score score;
            boolean producesHighP;
            Edge edge;
            changed = false;
            for (Node x : variables) {
                for (Node y : variables) {
                    if (x == y || graph.isAdjacentTo(x, y)) continue;
                    edge = Edges.directedEdge(x, y);
                    graph.addEdge(edge);
                    producesHighP = this.producesHighPCoefs("Adding " + edge, graph, alpha);
                    score = this.scoreGraph(graph);
                    graph.removeEdge(edge);
                    if (!(score.getScore() > bestScore + delta) || score.getEstimatedSem().getPValue() > pCutoff || this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString()) || producesHighP) continue;
                    graph.addEdge(edge);
                    TetradLogger.getInstance().log("info", "Added " + edge + " (" + bestScore + ")");
                    TetradLogger.getInstance().flush();
                    bestScore = score.getScore();
                    changed = true;
                }
            }
            for (Node x : variables) {
                for (Node y : variables) {
                    if (x == y) continue;
                    if (((Object)x).equals(y)) {
                        System.out.println();
                    }
                    if ((edge = graph.getEdge(x, y)) == null) continue;
                    graph.removeEdge(edge);
                    producesHighP = this.producesHighPCoefs("Removing " + edge, graph, alpha);
                    score = this.scoreGraph(graph);
                    graph.addEdge(edge);
                    if (!(score.getScore() > bestScore + delta) || score.getEstimatedSem().getPValue() > pCutoff || this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString()) || producesHighP) continue;
                    graph.removeEdge(edge);
                    TetradLogger.getInstance().log("info", "Removed " + edge + " (" + bestScore + ")");
                    TetradLogger.getInstance().flush();
                    bestScore = score.getScore();
                    changed = true;
                }
            }
            for (Node x : variables) {
                for (Node y : variables) {
                    if (x == y || (edge = graph.getEdge(x, y)) == null) continue;
                    graph.removeEdge(edge);
                    Edge edge1 = Edges.directedEdge(x, y);
                    graph.addEdge(edge1);
                    Score score1 = this.scoreGraph(graph);
                    graph.removeEdge(edge1);
                    Edge edge2 = Edges.directedEdge(y, x);
                    graph.addEdge(edge2);
                    Score score2 = this.scoreGraph(graph);
                    graph.removeEdge(edge2);
                    if (score2.getScore() > score1.getScore() && score2.getScore() > bestScore + delta) {
                        if (score2.getEstimatedSem().getPValue() > pCutoff) {
                            graph.addEdge(edge);
                            continue;
                        }
                        if (this.knowledge.edgeForbidden(((Object)x).toString(), ((Object)y).toString())) continue;
                        if (this.producesHighPCoefs("Orienting " + edge2, graph, alpha)) {
                            graph.addEdge(edge);
                            continue;
                        }
                        graph.addEdge(edge2);
                        if (edge.equals(edge2)) continue;
                        TetradLogger.getInstance().log("info", "P = " + score2.getEstimatedSem().getPValue());
                        TetradLogger.getInstance().log("info", "Orienting " + edge + " to " + edge2 + " (" + score2.getScore() + ")");
                        TetradLogger.getInstance().flush();
                        bestScore = score2.getScore();
                        changed = true;
                        continue;
                    }
                    if (score1.getScore() > score2.getScore() && score1.getScore() > bestScore + delta) {
                        if (score1.getEstimatedSem().getPValue() > pCutoff) {
                            graph.addEdge(edge);
                            continue;
                        }
                        if (this.knowledge.edgeForbidden(((Object)y).toString(), ((Object)x).toString())) continue;
                        if (this.producesHighPCoefs("Orienting " + edge1, graph, alpha)) {
                            graph.addEdge(edge);
                            continue;
                        }
                        graph.addEdge(edge1);
                        if (edge.equals(edge1)) continue;
                        TetradLogger.getInstance().log("info", "P = " + score1.getEstimatedSem().getPValue());
                        TetradLogger.getInstance().log("info", "Orienting " + edge + " to " + edge1 + " (" + score1.getScore() + ")");
                        TetradLogger.getInstance().flush();
                        bestScore = score1.getScore();
                        changed = true;
                        continue;
                    }
                    graph.addEdge(edge);
                }
            }
        }
        this.removeHighPCoefs(graph, alpha);
        Score score = this.scoreGraph(graph);
        return score.getEstimatedSem();
    }

    private void removeHighPCoefs(Graph graph, double alpha) {
        SemPm semPm = new SemPm(graph);
        SemEstimator estimator = new SemEstimator(this.dataSet, semPm);
        estimator.estimate();
        SemIm estSem = estimator.getEstimatedSem();
        List<Parameter> parameters = estSem.getSemPm().getParameters();
        for (Parameter parameter : parameters) {
            double p;
            if (parameter.getType() != ParamType.COEF || !((p = estSem.getPValue(parameter, 300)) > alpha)) continue;
            graph.removeEdge(parameter.getNodeA(), parameter.getNodeB());
            TetradLogger.getInstance().log("info", "Removing parameter " + parameter + " because p = " + p + " > " + alpha);
            TetradLogger.getInstance().flush();
        }
    }

    private boolean producesHighPCoefs(String whatProducesIt, Graph graph, double alpha) {
        SemPm semPm = new SemPm(graph);
        SemEstimator estimator = new SemEstimator(this.dataSet, semPm, (SemOptimizer)new SemOptimizerRegression());
        estimator.estimate();
        SemIm estSem = estimator.getEstimatedSem();
        List<Parameter> parameters = estSem.getSemPm().getParameters();
        for (Parameter parameter : parameters) {
            double p;
            if (parameter.getType() != ParamType.COEF || !((p = estSem.getPValue(parameter, 300)) > alpha)) continue;
            return true;
        }
        return false;
    }

    public Graph search3() {
        TetradLogger.getInstance().log("info", "Starting SEM Score Search");
        EdgeListGraph graph = new EdgeListGraph(this.dataSet.getVariables());
        double bestScore = this.scoreGraph(graph).getScore();
        System.out.println("Initial score = " + bestScore);
        while (true) {
            Edge _edge = null;
            for (Node x : this.dataSet.getVariables()) {
                block2: for (Node y : this.dataSet.getVariables()) {
                    if (x == y || graph.isAdjacentTo(x, y)) continue;
                    Edge edge = Edges.directedEdge(x, y);
                    graph.addEdge(edge);
                    Score scoreResult = this.scoreGraph(graph);
                    SemIm scoredSem = scoreResult.getEstimatedSem();
                    double score = scoreResult.getScore();
                    int dof = scoredSem.getSemPm().getDof();
                    double chiSquare = scoredSem.getChiSquare();
                    System.out.println("Attempt add edge " + edge + " score = " + score);
                    List<Node> adjacents = graph.getAdjacentNodes(Edges.getDirectedEdgeHead(edge));
                    adjacents.remove(Edges.getDirectedEdgeTail(edge));
                    for (Node adjacent : adjacents) {
                        Parameter p2;
                        Parameter p1;
                        double secondDerivative;
                        Edge other = graph.getEdge(adjacent, Edges.getDirectedEdgeHead(edge));
                        if (other.getProximalEndpoint(Edges.getDirectedEdgeHead(edge)) != Endpoint.ARROW || edge.getProximalEndpoint(Edges.getDirectedEdgeHead(edge)) != Endpoint.ARROW || !(Math.abs(secondDerivative = this.secondDerivative(scoredSem, p1 = scoredSem.getSemPm().getCoefficientParameter(edge.getNode1(), edge.getNode2()), p2 = scoredSem.getSemPm().getCoefficientParameter(other.getNode1(), other.getNode2()))) < 1.0E-5)) continue;
                        graph.removeEdge(edge);
                        continue block2;
                    }
                    if (score < bestScore && dof > 1 && chiSquare > 0.0 && chiSquare > (double)(dof / 2)) {
                        bestScore = score;
                        _edge = edge;
                        System.out.println("Attempt add edge " + edge + " score = " + score);
                    }
                    graph.removeEdge(edge);
                }
            }
            if (_edge == null) break;
            graph.addEdge(_edge);
        }
        return graph;
    }

    private Score scoreGraph(Graph graph) {
        SemPm semPm = new SemPm(graph);
        SemEstimator semEstimator = new SemEstimator(this.dataSet, semPm, (SemOptimizer)new SemOptimizerRegression());
        semEstimator.estimate();
        SemIm estimatedSem = semEstimator.getEstimatedSem();
        return new Score(estimatedSem, -(estimatedSem.getChiSquare() / (double)semPm.getDof()));
    }

    private void rebuildPattern(Graph graph) {
        SearchGraphUtils.basicPattern(graph);
        this.pdagWithBk(graph);
    }

    private void pdagWithBk(Graph graph) {
        MeekRules rules = new MeekRules();
        rules.orientImplied(graph);
    }

    public double secondDerivative(SemIm semIm, Parameter p1, Parameter p2) {
        double delta = 0.005;
        SemFittingFunction fcn = new SemFittingFunction(semIm);
        List<Parameter> freeParameters = semIm.getFreeParameters();
        int i = freeParameters.indexOf(p1);
        int j = freeParameters.indexOf(p2);
        double[] params = semIm.getFreeParamValues();
        return this.secondPartialDerivative(fcn, i, j, params, delta);
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public double secondPartialDerivative(FittingFunction f, int i, int j, double[] p, double delt) {
        double[] arg = new double[p.length];
        System.arraycopy(p, 0, arg, 0, p.length);
        int n = i;
        arg[n] = arg[n] + delt;
        int n2 = j;
        arg[n2] = arg[n2] + delt;
        double ff1 = f.evaluate(arg);
        int n3 = j;
        arg[n3] = arg[n3] - 2.0 * delt;
        double ff2 = f.evaluate(arg);
        int n4 = i;
        arg[n4] = arg[n4] - 2.0 * delt;
        int n5 = j;
        arg[n5] = arg[n5] + 2.0 * delt;
        double ff3 = f.evaluate(arg);
        int n6 = j;
        arg[n6] = arg[n6] - 2.0 * delt;
        double ff4 = f.evaluate(arg);
        double fsSum = ff1 - ff2 - ff3 + ff4;
        double partial = fsSum / (4.0 * delt * delt);
        return partial;
    }

    static class SemFittingFunction
    implements FittingFunction {
        private final SemIm sem;

        public SemFittingFunction(SemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] parameters) {
            this.sem.setFreeParamValues(parameters);
            return this.sem.getFml();
        }

        @Override
        public int getNumParameters() {
            return this.sem.getNumFreeParams();
        }
    }

    static interface FittingFunction {
        public double evaluate(double[] var1);

        public int getNumParameters();
    }

    private static class Score {
        private SemIm estimatedSem;
        private double score;

        public Score(SemIm estimatedSem, double score) {
            this.estimatedSem = estimatedSem;
            this.score = score;
        }

        public SemIm getEstimatedSem() {
            return this.estimatedSem;
        }

        public double getScore() {
            return this.score;
        }
    }
}

