/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.ChoiceGenerator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class PagUtils {
    public static boolean graphInPagStep1(Graph pag, Graph dag) {
        System.out.println("graphInPag entered!");
        System.out.println("PAG = " + pag);
        System.out.println("DAG = " + dag);
        List<Node> pagNodes = pag.getNodes();
        for (Node pagNode : pagNodes) {
            if (dag.getNode(pagNode.getName()) == null) {
                return false;
            }
            if (dag.getNode(pagNode.getName()).getNodeType() == NodeType.MEASURED) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep2(Graph pag, Graph dag) {
        LinkedList<Node> dagNodes = new LinkedList<Node>(dag.getNodes());
        LinkedList<Node> dagONodes = new LinkedList<Node>();
        IndTestDSep test = new IndTestDSep(dag);
        for (Node dagNode : dagNodes) {
            if (dagNode.getNodeType() != NodeType.MEASURED) continue;
            dagONodes.add(dagNode);
        }
        boolean forAllAB = true;
        block1: for (int j = 0; j < dagONodes.size(); ++j) {
            for (int k = j + 1; k < dagONodes.size(); ++k) {
                Node Ad = (Node)dagONodes.get(j);
                Node Bd = (Node)dagONodes.get(k);
                ArrayList<Node> OMinusAB = new ArrayList<Node>(dagONodes);
                OMinusAB.remove(Ad);
                OMinusAB.remove(Bd);
                int nOMinusAB = OMinusAB.size();
                Node Ap2 = pag.getNode(Ad.getName());
                Node Bp = pag.getNode(Bd.getName());
                List<Edge> edgesABgamma = pag.getEdges(Ap2, Bp);
                boolean existsEdgeABgamma = edgesABgamma.size() > 0;
                boolean forEveryW = true;
                for (int i = 0; i <= nOMinusAB; ++i) {
                    int[] indSet;
                    ChoiceGenerator cg = new ChoiceGenerator(nOMinusAB, i);
                    while ((indSet = cg.next()) != null) {
                        List<Node> condSetW = SearchGraphUtils.asList(indSet, OMinusAB);
                        if (!test.isIndependent(Ad, Bd, condSetW)) continue;
                        forEveryW = false;
                        break;
                    }
                    if (!forEveryW) break;
                }
                if (forEveryW == existsEdgeABgamma) continue;
                forAllAB = false;
                continue block1;
            }
        }
        return forAllAB;
    }

    public static boolean graphInPagStep3(Graph pag, Graph dag) {
        List<Edge> pagEdges = pag.getEdges();
        for (Edge edge : pagEdges) {
            if (edge.getEndpoint1() != Endpoint.TAIL) continue;
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            ArrayList<Node> singletonB = new ArrayList<Node>();
            singletonB.add(Bd);
            List<Node> ancestorsOfB = dag.getAncestors(singletonB);
            if (ancestorsOfB.contains(Ad)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep4(Graph pag, Graph dag) {
        List<Edge> pagEdges = pag.getEdges();
        for (Edge edge : pagEdges) {
            if (edge.getEndpoint2() != Endpoint.ARROW) continue;
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            ArrayList<Node> singletonA = new ArrayList<Node>();
            singletonA.add(Ad);
            List<Node> ancestorsOfA = dag.getAncestors(singletonA);
            if (!ancestorsOfA.contains(Bd)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep5(Graph pag, Graph dag) {
        Set<Triple> pagUnderLines = pag.getUnderLines();
        for (Triple underline : pagUnderLines) {
            Node A = underline.getX();
            Node B = underline.getY();
            Node C = underline.getZ();
            Node Ad = dag.getNode(A.getName());
            Node Bd = dag.getNode(B.getName());
            Node Cd = dag.getNode(C.getName());
            ArrayList<Node> singletonA = new ArrayList<Node>();
            singletonA.add(Ad);
            ArrayList<Node> singletonC = new ArrayList<Node>();
            singletonC.add(Cd);
            List<Node> ancestorsOfA = dag.getAncestors(singletonA);
            List<Node> ancestorsOfC = dag.getAncestors(singletonC);
            if (ancestorsOfA.contains(Bd) || ancestorsOfC.contains(Bd)) continue;
            return false;
        }
        return true;
    }

    public static boolean graphInPagStep6(Graph pag, Graph dag) {
        List<Node> pagNodes = pag.getNodes();
        List<Node> dagNodes = dag.getNodes();
        Set<Triple> pagDottedUnderlines = pag.getDottedUnderlines();
        for (Node B : pagNodes) {
            int i;
            List<Node> parentsOfB = pag.getParents(B);
            HashSet<Node> bParents = new HashSet<Node>(parentsOfB);
            Node[] parents = new Node[bParents.size()];
            for (i = 0; i < parents.length; ++i) {
                parents[i] = (Node)bParents.toArray()[i];
            }
            for (i = 0; i < parents.length; ++i) {
                for (int j = i + 1; j < parents.length; ++j) {
                    Node A = parents[i];
                    Node C = parents[j];
                    for (Triple underline : pagDottedUnderlines) {
                        if (B != underline.getY() || (A != underline.getX() || C != underline.getZ()) && (C != underline.getX() || A != underline.getZ())) continue;
                        Node Ad = dag.getNode(A.getName());
                        Node Cd = dag.getNode(C.getName());
                        List<Node> childrenOfA = dag.getChildren(Ad);
                        List<Node> childrenOfC = dag.getChildren(Cd);
                        ArrayList<Node> commonChildrenAC = new ArrayList<Node>();
                        for (Node childAC : dagNodes) {
                            if (!childrenOfA.contains(childAC) || !childrenOfC.contains(childAC)) continue;
                            commonChildrenAC.add(childAC);
                        }
                        for (Node commonChild : commonChildrenAC) {
                            if (!dag.isDescendentOf(B, commonChild)) continue;
                            return false;
                        }
                    }
                }
            }
        }
        return true;
    }
}

