/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Pattern;
import edu.cmu.tetrad.search.DagInPatternIterator;
import java.util.ArrayList;
import java.util.List;

public class PatternToDag {
    private Pattern pattern;

    public PatternToDag(Pattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("Input pattern must not be null");
        }
        this.pattern = new Pattern(pattern);
    }

    public Dag patternToDagMeek() {
        EdgeListGraph dag = new EdgeListGraph(this.pattern);
        while (this.nondirectedEdges(dag).size() > 0) {
            List edges = this.nondirectedEdges(dag);
            Edge edge = (Edge)edges.get(0);
            Node A = edge.getNode1();
            Node B = edge.getNode2();
            dag.setEndpoint(A, B, Endpoint.ARROW);
            for (int i = 1; i < edges.size(); ++i) {
                Edge otherEdge = (Edge)edges.get(i);
                if (otherEdge.getNode1() == B && !dag.isAdjacentTo(A, otherEdge.getNode2())) {
                    dag.setEndpoint(B, otherEdge.getNode2(), Endpoint.ARROW);
                }
                if (otherEdge.getNode2() != B || dag.isAdjacentTo(A, otherEdge.getNode1())) continue;
                dag.setEndpoint(B, otherEdge.getNode1(), Endpoint.ARROW);
            }
            List<Edge> allEdges = dag.getEdges();
            for (Edge otherEdge : allEdges) {
                if (otherEdge.getNode1() != B || otherEdge.getNode2() == A || otherEdge.getEndpoint1() != Endpoint.TAIL || otherEdge.getEndpoint2() != Endpoint.ARROW || !dag.isAdjacentTo(A, otherEdge.getNode2()) || dag.getEdge(A, otherEdge.getNode2()).getEndpoint1() != Endpoint.TAIL || dag.getEdge(A, otherEdge.getNode2()).getEndpoint2() != Endpoint.TAIL) continue;
                dag.setEndpoint(A, otherEdge.getNode2(), Endpoint.ARROW);
            }
            List<Node> allNodes = dag.getNodes();
            for (Edge otherEdge : allEdges) {
                for (Node D : allNodes) {
                    Node C = otherEdge.getNode2();
                    if (otherEdge.getNode1() != B || C == A || otherEdge.getEndpoint1() != Endpoint.TAIL || otherEdge.getEndpoint2() != Endpoint.ARROW || D == A || D == B || D == C || !dag.isAdjacentTo(A, D) || !dag.isAdjacentTo(D, C) || !dag.isAdjacentTo(B, D) || dag.getEdge(A, D).getEndpoint1() != Endpoint.TAIL || dag.getEdge(A, D).getEndpoint2() != Endpoint.TAIL || dag.getEdge(D, C).getEndpoint1() != Endpoint.TAIL || dag.getEdge(D, C).getEndpoint2() != Endpoint.TAIL || dag.getEdge(B, D).getEndpoint1() != Endpoint.TAIL || dag.getEdge(B, D).getEndpoint2() != Endpoint.TAIL || dag.isAdjacentTo(A, C)) continue;
                    dag.setEndpoint(D, C, Endpoint.ARROW);
                }
            }
        }
        return new Dag(dag);
    }

    public Graph patternToDagMeekRules() {
        DagInPatternIterator iterator = new DagInPatternIterator(this.pattern);
        if (iterator.hasNext()) {
            return new EdgeListGraph(iterator.next());
        }
        return null;
    }

    private Edge findUndirectedEdge(Graph graph) {
        for (Edge edge : graph.getEdges()) {
            if (!Edges.isUndirectedEdge(edge)) continue;
            return edge;
        }
        return null;
    }

    private List nondirectedEdges(Graph graph) {
        List<Edge> allEdges = graph.getEdges();
        ArrayList<Edge> nondirected = new ArrayList<Edge>();
        for (Edge edge : allEdges) {
            if (edge.getEndpoint1() != Endpoint.TAIL || edge.getEndpoint2() != Endpoint.TAIL) continue;
            nondirected.add(edge);
        }
        return nondirected;
    }

    public Dag patternToDagDorTarsi() {
        Dag dag = new Dag();
        List<Node> allNodes = this.pattern.getNodes();
        for (Node node : allNodes) {
            dag.addNode(node);
        }
        List<Edge> allEdges = this.pattern.getEdges();
        for (Edge edge : allEdges) {
            if (this.pattern.isDirectedFromTo(edge.getNode1(), edge.getNode2()) && this.pattern.isDirectedFromTo(edge.getNode2(), edge.getNode1())) {
                System.out.println("A bidirected edge was found in the input pattern");
                continue;
            }
            if (this.pattern.isDirectedFromTo(edge.getNode1(), edge.getNode2())) {
                dag.addDirectedEdge(edge.getNode1(), edge.getNode2());
                continue;
            }
            if (!this.pattern.isDirectedFromTo(edge.getNode2(), edge.getNode1())) continue;
            dag.addDirectedEdge(edge.getNode2(), edge.getNode1());
        }
        if (this.nondirectedEdges(this.pattern).size() == 0) {
            return dag;
        }
        while (this.pattern.getNumNodes() > 1) {
            allNodes = this.pattern.getNodes();
            for (Node node : allNodes) {
                List<Node> adjacentNodes = this.pattern.getAdjacentNodes(node);
                ArrayList<Node> neighborNodes = new ArrayList<Node>();
                for (Node adjacent : adjacentNodes) {
                    Edge nodeToAdjacent = this.pattern.getEdge(node, adjacent);
                    if (nodeToAdjacent.getEndpoint1() != Endpoint.TAIL || nodeToAdjacent.getEndpoint2() != Endpoint.TAIL) continue;
                    neighborNodes.add(adjacent);
                }
                ArrayList<Node> parentsUnionNeighbors = new ArrayList<Node>(neighborNodes);
                List<Node> parentNodes = this.pattern.getParents(node);
                for (Node parent : parentNodes) {
                    if (parentsUnionNeighbors.contains(parent)) continue;
                    parentsUnionNeighbors.add(parent);
                }
                boolean isClique = false;
                if (neighborNodes.size() > 0 && this.cliqueSubgraph(this.pattern, parentsUnionNeighbors)) {
                    isClique = true;
                }
                if (this.pattern.getOutdegree(node) != 0 || !isClique) continue;
                List<Edge> undirectedEdges = this.pattern.getEdges(node);
                for (Edge edge : undirectedEdges) {
                    if (edge.getEndpoint1() != Endpoint.TAIL || edge.getEndpoint2() != Endpoint.TAIL) continue;
                    if (edge.getNode1() == node) {
                        dag.addDirectedEdge(edge.getNode2(), node);
                        continue;
                    }
                    dag.addDirectedEdge(edge.getNode1(), node);
                }
                this.pattern.removeNode(node);
            }
        }
        return dag;
    }

    private boolean cliqueSubgraph(Graph g, List<Node> s) {
        int i;
        int n = s.size();
        for (i = 0; i < n; ++i) {
            if (g.getNodes().contains(s.get(i))) continue;
            throw new IllegalArgumentException("s must consist of nodes of g");
        }
        if (n == 1) {
            return true;
        }
        for (i = 0; i < n; ++i) {
            for (int j = i + 1; j < n; ++j) {
                if (g.isAdjacentTo(s.get(i), s.get(j))) continue;
                return false;
            }
        }
        return true;
    }
}

