/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.FasDeterministic;
import edu.cmu.tetrad.search.GraphSearch;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.MeekRules;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.List;

public class Pcd
implements GraphSearch {
    private IndependenceTest independenceTest;
    private Knowledge knowledge = new Knowledge();
    private SepsetMap sepset;
    private int depth = Integer.MAX_VALUE;
    private EdgeListGraph graph;

    public Pcd(IndependenceTest independenceTest) {
        if (independenceTest == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.setKnowledge(this.knowledge);
    }

    public IndependenceTest getIndependenceTest() {
        return this.independenceTest;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        this.knowledge = knowledge;
    }

    public SepsetMap getSepset() {
        return this.sepset;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    @Override
    public Graph search() {
        TetradLogger.getInstance().log("info", "Starting PCD algorithm.");
        TetradLogger.getInstance().log("info", "Independence test = " + this.independenceTest + ".");
        long startTime = System.currentTimeMillis();
        if (this.getIndependenceTest() == null) {
            throw new NullPointerException();
        }
        List<Node> nodes = this.getIndependenceTest().getVariables();
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.TAIL);
        FasDeterministic fas = new FasDeterministic(this.graph, this.getIndependenceTest());
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.getDepth());
        this.sepset = fas.search();
        Knowledge knowledge1 = this.getKnowledge();
        TetradLogger.getInstance().log("info", "Starting PCD Orientation.");
        SearchGraphUtils.pcOrientbk(knowledge1, this.graph, nodes);
        SearchGraphUtils.pcdOrientC(this.getSepset(), this.getIndependenceTest(), knowledge1, this.graph);
        MeekRules rules = new MeekRules();
        rules.setKnowledge(knowledge1);
        rules.orientImplied(this.graph);
        TetradLogger.getInstance().log("info", "Finishing PCD Orientation");
        TetradLogger.getInstance().log("graph", "\nReturning this graph: " + this.graph);
        long endTime = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Elapsed time = " + (double)(endTime - startTime) / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "Finishing PC algorithm.");
        TetradLogger.getInstance().flush();
        return this.graph;
    }

    @Override
    public long getElapsedTime() {
        return 0L;
    }

    public Graph getPartialGraph() {
        return new EdgeListGraph(this.graph);
    }
}

