/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphicalChange;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.PossibleDConnectingPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

class PossibleGraphicalChangeFinder {
    private Graph pag;
    private List<List<Node>> separations;

    public PossibleGraphicalChangeFinder(Graph pag, Collection<Collection<Node>> separations) {
        if (pag == null) {
            throw new NullPointerException("The given pag must not be null.");
        }
        if (separations == null) {
            throw new NullPointerException("The given separation sets must not be null.");
        }
        this.pag = pag;
        this.separations = new ArrayList<List<Node>>();
        for (Collection<Node> sep : separations) {
            this.separations.add(new ArrayList<Node>(sep));
        }
    }

    public List<GraphicalChange> findGraphicalChanges(PossibleDConnectingPath path) {
        List<Node> nodes = path.getPath();
        return null;
    }

    private static class EdgeRemoval
    implements GraphicalChange {
        private Edge edge;

        public EdgeRemoval(Edge edge) {
            if (edge == null) {
                throw new NullPointerException("Edge must not be null.");
            }
            this.edge = edge;
        }

        @Override
        public void apply(Graph g) {
            if (g.containsEdge(this.edge)) {
                g.removeEdge(this.edge);
            }
        }
    }

    private static class DefNonCollider
    implements GraphicalChange {
        private Triple triple;

        public DefNonCollider(Triple triple) {
            if (triple == null) {
                throw new NullPointerException("The given triple must not be null.");
            }
            this.triple = triple;
        }

        @Override
        public void apply(Graph pag) {
            Node x = this.triple.getX();
            Node y = this.triple.getY();
            Node z = this.triple.getZ();
            if (pag.containsNode(x) && pag.containsNode(y) && pag.containsNode(z) && pag.isAdjacentTo(x, y) && pag.isAdjacentTo(y, z) && !pag.isUnderlineTriple(x, y, z)) {
                pag.addUnderlineTriple(x, y, z);
            }
        }
    }

    private static class ColliderOrientation
    implements GraphicalChange {
        private Triple triple;

        public ColliderOrientation(Triple triple) {
            if (triple == null) {
                throw new NullPointerException("The given triple must not be null.");
            }
            this.triple = triple;
        }

        @Override
        public void apply(Graph g) {
            Node x = this.triple.getX();
            Node y = this.triple.getY();
            Node z = this.triple.getZ();
            if (g.containsNode(x) && g.containsNode(y) && g.containsNode(z) && g.isAdjacentTo(x, y) && g.isAdjacentTo(y, z)) {
                g.setEndpoint(x, y, Endpoint.ARROW);
                g.setEndpoint(y, x, Endpoint.TAIL);
                g.setEndpoint(y, z, Endpoint.ARROW);
                g.setEndpoint(z, y, Endpoint.TAIL);
            }
        }
    }
}

