/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.DagInPatternIterator;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestDagInPatternIterator
extends TestCase {
    public TestDagInPatternIterator(String name) {
        super(name);
    }

    public void test1() {
        Dag dag = GraphUtils.randomDag(10, 0, 10, 3, 3, 3, false);
        System.out.println("DAG " + dag);
        Graph pattern = SearchGraphUtils.patternFromDag(dag);
        System.out.println("Pattern " + pattern);
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public void test2() {
        EdgeListGraph pattern = new EdgeListGraph();
        GraphNode x = new GraphNode("X");
        GraphNode y = new GraphNode("Y");
        pattern.addNode(x);
        pattern.addNode(y);
        pattern.addDirectedEdge(x, y);
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public void test3() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        EdgeListGraph pattern = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        pattern.addNode(x1);
        pattern.addNode(x2);
        pattern.addNode(x3);
        pattern.addNode(x4);
        pattern.addNode(x5);
        pattern.addNode(x6);
        pattern.addDirectedEdge(x5, x1);
        pattern.addDirectedEdge(x3, x1);
        pattern.addDirectedEdge(x3, x4);
        pattern.addDirectedEdge(x6, x5);
        pattern.addUndirectedEdge(x1, x6);
        pattern.addUndirectedEdge(x4, x6);
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public void test4() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        EdgeListGraph pattern = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        pattern.addNode(x1);
        pattern.addNode(x2);
        pattern.addNode(x3);
        pattern.addNode(x4);
        pattern.addNode(x5);
        pattern.addNode(x6);
        pattern.addDirectedEdge(x5, x1);
        pattern.addDirectedEdge(x3, x1);
        pattern.addDirectedEdge(x3, x4);
        pattern.addDirectedEdge(x6, x5);
        pattern.addUndirectedEdge(x1, x6);
        pattern.addUndirectedEdge(x4, x6);
        DagInPatternIterator iterator = new DagInPatternIterator(pattern);
        while (iterator.hasNext()) {
            System.out.println(iterator.next());
        }
    }

    public static Test suite() {
        return new TestSuite(TestDagInPatternIterator.class);
    }
}

