/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.search.Dci;
import edu.cmu.tetrad.search.Dci2;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.TestCase;

public class TestDci
extends TestCase {
    public void testExampleTrace2() {
        ContinuousVariable X1 = new ContinuousVariable("X1");
        ContinuousVariable X2 = new ContinuousVariable("X2");
        ContinuousVariable X3 = new ContinuousVariable("X3");
        ContinuousVariable X4 = new ContinuousVariable("X4");
        ContinuousVariable X5 = new ContinuousVariable("X5");
        ContinuousVariable X6 = new ContinuousVariable("X6");
        ContinuousVariable X7 = new ContinuousVariable("X7");
        ContinuousVariable X8 = new ContinuousVariable("X8");
        ContinuousVariable X9 = new ContinuousVariable("X9");
        ContinuousVariable X10 = new ContinuousVariable("X10");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X2, X3, X4, X5, X7, X8, X9, X10));
        G1.addEdge(new Edge(X2, X10, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(X5, X4, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(X7, X9, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(X8, X9, Endpoint.CIRCLE, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(X1, X2, X3, X4, X5, X6, X8, X9, X10));
        G2.addEdge(new Edge(X2, X10, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(X5, X4, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(X8, X9, Endpoint.CIRCLE, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X6, X1, Endpoint.CIRCLE, Endpoint.CIRCLE));
        ArrayList<IndependenceTest> tests = new ArrayList<IndependenceTest>();
        tests.add(new IndTestDSep(G1));
        tests.add(new IndTestDSep(G2));
        Dci search = new Dci(tests);
        System.out.println(search.search());
    }

    public void rtestSyntheticData() {
        ContinuousVariable X1 = new ContinuousVariable("X1");
        ContinuousVariable X2 = new ContinuousVariable("X2");
        ContinuousVariable X3 = new ContinuousVariable("X3");
        ContinuousVariable X4 = new ContinuousVariable("X4");
        ContinuousVariable X5 = new ContinuousVariable("X5");
        ContinuousVariable X6 = new ContinuousVariable("X6");
        ContinuousVariable X7 = new ContinuousVariable("X7");
        ContinuousVariable X8 = new ContinuousVariable("X8");
        ContinuousVariable X9 = new ContinuousVariable("X9");
        ContinuousVariable X10 = new ContinuousVariable("X10");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X2, X3, X4, X5, X7, X8, X9, X10));
        G1.addEdge(new Edge(X2, X10, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X5, X4, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X7, X9, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X8, X9, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(X1, X2, X3, X4, X5, X6, X8, X9, X10));
        G2.addEdge(new Edge(X2, X10, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X5, X4, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X8, X9, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X6, X1, Endpoint.ARROW, Endpoint.TAIL));
        SemPm pm = new SemPm(G1);
        SemIm im = new SemIm(pm);
        DataSet data1 = im.simulateData(1000, false);
        pm = new SemPm(G2);
        im = new SemIm(pm);
        DataSet data2 = im.simulateData(1000, false);
        ArrayList<IndependenceTest> tests = new ArrayList<IndependenceTest>();
        tests.add(new IndTestFisherZ(data1, 0.05));
        tests.add(new IndTestFisherZ(data2, 0.05));
        Dci2 search = new Dci2(tests);
        List<Graph> result = search.search();
        System.out.println(result);
        System.out.println(result.size());
    }

    public void testSyntheticData2() {
        ContinuousVariable X1 = new ContinuousVariable("X1");
        ContinuousVariable X2 = new ContinuousVariable("X2");
        ContinuousVariable X3 = new ContinuousVariable("X3");
        ContinuousVariable X4 = new ContinuousVariable("X4");
        ContinuousVariable X5 = new ContinuousVariable("X5");
        ContinuousVariable X6 = new ContinuousVariable("X6");
        ContinuousVariable X7 = new ContinuousVariable("X7");
        ContinuousVariable X8 = new ContinuousVariable("X8");
        ContinuousVariable X9 = new ContinuousVariable("X9");
        ContinuousVariable X10 = new ContinuousVariable("X10");
        EdgeListGraph G1 = new EdgeListGraph(Arrays.asList(X2, X3, X4, X5, X7, X8, X9, X10));
        G1.addEdge(new Edge(X2, X10, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X5, X4, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X7, X9, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X8, X9, Endpoint.TAIL, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G1.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        EdgeListGraph G2 = new EdgeListGraph(Arrays.asList(X1, X2, X3, X4, X5, X6, X8, X9, X10));
        G2.addEdge(new Edge(X2, X10, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X5, X4, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X8, X9, Endpoint.TAIL, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X10, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X3, X4, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X4, X9, Endpoint.ARROW, Endpoint.ARROW));
        G2.addEdge(new Edge(X6, X1, Endpoint.ARROW, Endpoint.TAIL));
        SemPm pm = new SemPm(G1);
        SemIm im = new SemIm(pm);
        DataSet data1 = im.simulateData(1000, false);
        pm = new SemPm(G2);
        im = new SemIm(pm);
        DataSet data2 = im.simulateData(1000, false);
        ArrayList<IndependenceTest> tests = new ArrayList<IndependenceTest>();
        tests.add(new IndTestFisherZ(data1, 0.05));
        tests.add(new IndTestFisherZ(data2, 0.05));
        Dci search = new Dci(tests);
        List<Graph> result = search.search();
        System.out.println(result);
        System.out.println(result.size());
    }
}

