/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.FmlSearch;
import edu.cmu.tetrad.search.TestPcPattern;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestFmlSearch
extends TestCase {
    public TestFmlSearch(String name) {
        super(name);
    }

    public void test1() {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        Dag dag = GraphUtils.randomDag(7, 0, 7, 3, 3, 3, false);
        System.out.println("True DAG: " + dag + "\n");
        SemPm pm = new SemPm(dag);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(2000, false);
        double alpha = 0.05;
        int maxEdges = 5;
        FmlSearch search = new FmlSearch(data, alpha, maxEdges);
        search.setTrueDag(dag);
        search.setTrueIm(im);
        search.search();
    }

    public static Test suite() {
        return new TestSuite(TestPcPattern.class);
    }
}

