/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataReader;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestGSquare;
import edu.cmu.tetrad.search.IndTestTimeSeries;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndTestGSquare
extends TestCase {
    private final String[] discreteFiles = new String[]{"test_data/embayes_l1x1x2x3MD.dat", "test_data/determinationtest.dat"};
    private IndTestTimeSeries test;

    public TestIndTestGSquare(String name) {
        super(name);
    }

    public void testIsIndependent() {
        try {
            DataSet dataSet = this.getDataSet(1);
            IndTestGSquare test = new IndTestGSquare(dataSet, 0.05);
            List<Node> v = test.getVariables();
            Node x = v.get(0);
            Node y = v.get(1);
            ArrayList<Node> z = new ArrayList<Node>();
            z.add(v.get(2));
            System.out.println(test.isIndependent(x, y, z));
            test.setDeterminationP(0.99);
            System.out.println("X determines Z " + test.determines(z, x));
            System.out.println("Y determines Z " + test.determines(z, y));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testDetermination() {
        try {
            DataSet dataSet = this.getDataSet(1);
            IndTestGSquare test = new IndTestGSquare(dataSet, 0.05);
            Node x = dataSet.getVariable("X4");
            ArrayList<Node> z = new ArrayList<Node>();
            test.setDeterminationP(0.99);
            System.out.println(x + " determined by " + z + ": " + test.determines(z, x));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void rtestChiSquareCutoff() {
        this.test.setAlpha(0.05);
        TestIndTestGSquare.assertEquals(3.84, this.test.chiSquareCutoff(), 0.01);
        this.test.setAlpha(0.01);
        TestIndTestGSquare.assertEquals(6.63, this.test.chiSquareCutoff(), 0.01);
    }

    public DataSet getDataSet(int i) throws IOException {
        String filename = this.discreteFiles[i];
        System.out.println("Loading " + filename);
        DataReader reader = new DataReader();
        reader.setMissingValueMarker("-99");
        return reader.parseTabular(new File(filename));
    }

    private static void printFile(Reader reader) {
        System.out.println();
        BufferedReader br = new BufferedReader(reader);
        try {
            String line;
            while ((line = br.readLine()) != null) {
                System.out.println(line);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static FileReader loadFile(String file) {
        try {
            return new FileReader(file);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException("Error opening file " + file);
        }
    }

    public static Test suite() {
        return new TestSuite(TestIndTestGSquare.class);
    }

    public void setTest(IndTestTimeSeries test) {
        this.test = test;
    }
}

