/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.Discretizer;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.IndTestLogisticRegression;
import edu.cmu.tetrad.search.IndTestTimeSeries;
import edu.cmu.tetrad.search.TestIndTestGSquare;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.RandomUtil;
import java.util.ArrayList;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestIndTestLogisticRegression
extends TestCase {
    private final String[] discreteFiles = new String[]{"test_data/embayes_l1x1x2x3MD.dat", "test_data/determinationtest.dat"};
    private IndTestTimeSeries test;

    public TestIndTestLogisticRegression(String name) {
        super(name);
    }

    public void testIsIndependent() {
        int numPassed = 0;
        for (int i = 0; i < 1; ++i) {
            boolean correct;
            Dag graph = GraphUtils.randomDag(5, 0, 5, 3, 3, 3, false);
            SemPm pm = new SemPm(graph);
            SemIm im = new SemIm(pm);
            DataSet data = im.simulateDataRecursive(1000, false);
            Discretizer discretizer = new Discretizer(data);
            discretizer.setVariablesCopied(true);
            discretizer.equalCounts(data.getVariable(0), 2);
            discretizer.equalCounts(data.getVariable(3), 2);
            data = discretizer.discretize();
            Node x1 = data.getVariable("X1");
            Node x2 = data.getVariable("X2");
            Node x3 = data.getVariable("X3");
            Node x4 = data.getVariable("X4");
            Node x5 = data.getVariable("X5");
            ArrayList<Node> cond = new ArrayList<Node>();
            cond.add(x3);
            cond.add(x4);
            cond.add(x5);
            Node x1Graph = graph.getNode(x1.getName());
            Node x2Graph = graph.getNode(x2.getName());
            ArrayList<Node> condGraph = new ArrayList<Node>();
            for (Node node : cond) {
                condGraph.add(graph.getNode(node.getName()));
            }
            IndTestLogisticRegression test = new IndTestLogisticRegression(data, 0.05);
            IndTestDSep dsep = new IndTestDSep(graph);
            boolean bl = correct = test.isIndependent(x2, x1, cond) == dsep.isIndependent(x2Graph, x1Graph, condGraph);
            if (correct) {
                ++numPassed;
            }
            System.out.println(correct);
        }
        System.out.println(numPassed);
        TestIndTestLogisticRegression.assertTrue(numPassed > 80);
        System.out.println("Seed = " + RandomUtil.getInstance().getSeed());
    }

    public static Test suite() {
        return new TestSuite(TestIndTestGSquare.class);
    }

    public void setTest(IndTestTimeSeries test) {
        this.test = test;
    }
}

