/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.Kpc;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.TestCase;

public class TestKpc
extends TestCase {
    public TestKpc(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
        TetradLogger.getInstance().setLogging(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testBlank() {
    }

    public void rtestkPCSearch() {
        Dag dag = GraphUtils.randomDag(4, 0, 4, 3, 3, 3, true);
        SemPm sem = new SemPm(dag);
        SemIm im = new SemIm(sem);
        DataSet data = im.simulateData(500, false);
        System.out.println("True Graph: \n" + dag);
        Kpc kpc = new Kpc(data, 0.05);
        kpc.setIncompleteCholesky(1.0E-18);
        kpc.search();
        Pc pc = new Pc(new IndTestFisherZ(data, 0.05));
        pc.search();
    }
}

