/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.search.MaxPValueSearch;
import edu.cmu.tetrad.search.TestPcPattern;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMaxPValueSearch
extends TestCase {
    public TestMaxPValueSearch(String name) {
        super(name);
    }

    public void test1() {
        Dag dag = GraphUtils.randomDag(4, 0, 3, 3, 3, 3, false);
        System.out.println("True DAG: " + dag + "\n");
        SemPm pm = new SemPm(dag);
        SemIm im = new SemIm(pm);
        DataSet data = im.simulateData(1000, false);
        double alpha = 0.05;
        int maxEdges = 5;
        MaxPValueSearch search = new MaxPValueSearch(data, alpha, maxEdges);
        search.setTrueDag(dag);
        search.setTrueIm(im);
        MaxPValueSearch.Result result = search.search();
        for (int i = 0; i < result.getDags().size(); ++i) {
            System.out.println("Result #" + (i + 1) + result.getDags().get(i));
            System.out.println("P Value #" + (i + 1) + " = " + result.getPValues().get(i));
        }
    }

    public static Test suite() {
        return new TestSuite(TestPcPattern.class);
    }
}

