/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.MlBayesIm;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionOld;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetrad.search.GesMbFilter;
import edu.cmu.tetrad.search.IndTestChiSquare;
import edu.cmu.tetrad.search.IndTestFisherZ;
import edu.cmu.tetrad.search.IndTestFisherZGeneralizedInverse;
import edu.cmu.tetrad.search.MbUtils;
import edu.cmu.tetrad.search.Mbfs;
import edu.cmu.tetrad.sem.LargeSemSimulator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMbCalculationMethods
extends TestCase {
    public TestMbCalculationMethods(String name) {
        super(name);
    }

    public void testNothing() {
    }

    public void rtest1() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        DecimalFormat nf2 = new DecimalFormat("     0");
        double alphaRegr = 0.05;
        double alphaMbf = 0.05;
        int numIterations = 25;
        int numVars = 100;
        int numEdges = 100;
        int sampleSize = 250;
        boolean latentDataSaved = false;
        int depth = 2;
        System.out.println("Comparison of MBF to Multiple Linear Regression on the \nTask of Calculating the Markov Blanket for a Data Set Simulated \nfrom a Randomly Generated Structural Equation Model.");
        System.out.println();
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Alpha for Regression = " + alphaRegr);
        System.out.println("Number of iterations = " + numIterations);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println(" FP(MB)\t FN(MB)\t  FP(R)\t  FN(R)\t  Truth");
        int r1Sum = 0;
        int r2Sum = 0;
        int r5Sum = 0;
        int i = 0;
        do {
            Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
            Node t = randomGraph.getNodes().get(0);
            Dag trueMbDag = GraphUtils.markovBlanketDag(t, randomGraph);
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, t);
            SemPm semPm1 = new SemPm(randomGraph);
            SemIm semIm1 = new SemIm(semPm1);
            DataSet dataSet = semIm1.simulateData(sampleSize, latentDataSaved);
            double[][] data = dataSet.getDoubleData().viewDice().toArray();
            double[][] regressors = new double[data.length - 1][];
            double[] target = data[0];
            System.arraycopy(data, 1, regressors, 0, regressors.length);
            List<String> allNames = dataSet.getVariableNames();
            String[] names = new String[allNames.size() - 1];
            for (int i1 = 1; i1 < allNames.size(); ++i1) {
                names[i1 - 1] = allNames.get(i1);
            }
            RegressionOld regression = new RegressionOld();
            regression.setRegressors(regressors);
            regression.setRegressorNames(names);
            RegressionResult result = regression.regress(target, "Target");
            ArrayList<String> regressorNames = new ArrayList<String>();
            for (int i1 = 0; i1 < result.getNumRegressors(); ++i1) {
                if (!(result.getP()[i1] < alphaRegr)) continue;
                regressorNames.add(result.getRegressorNames()[i1]);
            }
            regressorNames.remove("const");
            Collections.sort(regressorNames);
            IndTestFisherZ test = new IndTestFisherZ(dataSet, alphaMbf);
            Mbfs mbSearch = new Mbfs(test, depth);
            Graph mbDag1 = mbSearch.search(t.getName());
            List<Node> nodes = mbDag1.getNodes();
            List<String> mbf = this.extractVarNames(nodes, t);
            ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
            mbfAndTruth.retainAll(truth);
            ArrayList regrAndTruth = new ArrayList(regressorNames);
            regrAndTruth.retainAll(truth);
            ArrayList<String> mbfFp = new ArrayList<String>(mbf);
            mbfFp.removeAll(mbfAndTruth);
            int r1 = mbfFp.size();
            r1Sum += r1;
            ArrayList<String> mbfFn = new ArrayList<String>(truth);
            mbfFn.removeAll(mbfAndTruth);
            int r2 = mbfFn.size();
            r2Sum += r2;
            ArrayList regrFp = new ArrayList(regressorNames);
            regrFp.removeAll(regrAndTruth);
            int r3 = regrFp.size();
            ArrayList<String> regrFn = new ArrayList<String>(truth);
            regrFn.removeAll(regrAndTruth);
            int r4 = regrFn.size();
            int r5 = truth.size();
            r5Sum += r5;
            System.out.println(nf2.format(r1) + "\t" + nf2.format(r2) + "\t" + nf2.format(r3) + "\t" + nf2.format(r4) + "\t" + nf2.format(r5));
        } while (++i < numIterations);
        double s1 = (double)r1Sum / (double)numIterations;
        double s2 = (double)r2Sum / (double)numIterations;
        double s5 = (double)r5Sum / (double)numIterations;
        System.out.println("\nAverages:");
        System.out.println(nf.format(s1) + "\t" + nf.format(s2) + "\t" + nf.format(s5));
    }

    public void rtest2() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        DecimalFormat nf2 = new DecimalFormat("     0");
        double alphaMbf = 0.01;
        int numIterations = 25;
        int numVars = 1000;
        int numEdges = 1000;
        int sampleSize = 1000;
        boolean latentDataSaved = false;
        int depth = 2;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of iterations = " + numIterations);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println(" FP(MB)\t FN(MB)\t Truth");
        int r1Sum = 0;
        int r2Sum = 0;
        int r5Sum = 0;
        int i = 0;
        do {
            Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
            Node t = randomGraph.getNodes().get(0);
            Dag trueMbDag = GraphUtils.markovBlanketDag(t, randomGraph);
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, t);
            SemPm semPm1 = new SemPm(randomGraph);
            SemIm semIm1 = new SemIm(semPm1);
            DataSet dataSet = semIm1.simulateData(sampleSize, latentDataSaved);
            IndTestFisherZ test = new IndTestFisherZ(dataSet, alphaMbf);
            Mbfs mbSearch = new Mbfs(test, depth);
            Graph mbDag1 = mbSearch.search(t.getName());
            List<Node> nodes = mbDag1.getNodes();
            List<String> mbf = this.extractVarNames(nodes, t);
            ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
            mbfAndTruth.retainAll(truth);
            ArrayList<String> mbfFp = new ArrayList<String>(mbf);
            mbfFp.removeAll(mbfAndTruth);
            int r1 = mbfFp.size();
            r1Sum += r1;
            ArrayList<String> mbfFn = new ArrayList<String>(truth);
            mbfFn.removeAll(mbfAndTruth);
            int r2 = mbfFn.size();
            r2Sum += r2;
            int r5 = truth.size();
            r5Sum += r5;
            System.out.println(nf2.format(r1) + "\t" + nf2.format(r2) + "\t" + nf2.format(r5));
        } while (++i < numIterations);
        double s1 = (double)r1Sum / (double)numIterations;
        double s2 = (double)r2Sum / (double)numIterations;
        double s5 = (double)r5Sum / (double)numIterations;
        System.out.println("\nAverages:");
        System.out.println(nf.format(s1) + "\t" + nf.format(s2) + "\t" + nf.format(s5));
    }

    public void rtest3() {
        int numIterations = 25;
        int numVars = 300;
        int numEdges = 300;
        int sampleSize = 500;
        boolean latentDataSaved = false;
        int depth = 3;
        System.out.println("Number of iterations = " + numIterations);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println(" FP(MB)\t FN(MB)\t Truth");
        int i = 0;
        do {
            Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
            Node target = randomGraph.getNodes().get(0);
            Dag trueMbDag = GraphUtils.markovBlanketDag(target, randomGraph);
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, target);
            SemPm semPm1 = new SemPm(randomGraph);
            SemIm semIm1 = new SemIm(semPm1);
            DataSet dataSet = semIm1.simulateData(sampleSize, latentDataSaved);
            System.out.println("\n\nTruth = " + truth);
            NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
            for (int j = 1; j <= 20; ++j) {
                double _alpha = 0.001 * (double)j;
                IndTestFisherZ test = new IndTestFisherZ(dataSet, _alpha);
                Mbfs mbSearch = new Mbfs(test, depth);
                Graph mbDag1 = mbSearch.search(target.getName());
                List<Node> estimated = mbDag1.getNodes();
                estimated.remove(dataSet.getVariable(target.getName()));
                System.out.println(nf.format(_alpha) + ": " + estimated);
            }
        } while (++i < numIterations);
    }

    public void rtest4() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        DecimalFormat nf2 = new DecimalFormat("     0");
        double alphaMbf = 0.01;
        int numVars = 2000;
        int numEdges = 2000;
        int sampleSize = 500;
        int depth = 3;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        int r1Sum = 0;
        int r2Sum = 0;
        int r5Sum = 0;
        System.out.println("... creating random DAG");
        Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
        System.out.println("... creating simulator");
        LargeSemSimulator simulator = new LargeSemSimulator(randomGraph);
        System.out.println("... simulating data");
        DataSet dataSet = simulator.simulateDataAcyclic(sampleSize);
        IndTestFisherZGeneralizedInverse test = new IndTestFisherZGeneralizedInverse(dataSet, alphaMbf);
        Mbfs mbSearch = new Mbfs(test, depth);
        System.out.println("\t FP(MB)\t FN(MB)\t Truth\tFound half?");
        List<Node> graphNodes = randomGraph.getNodes();
        for (int i = 0; i < graphNodes.size(); ++i) {
            Node target = graphNodes.get(i);
            Dag trueMbDag = GraphUtils.markovBlanketDag(target, randomGraph);
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, target);
            Graph estimatedMbd = mbSearch.search(target.getName());
            List<Node> estimatedMb = estimatedMbd.getNodes();
            List<String> mbf = this.extractVarNames(estimatedMb, target);
            ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
            mbfAndTruth.retainAll(truth);
            ArrayList<String> mbfFp = new ArrayList<String>(mbf);
            mbfFp.removeAll(mbfAndTruth);
            int r1 = mbfFp.size();
            r1Sum += r1;
            ArrayList<String> mbfFn = new ArrayList<String>(truth);
            mbfFn.removeAll(mbfAndTruth);
            int r2 = mbfFn.size();
            r2Sum += r2;
            int r5 = truth.size();
            r5Sum += r5;
            double proportionCorrect = (double)(r5 - r2) / (double)r5;
            boolean property = (double)r2 == 0.0 && (double)r5 == 0.0 || proportionCorrect >= 0.5;
            System.out.println(i + 1 + ".\t" + nf2.format(r1) + "\t" + nf2.format(r2) + "\t" + nf2.format(r5) + "\t" + (property ? "*" : " ") + "\t(" + nf.format(mbSearch.getElapsedTime()) + " seconds)");
        }
        double s1 = (double)r1Sum / (double)graphNodes.size();
        double s2 = (double)r2Sum / (double)graphNodes.size();
        double s5 = (double)r5Sum / (double)graphNodes.size();
        System.out.println("\nAverages:");
        System.out.println(nf.format(s1) + "\t" + nf.format(s2) + "\t" + nf.format(s5));
    }

    public void rtest5() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        DecimalFormat nf2 = new DecimalFormat("     0");
        double alphaMbf = 0.01;
        int numVars = 300;
        int numEdges = 300;
        int sampleSize = 500;
        int depth = 3;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        int r1Sum = 0;
        int r2Sum = 0;
        int r5Sum = 0;
        System.out.println("... creating random DAG");
        Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
        System.out.println("... creating SEM PM");
        BayesPm bayesPm = new BayesPm(randomGraph);
        System.out.println("... creating SEM IM");
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        System.out.println("... simulating data");
        DataSet dataSet = bayesIm.simulateData(sampleSize, false);
        IndTestChiSquare test = new IndTestChiSquare(dataSet, alphaMbf);
        Mbfs mbSearch = new Mbfs(test, depth);
        System.out.println("\t FP(MB)\t FN(MB)\t Truth\tFound half?");
        List<Node> graphNodes = randomGraph.getNodes();
        for (int i = 0; i < graphNodes.size(); ++i) {
            Node target = graphNodes.get(i);
            Dag trueMbDag = GraphUtils.markovBlanketDag(target, randomGraph);
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, target);
            Graph estimatedMbd = mbSearch.search(target.getName());
            List<Node> estimatedMb = estimatedMbd.getNodes();
            List<String> mbf = this.extractVarNames(estimatedMb, target);
            ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
            mbfAndTruth.retainAll(truth);
            ArrayList<String> mbfFp = new ArrayList<String>(mbf);
            mbfFp.removeAll(mbfAndTruth);
            int r1 = mbfFp.size();
            r1Sum += r1;
            ArrayList<String> mbfFn = new ArrayList<String>(truth);
            mbfFn.removeAll(mbfAndTruth);
            int r2 = mbfFn.size();
            r2Sum += r2;
            int r5 = truth.size();
            r5Sum += r5;
            double proportionCorrect = (double)(r5 - r2) / (double)r5;
            boolean property = (double)r2 == 0.0 && (double)r5 == 0.0 || proportionCorrect >= 0.5;
            System.out.println(i + 1 + ".\t" + nf2.format(r1) + "\t" + nf2.format(r2) + "\t" + nf2.format(r5) + "\t" + (property ? "*" : " ") + "\t(" + nf.format(mbSearch.getElapsedTime()) + " seconds)");
        }
        double s1 = (double)r1Sum / (double)graphNodes.size();
        double s2 = (double)r2Sum / (double)graphNodes.size();
        double s5 = (double)r5Sum / (double)graphNodes.size();
        System.out.println("\nAverages:");
        System.out.println(nf.format(s1) + "\t" + nf.format(s2) + "\t" + nf.format(s5));
    }

    public void rtest6() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        DecimalFormat nf2 = new DecimalFormat("     0");
        double alphaMbf = 0.01;
        int numVars = 500;
        int numEdges = 500;
        int sampleSize = 1000;
        int depth = 2;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println("\t FP(MB)\t FN(MB)\t Truth");
        Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 40, 40, 40, false);
        LargeSemSimulator simulator = new LargeSemSimulator(randomGraph);
        DataSet dataSet = simulator.simulateDataAcyclic(sampleSize);
        IndTestFisherZGeneralizedInverse test = new IndTestFisherZGeneralizedInverse(dataSet, alphaMbf);
        int r1Sum = 0;
        int r2Sum = 0;
        int r5Sum = 0;
        for (int i = 0; i < numVars; ++i) {
            Node t = randomGraph.getNodes().get(i);
            Dag trueMbDag = GraphUtils.markovBlanketDag(t, randomGraph);
            if (trueMbDag.getNumNodes() < 3) continue;
            List<Node> nodes2 = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(nodes2, t);
            Mbfs mbSearch = new Mbfs(test, depth);
            Graph mbDag1 = mbSearch.search(t.getName());
            List<Node> nodes = mbDag1.getNodes();
            List<String> mbf = this.extractVarNames(nodes, t);
            ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
            mbfAndTruth.retainAll(truth);
            ArrayList<String> mbfFp = new ArrayList<String>(mbf);
            mbfFp.removeAll(mbfAndTruth);
            int r1 = mbfFp.size();
            r1Sum += r1;
            ArrayList<String> mbfFn = new ArrayList<String>(truth);
            mbfFn.removeAll(mbfAndTruth);
            int r2 = mbfFn.size();
            r2Sum += r2;
            int r5 = truth.size();
            r5Sum += r5;
            System.out.println(i + ".\t" + nf2.format(r1) + "\t" + nf2.format(r2) + "\t" + nf2.format(r5));
        }
        double s1 = (double)r1Sum / (double)numVars;
        double s2 = (double)r2Sum / (double)numVars;
        double s5 = (double)r5Sum / (double)numVars;
        System.out.println("\nAverages:");
        System.out.println("\t" + nf.format(s1) + "\t" + nf.format(s2) + "\t" + nf.format(s5));
    }

    public void rtest7() {
        double alphaMbf = 0.05;
        int numVars = 1000;
        int numEdges = 1000;
        int sampleSize = 500;
        int depth = 2;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println("... creating random DAG");
        Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 4, 3, 3, false);
        System.out.println("...simulating data");
        BayesPm bayesPm = new BayesPm(randomGraph, 2, 2);
        MlBayesIm bayesIm = new MlBayesIm(bayesPm, 1);
        DataSet dataSet = bayesIm.simulateData(sampleSize, false);
        IndTestChiSquare test = new IndTestChiSquare(dataSet, alphaMbf);
        Mbfs mbSearch = new Mbfs(test, depth);
        GesMbFilter gesFilter = new GesMbFilter(dataSet);
        List<Node> graphNodes = randomGraph.getNodes();
        for (int j = 0; j < 50; ++j) {
            int i = RandomUtil.getInstance().nextInt(graphNodes.size());
            Node target = graphNodes.get(i);
            System.out.println();
            System.out.println("######## EXAMPLE #" + (j + 1) + ": USING " + target + " AS TARGET");
            Dag trueMbDag = GraphUtils.markovBlanketDag(target, randomGraph);
            mbSearch.setTrueMb(trueMbDag);
            System.out.println();
            System.out.println("True MB: " + trueMbDag);
            List<Node> trueNodes = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(trueNodes, target);
            Graph untrimmed = mbSearch.search(target.getName());
            Node dataTarget = dataSet.getVariable(target.getName());
            EdgeListGraph mbResult = new EdgeListGraph(untrimmed);
            MbUtils.trimToMbNodes(mbResult, dataTarget, false);
            MbUtils.trimEdgesAmongParents(mbResult, dataTarget);
            MbUtils.trimEdgesAmongParentsOfChildren(mbResult, dataTarget);
            System.out.println();
            System.out.println("Estimated by MBF: " + mbResult);
            System.out.println();
            this.printReport7(mbResult, target, truth, "MBF");
            List<Node> untrimmedNodes = untrimmed.getNodes();
            Graph estimate2 = gesFilter.filter(untrimmedNodes, target);
            System.out.println();
            System.out.println("Estimated by GES from untrimmed MBF nodes: " + estimate2);
            this.printReport7(estimate2, target, truth, "MBF+GES");
        }
    }

    public void rtest8() {
        double alphaMbf = 0.01;
        int numVars = 50;
        int numEdges = 50;
        int sampleSize = 500;
        int depth = -1;
        double minimumImprovement = 5.0;
        System.out.println("Alpha for MBF = " + alphaMbf);
        System.out.println("Number of variables = " + numVars);
        System.out.println("Number of randomly selected edges = " + numEdges);
        System.out.println("Sample size of randomly simulated data  = " + sampleSize);
        System.out.println("Depth for MBF = " + depth);
        System.out.println();
        System.out.println();
        System.out.println("... creating random DAG");
        Dag randomGraph = GraphUtils.randomDag(numVars, 0, numEdges, 4, 3, 3, false);
        System.out.println("... creating simulator");
        LargeSemSimulator simulator = new LargeSemSimulator(randomGraph);
        System.out.println("... simulating data");
        DataSet dataSet = simulator.simulateDataAcyclic(sampleSize);
        IndTestFisherZGeneralizedInverse test = new IndTestFisherZGeneralizedInverse(dataSet, alphaMbf);
        Mbfs mbSearch = new Mbfs(test, depth);
        GesMbFilter filter = new GesMbFilter(dataSet);
        List<Node> graphNodes = randomGraph.getNodes();
        for (int i = 0; i < graphNodes.size(); ++i) {
            Node target = graphNodes.get(i);
            System.out.println();
            System.out.println("######## USING " + target + " AS TARGET");
            Dag trueMbDag = GraphUtils.markovBlanketDag(target, randomGraph);
            System.out.println();
            System.out.println("True MB: " + trueMbDag);
            List<Node> trueNodes = trueMbDag.getNodes();
            List<String> truth = this.extractVarNames(trueNodes, target);
            Graph estimate1 = mbSearch.search(target.getName());
            List<Node> nodes = estimate1.getNodes();
            estimate1 = filter.filter(nodes, target);
            System.out.println();
            System.out.println("Estimated by MBF-GES: " + estimate1);
            Graph estimate2 = filter.filter(graphNodes, target);
            System.out.println();
            System.out.println("Estimated by GES: " + estimate2);
            this.printReport7(estimate2, target, truth, "GES");
        }
    }

    private void printReport7(Graph estimatedMbd, Node target, List<String> truth, String label) {
        List<Node> estimatedMb = estimatedMbd.getNodes();
        List<String> mbf = this.extractVarNames(estimatedMb, target);
        ArrayList<String> mbfAndTruth = new ArrayList<String>(mbf);
        mbfAndTruth.retainAll(truth);
        ArrayList<String> mbfFp = new ArrayList<String>(mbf);
        mbfFp.removeAll(mbfAndTruth);
        int r1 = mbfFp.size();
        ArrayList<String> mbfFn = new ArrayList<String>(truth);
        mbfFn.removeAll(mbfAndTruth);
        int r2 = mbfFn.size();
        int r5 = truth.size();
        System.out.println(label + ": Nodes in MB (i.e. w/o target): FP = " + r1 + ", FN = " + r2 + ", TRUTH = " + r5);
    }

    private List<String> extractVarNames(List<Node> nodes, Node target) {
        ArrayList<String> varNames = new ArrayList<String>();
        for (Node node : nodes) {
            varNames.add(node.getName());
        }
        varNames.remove(target.getName());
        Collections.sort(varNames);
        return varNames;
    }

    public static Test suite() {
        return new TestSuite(TestMbCalculationMethods.class);
    }
}

