/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphConverter;
import edu.cmu.tetrad.search.IndTestDSep;
import edu.cmu.tetrad.search.Pc;
import edu.cmu.tetrad.search.Pcd;
import edu.cmu.tetrad.util.TetradLogger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestPcd
extends TestCase {
    public TestPcd(String name) {
        super(name);
    }

    @Override
    public void setUp() throws Exception {
        TetradLogger.getInstance().addOutputStream(System.out);
        TetradLogger.getInstance().setForceLog(true);
    }

    @Override
    public void tearDown() {
        TetradLogger.getInstance().setForceLog(false);
        TetradLogger.getInstance().removeOutputStream(System.out);
    }

    public void testSearch1() {
        this.checkSearch("X1-->X2,X1-->X3,X2-->X4,X3-->X4", "X1---X2,X1---X3,X2-->X4,X3-->X4");
    }

    public void testSearch2() {
        this.checkSearch("A-->D,A-->B,B-->D,C-->D,D-->E", "A-->D,A---B,B-->D,C-->D,D-->E");
    }

    public void testSearch3() {
        Knowledge knowledge = new Knowledge();
        knowledge.setEdgeForbidden("B", "D", true);
        knowledge.setEdgeForbidden("D", "B", true);
        this.checkWithKnowledge("A-->B,C-->B,B-->D", "A-->B,C-->B,D", knowledge);
    }

    private void checkSearch(String inputGraph, String outputGraph) {
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        Pcd pc = new Pcd(independence);
        Graph resultGraph = pc.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPcd.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    private void checkWithKnowledge(String inputGraph, String outputGraph, Knowledge knowledge) {
        Graph graph = GraphConverter.convert(inputGraph);
        IndTestDSep independence = new IndTestDSep(graph);
        Pc pc = new Pc(independence);
        pc.setKnowledge(knowledge);
        Graph resultGraph = pc.search();
        Graph trueGraph = GraphConverter.convert(outputGraph);
        System.out.println("\nKnowldge:");
        System.out.println(knowledge);
        System.out.println("\nInput graph:");
        System.out.println(graph);
        System.out.println("\nResult graph:");
        System.out.println(resultGraph);
        System.out.println("\nTrue graph:");
        System.out.println(trueGraph);
        TestPcd.assertTrue(((Object)resultGraph).equals(trueGraph));
    }

    public static Test suite() {
        return new TestSuite(TestPcd.class);
    }
}

