/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search;

import edu.cmu.tetrad.data.Knowledge;
import edu.cmu.tetrad.data.KnowledgeEdge;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.Triple;
import edu.cmu.tetrad.search.Fasts;
import edu.cmu.tetrad.search.IndependenceTest;
import edu.cmu.tetrad.search.PossibleDsepTscfci;
import edu.cmu.tetrad.search.SearchGraphUtils;
import edu.cmu.tetrad.search.SearchLogUtils;
import edu.cmu.tetrad.search.SepsetMap;
import edu.cmu.tetrad.util.ChoiceGenerator;
import edu.cmu.tetrad.util.TetradLogger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public final class Tscfci {
    private Graph graph;
    private SepsetMap sepset;
    private Knowledge knowledge = new Knowledge();
    private List<Node> variables = new ArrayList<Node>();
    private IndependenceTest independenceTest;
    private boolean changeFlag = true;
    private boolean completeRuleSetUsed = true;
    private boolean possibleDsepSearchDone = true;
    private boolean noInstantaneousEffect = true;
    private int maxReachablePathLength = -1;
    private Set<Triple> allTriples;
    private Set<Triple> colliderTriples;
    private Set<Triple> noncolliderTriples;
    private Set<Triple> ambiguousTriples;
    private int depth = -1;
    private long elapsedTime;
    private TetradLogger logger = TetradLogger.getInstance();

    public Tscfci(IndependenceTest independenceTest) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
    }

    public Tscfci(IndependenceTest independenceTest, List<Node> searchVars) {
        if (independenceTest == null || this.knowledge == null) {
            throw new NullPointerException();
        }
        this.independenceTest = independenceTest;
        this.variables.addAll(independenceTest.getVariables());
        HashSet<Node> remVars = new HashSet<Node>();
        for (Node node1 : this.variables) {
            boolean search = false;
            for (Node node2 : searchVars) {
                if (!node1.getName().equals(node2.getName())) continue;
                search = true;
            }
            if (search) continue;
            remVars.add(node1);
        }
        this.variables.removeAll(remVars);
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        if (depth < -1) {
            throw new IllegalArgumentException("Depth must be -1 (unlimited) or >= 0: " + depth);
        }
        this.depth = depth;
    }

    public long getElapsedTime() {
        return this.elapsedTime;
    }

    public Graph search() {
        long beginTime = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Starting tsCFCI algorithm.");
        TetradLogger.getInstance().log("info", "Independence test = " + this.independenceTest + ".");
        this.setMaxReachablePathLength(this.maxReachablePathLength);
        LinkedList<Node> nodes = new LinkedList<Node>();
        for (Node variable : this.variables) {
            nodes.add(variable);
        }
        this.graph = new EdgeListGraph(nodes);
        this.graph.fullyConnect(Endpoint.CIRCLE);
        Fasts fas = new Fasts(this.graph, this.independenceTest, this.noInstantaneousEffect);
        fas.setKnowledge(this.getKnowledge());
        fas.setDepth(this.depth);
        this.graph = fas.search();
        this.sepset = fas.getSepsets();
        if (this.isPossibleDsepSearchDone()) {
            long time1 = System.currentTimeMillis();
            this.ruleR0(this.independenceTest, this.depth);
            long time2 = System.currentTimeMillis();
            this.logger.log("info", "Step C: " + (double)(time2 - time1) / 1000.0 + "s");
            long time3 = System.currentTimeMillis();
            PossibleDsepTscfci possibleDSep = new PossibleDsepTscfci(this.graph, this.independenceTest, this.getAmbiguousTriples(), this.getSepset(), this.noInstantaneousEffect);
            possibleDSep.setDepth(this.getDepth());
            possibleDSep.setKnowledge(this.getKnowledge());
            possibleDSep.setMaxReachablePathLength(this.getMaxReachablePathLength());
            this.sepset = possibleDSep.search();
            long time4 = System.currentTimeMillis();
            this.logger.log("info", "Step D: " + (double)(time4 - time3) / 1000.0 + "s");
            this.graph.reorientAllWith(Endpoint.CIRCLE);
        }
        long time5 = System.currentTimeMillis();
        this.fciOrientbk(this.getKnowledge(), this.graph, this.variables);
        if (this.isNoInstantaneousEffect()) {
            this.fciOrientInstEdges(this.getKnowledge(), this.graph, this.variables);
        }
        this.ruleR0(this.independenceTest, this.depth);
        this.getGraph().setAmbiguousTriples(this.getAmbiguousTriples());
        long time6 = System.currentTimeMillis();
        TetradLogger.getInstance().log("info", "Step CI C: " + (double)(time6 - time5) / 1000.0 + "s");
        this.doFinalOrientation();
        long endTime = System.currentTimeMillis();
        this.elapsedTime = endTime - beginTime;
        this.logger.log("graph", "\nReturning this graph: " + this.graph);
        TetradLogger.getInstance().log("info", "\n\nElapsed time = " + (double)this.elapsedTime / 1000.0 + " s");
        TetradLogger.getInstance().log("info", "\nFinishing tsCFCI algorithm.");
        return this.graph;
    }

    public SepsetMap getSepset() {
        return this.sepset;
    }

    public Knowledge getKnowledge() {
        return this.knowledge;
    }

    public void setKnowledge(Knowledge knowledge) {
        if (knowledge == null) {
            throw new NullPointerException();
        }
        this.knowledge = knowledge;
    }

    public boolean isCompleteRuleSetUsed() {
        return this.completeRuleSetUsed;
    }

    public void setCompleteRuleSetUsed(boolean completeRuleSetUsed) {
        this.completeRuleSetUsed = completeRuleSetUsed;
    }

    public boolean isNoInstantaneousEffect() {
        return this.noInstantaneousEffect;
    }

    public void setNoInstantaneousEffect(boolean noInstantaneousEffect) {
        this.noInstantaneousEffect = noInstantaneousEffect;
    }

    public Set<Triple> getColliderTriples() {
        return new HashSet<Triple>(this.colliderTriples);
    }

    public Set<Triple> getNoncolliderTriples() {
        return new HashSet<Triple>(this.noncolliderTriples);
    }

    public Set<Triple> getAmbiguousTriples() {
        return new HashSet<Triple>(this.ambiguousTriples);
    }

    private Graph getGraph() {
        return this.graph;
    }

    private void orig_ruleR0(IndependenceTest test, int depth) {
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.allTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = this.getGraph().getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node x = adjacentNodes.get(combination[0]);
                Node z = adjacentNodes.get(combination[1]);
                if (this.getGraph().isAdjacentTo(x, z)) continue;
                this.allTriples.add(new Triple(x, y, z));
                TripleType type = this.getTripleType(x, y, z, test, depth);
                if (type == TripleType.COLLIDER) {
                    if (this.isArrowpointAllowed(x, y) && this.isArrowpointAllowed(z, y)) {
                        this.getGraph().setEndpoint(x, y, Endpoint.ARROW);
                        this.getGraph().setEndpoint(z, y, Endpoint.ARROW);
                        TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z));
                        this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), x, y, Endpoint.ARROW);
                        this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), z, y, Endpoint.ARROW);
                    }
                    this.colliderTriples.add(new Triple(x, y, z));
                    continue;
                }
                if (type == TripleType.NONCOLLIDER) {
                    this.noncolliderTriples.add(new Triple(x, y, z));
                    TetradLogger.getInstance().log("tripleClassifications", "Noncollider: " + Triple.pathString(this.graph, x, y, z));
                    continue;
                }
                Triple triple = new Triple(x, y, z);
                this.ambiguousTriples.add(triple);
                this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                TetradLogger.getInstance().log("tripleClassifications", "AmbiguousTriples: " + Triple.pathString(this.graph, x, y, z));
            }
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private void ruleR0(IndependenceTest test, int depth) {
        Node z;
        TetradLogger.getInstance().log("info", "Starting Collider Orientation:");
        this.allTriples = new HashSet<Triple>();
        this.colliderTriples = new HashSet<Triple>();
        this.noncolliderTriples = new HashSet<Triple>();
        this.ambiguousTriples = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            int[] combination;
            List<Node> adjacentNodes = this.getGraph().getAdjacentNodes(y);
            if (adjacentNodes.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacentNodes.size(), 2);
            while ((combination = cg.next()) != null) {
                Node x = adjacentNodes.get(combination[0]);
                Node z2 = adjacentNodes.get(combination[1]);
                if (this.getGraph().isAdjacentTo(x, z2)) continue;
                this.allTriples.add(new Triple(x, y, z2));
                TripleType type = this.getTripleType(x, y, z2, test, depth);
                if (type == TripleType.COLLIDER) {
                    TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z2));
                    this.colliderTriples.add(new Triple(x, y, z2));
                    continue;
                }
                if (type == TripleType.NONCOLLIDER) {
                    this.noncolliderTriples.add(new Triple(x, y, z2));
                    TetradLogger.getInstance().log("tripleClassifications", "Noncollider: " + Triple.pathString(this.graph, x, y, z2));
                    continue;
                }
                Triple triple = new Triple(x, y, z2);
                this.ambiguousTriples.add(triple);
                this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
                TetradLogger.getInstance().log("tripleClassifications", "AmbiguousTriples: " + Triple.pathString(this.graph, x, y, z2));
            }
        }
        System.out.println("Finally orient colliders.");
        HashSet<Triple> tempTriple = new HashSet<Triple>();
        HashSet<Triple> tempTriple1 = new HashSet<Triple>();
        for (Node y : this.getGraph().getNodes()) {
            for (Triple triple : this.colliderTriples) {
                if (!triple.getY().getName().equals(y.getName())) continue;
                int tiery = this.knowledge.isInWhichTier(y);
                Node x = triple.getX();
                z = triple.getZ();
                String _x = x.getName();
                String _z = z.getName();
                for (Triple triple1 : this.noncolliderTriples) {
                    if (!triple1.getY().getName().equals(y.getName())) continue;
                    Node x1 = triple1.getX();
                    Node y1 = triple1.getY();
                    Node z1 = triple1.getZ();
                    String _x1 = x1.getName();
                    String _y1 = y1.getName();
                    String _z1 = z1.getName();
                    if (_x.equals(_x1) && this.graph.getEndpoint(x, y) == Endpoint.CIRCLE && this.graph.getEndpoint(z1, y) == Endpoint.ARROW) {
                        System.out.println(this.graph.getEdge(x, y));
                        tempTriple.add(triple);
                        tempTriple1.add(triple1);
                    }
                    if (_x.equals(_z1) && this.graph.getEndpoint(x, y) == Endpoint.CIRCLE && this.graph.getEndpoint(x1, y) == Endpoint.ARROW) {
                        System.out.println(this.graph.getEdge(x, y));
                        tempTriple.add(triple);
                        tempTriple1.add(triple1);
                    }
                    if (_z.equals(_x1) && this.graph.getEndpoint(z, y) == Endpoint.CIRCLE && this.graph.getEndpoint(z1, y) == Endpoint.ARROW) {
                        System.out.println(this.graph.getEdge(z, y));
                        tempTriple.add(triple);
                        tempTriple1.add(triple1);
                    }
                    if (!_z.equals(_z1) || this.graph.getEndpoint(z, y) != Endpoint.CIRCLE || this.graph.getEndpoint(x1, y) != Endpoint.ARROW) continue;
                    System.out.println(this.graph.getEdge(z, y));
                    tempTriple.add(triple);
                    tempTriple1.add(triple1);
                }
            }
        }
        for (Triple triple : tempTriple) {
            this.colliderTriples.remove(triple);
            this.ambiguousTriples.add(triple);
            this.getGraph().addAmbiguousTriple(triple.getX(), triple.getY(), triple.getZ());
        }
        for (Triple triple1 : tempTriple1) {
            this.noncolliderTriples.remove(triple1);
            this.ambiguousTriples.add(triple1);
            this.getGraph().addAmbiguousTriple(triple1.getX(), triple1.getY(), triple1.getZ());
        }
        for (Triple triple : this.colliderTriples) {
            Node x = triple.getX();
            Node y = triple.getY();
            z = triple.getZ();
            if (!this.isArrowpointAllowed(x, y) || !this.isArrowpointAllowed(z, y)) continue;
            this.getGraph().setEndpoint(x, y, Endpoint.ARROW);
            this.getGraph().setEndpoint(z, y, Endpoint.ARROW);
            TetradLogger.getInstance().log("tripleClassifications", "Collider: " + Triple.pathString(this.graph, x, y, z));
            this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), x, y, Endpoint.ARROW);
            this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), z, y, Endpoint.ARROW);
        }
        TetradLogger.getInstance().log("info", "Finishing Collider Orientation.");
    }

    private TripleType getTripleType(Node x, Node y, Node z, IndependenceTest test, int depth) {
        boolean existsSepsetContainingY = false;
        boolean existsSepsetNotContainingY = false;
        HashSet<Node> __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(x));
        __nodes.remove(z);
        int indx_tier = this.knowledge.isInWhichTier(x);
        int indz_tier = this.knowledge.isInWhichTier(z);
        int max_tier = Math.max(indx_tier, indz_tier);
        ArrayList<Node> notParents = new ArrayList<Node>();
        for (Node temp_node : __nodes) {
            int temptier = this.knowledge.isInWhichTier(temp_node);
            if (!this.isNoInstantaneousEffect() && temptier > max_tier) {
                notParents.add(temp_node);
            }
            if (!this.isNoInstantaneousEffect() || temptier < max_tier) continue;
            notParents.add(temp_node);
        }
        for (int i = 0; i < notParents.size(); ++i) {
            __nodes.remove(notParents.get(i));
        }
        LinkedList<Node> _nodes = new LinkedList<Node>(__nodes);
        int _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (int d = 0; d <= _depth; ++d) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                List<Node> condSet = Tscfci.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        __nodes = new HashSet<Node>(this.getGraph().getAdjacentNodes(z));
        __nodes.remove(x);
        ArrayList<Node> notParents1 = new ArrayList<Node>();
        for (Node temp_node : __nodes) {
            int temptier = this.knowledge.isInWhichTier(temp_node);
            if (!this.isNoInstantaneousEffect() && temptier > max_tier) {
                notParents1.add(temp_node);
            }
            if (!this.isNoInstantaneousEffect() || temptier < max_tier) continue;
            notParents1.add(temp_node);
        }
        for (int i = 0; i < notParents1.size(); ++i) {
            __nodes.remove(notParents1.get(i));
        }
        _nodes = new LinkedList<Node>(__nodes);
        _depth = depth;
        if (_depth == -1) {
            _depth = 1000;
        }
        _depth = Math.min(_depth, _nodes.size());
        for (int d = 0; d <= _depth; ++d) {
            int[] choice;
            ChoiceGenerator cg = new ChoiceGenerator(_nodes.size(), d);
            while ((choice = cg.next()) != null) {
                List<Node> condSet = Tscfci.asList(choice, _nodes);
                if (!test.isIndependent(x, z, condSet)) continue;
                if (condSet.contains(y)) {
                    existsSepsetContainingY = true;
                    continue;
                }
                existsSepsetNotContainingY = true;
            }
        }
        List<Node> condSet = this.getSepset().get(x, z);
        if (condSet != null) {
            if (condSet.contains(y)) {
                existsSepsetContainingY = true;
            } else {
                existsSepsetNotContainingY = true;
            }
        }
        if (existsSepsetContainingY == existsSepsetNotContainingY) {
            return TripleType.AMBIGUOUS;
        }
        if (!existsSepsetNotContainingY) {
            return TripleType.NONCOLLIDER;
        }
        return TripleType.COLLIDER;
    }

    private static List<Node> asList(int[] indices, List<Node> nodes) {
        LinkedList<Node> list = new LinkedList<Node>();
        for (int i : indices) {
            list.add(nodes.get(i));
        }
        return list;
    }

    private void doFinalOrientation() {
        while (this.changeFlag) {
            this.changeFlag = false;
            this.ruleR3();
            this.rulesR1R2cycle();
            this.ruleR4();
        }
        if (this.isCompleteRuleSetUsed()) {
            do {
                this.changeFlag = false;
                this.rulesR8R9R10();
            } while (this.changeFlag);
        }
    }

    private void rulesR1R2cycle() {
        List<Node> nodes = this.graph.getNodes();
        for (Node B : nodes) {
            int[] combination;
            List<Node> adj = this.graph.getAdjacentNodes(B);
            if (adj.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adj.size(), 2);
            while ((combination = cg.next()) != null) {
                Node A = adj.get(combination[0]);
                Node C = adj.get(combination[1]);
                this.ruleR1(A, B, C);
                this.ruleR1(C, B, A);
                this.ruleR2(A, B, C);
                this.ruleR2(C, B, A);
            }
        }
    }

    private void ruleR1(Node a, Node b, Node c) {
        if (this.graph.isAdjacentTo(a, c)) {
            return;
        }
        if (!this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
            return;
        }
        if (this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
            if (!this.isArrowpointAllowed(b, c)) {
                return;
            }
            this.graph.setEndpoint(c, b, Endpoint.TAIL);
            this.graph.setEndpoint(b, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from collider", this.graph.getEdge(b, c)));
            this.orientSimilarPairs(this.graph, this.getKnowledge(), c, b, Endpoint.TAIL);
            this.orientSimilarPairs(this.graph, this.getKnowledge(), b, c, Endpoint.ARROW);
        }
    }

    private void ruleR2(Node a, Node b, Node c) {
        if (!this.graph.isAdjacentTo(a, c)) {
            return;
        }
        if (this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(b, a) == Endpoint.TAIL && this.graph.getEndpoint(a, c) == Endpoint.CIRCLE && this.graph.getEndpoint(b, c) == Endpoint.ARROW) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.graph.setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (a)", this.graph.getEdge(a, c)));
            this.orientSimilarPairs(this.graph, this.getKnowledge(), a, c, Endpoint.ARROW);
        } else if (this.graph.getEndpoint(a, b) == Endpoint.ARROW && this.graph.getEndpoint(a, c) == Endpoint.CIRCLE && this.graph.getEndpoint(b, c) == Endpoint.ARROW && this.graph.getEndpoint(c, b) == Endpoint.TAIL) {
            if (!this.isArrowpointAllowed(a, c)) {
                return;
            }
            this.graph.setEndpoint(a, c, Endpoint.ARROW);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Away from ancestor (b)", this.graph.getEdge(a, c)));
            this.orientSimilarPairs(this.graph, this.getKnowledge(), a, c, Endpoint.ARROW);
        }
    }

    private void ruleR3() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> intoBArrows = this.graph.getNodesInTo(b, Endpoint.ARROW);
            List<Node> intoBCircles = this.graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node d : intoBCircles) {
                int[] choice;
                if (intoBArrows.size() < 2 || this.graph.getEndpoint(d, b) == Endpoint.ARROW) continue;
                ChoiceGenerator gen = new ChoiceGenerator(intoBArrows.size(), 2);
                while ((choice = gen.next()) != null) {
                    Node c;
                    Node a = intoBArrows.get(choice[0]);
                    if (this.graph.isAdjacentTo(a, c = intoBArrows.get(choice[1])) || !this.graph.isAdjacentTo(a, d) || !this.graph.isAdjacentTo(c, d) || !this.getNoncolliderTriples().contains(new Triple(a, d, c)) || this.graph.getEndpoint(a, d) != Endpoint.CIRCLE || this.graph.getEndpoint(c, d) != Endpoint.CIRCLE || !this.isArrowpointAllowed(d, b)) continue;
                    this.graph.setEndpoint(d, b, Endpoint.ARROW);
                    TetradLogger.getInstance().log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Double triangle", this.getGraph().getEdge(d, b)));
                    this.changeFlag = true;
                    this.orientSimilarPairs(this.graph, this.getKnowledge(), d, b, Endpoint.ARROW);
                }
            }
        }
    }

    private void ruleR4() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> possA = this.graph.getNodesOutTo(b, Endpoint.ARROW);
            List<Node> possC = this.graph.getNodesInTo(b, Endpoint.CIRCLE);
            for (Node a : possA) {
                for (Node c : possC) {
                    if (!this.graph.isParentOf(a, c)) continue;
                    LinkedList<Node> reachable = new LinkedList<Node>();
                    reachable.add(a);
                    this.reachablePathFind(a, b, c, reachable);
                }
            }
        }
    }

    private void reachablePathFind(Node a, Node b, Node c, LinkedList<Node> reachable) {
        HashSet<Node> cParents = new HashSet<Node>(this.graph.getParents(c));
        HashSet<Node> visited = new HashSet<Node>();
        visited.add(b);
        visited.add(c);
        while (reachable.size() > 0) {
            Node x = reachable.removeFirst();
            visited.add(x);
            List<Node> pathExtensions = this.graph.getNodesInTo(x, Endpoint.ARROW);
            pathExtensions.removeAll(visited);
            for (Node d : pathExtensions) {
                if (!this.graph.isAdjacentTo(d, c)) {
                    this.doDdpOrientation(d, a, b, c);
                    return;
                }
                if (!cParents.contains(d) || this.graph.getEndpoint(x, d) != Endpoint.ARROW) continue;
                reachable.add(d);
            }
        }
    }

    private void doDdpOrientation(Node d, Node a, Node b, Node c) {
        List<Node> sepset = this.sepset.get(d, c);
        if (sepset == null) {
            System.out.println("d and c" + d + ", " + c);
            throw new IllegalArgumentException("The edge from d to c must have been removed at this point.");
        }
        TripleType dbc = this.getTripleType(d, b, c, this.independenceTest, this.depth);
        System.out.println("Triple<" + d + ", " + b + ", " + c + "> = " + (Object)((Object)dbc));
        if (dbc == TripleType.NONCOLLIDER) {
            System.out.println("DDP orientation: " + c + " *-- " + b);
            this.graph.setEndpoint(c, b, Endpoint.TAIL);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Definite discriminating path d = " + d, this.graph.getEdge(b, c)));
            this.changeFlag = true;
            this.orientSimilarPairs(this.graph, this.getKnowledge(), c, b, Endpoint.TAIL);
        } else if (dbc == TripleType.COLLIDER) {
            if (!this.isArrowpointAllowed(a, b)) {
                return;
            }
            if (!this.isArrowpointAllowed(c, b)) {
                return;
            }
            this.graph.setEndpoint(a, b, Endpoint.ARROW);
            this.graph.setEndpoint(c, b, Endpoint.ARROW);
            this.logger.log("colliderOrientations", SearchLogUtils.colliderOrientedMsg("Definite discriminating path.. d = " + d, a, b, c));
            this.changeFlag = true;
            this.orientSimilarPairs(this.graph, this.getKnowledge(), a, b, Endpoint.ARROW);
            this.orientSimilarPairs(this.graph, this.getKnowledge(), c, b, Endpoint.ARROW);
        }
    }

    private void ruleR5() {
        List<Node> nodes = this.graph.getNodes();
        for (Node a : nodes) {
            List<Node> adjacents = this.graph.getNodesInTo(a, Endpoint.CIRCLE);
            for (Node b : adjacents) {
                if (this.graph.getEndpoint(a, b) != Endpoint.CIRCLE || this.graph.getEndpoint(b, a) != Endpoint.CIRCLE) continue;
                List<List<Node>> ucCirclePaths = this.getUcCirclePaths(a, b);
                System.out.println("Circle paths:");
                for (List<Node> path : ucCirclePaths) {
                    System.out.println(GraphUtils.pathString(this.graph, path));
                }
                for (List<Node> u : ucCirclePaths) {
                    if (u.size() < 3) continue;
                    Node c = u.get(1);
                    Node d = u.get(u.size() - 2);
                    System.out.println("a = " + a + " c = " + c + " d = " + d + " b = " + b);
                    if (this.graph.isAdjacentTo(a, d) || this.graph.isAdjacentTo(b, c) || !this.getNoncolliderTriples().contains(new Triple(c, a, b)) || !this.getNoncolliderTriples().contains(new Triple(a, b, d))) continue;
                    ArrayList<Node> u2 = new ArrayList<Node>();
                    u2.add(a);
                    u2.addAll(u);
                    u2.add(b);
                    for (int i = 2; i < u2.size(); ++i) {
                        if (this.getNoncolliderTriples().contains(new Triple((Node)u2.get(i - 2), (Node)u2.get(i - 1), (Node)u2.get(i)))) continue;
                    }
                    this.logger.log("colliderOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle path", this.graph.getEdge(a, b)));
                    this.graph.setEndpoint(a, b, Endpoint.TAIL);
                    this.graph.setEndpoint(b, a, Endpoint.TAIL);
                    this.orientTailPath(u);
                    this.changeFlag = true;
                    this.orientSimilarPairs(this.graph, this.getKnowledge(), a, b, Endpoint.TAIL);
                    this.orientSimilarPairs(this.graph, this.getKnowledge(), b, a, Endpoint.TAIL);
                }
            }
        }
    }

    private void ruleR6R7() {
        List<Node> nodes = this.graph.getNodes();
        for (Node b : nodes) {
            List<Node> adjacents = this.graph.getAdjacentNodes(b);
            if (adjacents.size() < 2) continue;
            ChoiceGenerator cg = new ChoiceGenerator(adjacents.size(), 2);
            int[] choice = cg.next();
            while (choice != null) {
                Node c;
                Node a = adjacents.get(choice[0]);
                if (!this.graph.isAdjacentTo(a, c = adjacents.get(choice[1])) && this.graph.getEndpoint(b, a) == Endpoint.TAIL && this.graph.getEndpoint(c, b) == Endpoint.CIRCLE) {
                    if (this.graph.getEndpoint(a, b) == Endpoint.TAIL) {
                        System.out.println("Single tails (tail) " + c + " *-> " + b);
                        this.graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.graph.getEdge(c, b)));
                        this.changeFlag = true;
                        this.orientSimilarPairs(this.graph, this.getKnowledge(), c, b, Endpoint.TAIL);
                    }
                    if (this.graph.getEndpoint(a, b) == Endpoint.CIRCLE && this.getNoncolliderTriples().contains(new Triple(a, b, c))) {
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Single tails (tail)", this.graph.getEdge(c, b)));
                        this.graph.setEndpoint(c, b, Endpoint.TAIL);
                        this.changeFlag = true;
                        this.orientSimilarPairs(this.graph, this.getKnowledge(), c, b, Endpoint.TAIL);
                    }
                }
                choice = cg.next();
            }
        }
    }

    private void rulesR8R9R10() {
        List<Node> nodes = this.graph.getNodes();
        for (Node c : nodes) {
            List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
            for (Node a : intoCArrows) {
                if (this.graph.getEndpoint(c, a) != Endpoint.CIRCLE || this.ruleR8(a, c) || this.ruleR9(a, c)) continue;
                this.ruleR10(a, c);
            }
        }
    }

    private void orientTailPath(List<Node> path) {
        for (int i = 0; i < path.size() - 1; ++i) {
            Node n1 = path.get(i);
            Node n2 = path.get(i + 1);
            System.out.println("Tail path " + n1 + "---" + n2);
            this.graph.setEndpoint(n1, n2, Endpoint.TAIL);
            this.graph.setEndpoint(n2, n1, Endpoint.TAIL);
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("Orient circle paths", this.graph.getEdge(n1, n2)));
        }
    }

    private List<List<Node>> getUcPdPaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucPdPaths = new LinkedList<List<Node>>();
        LinkedList<Node> soFar = new LinkedList<Node>();
        soFar.add(n1);
        List<Node> adjacencies = this.graph.getAdjacentNodes(n1);
        for (Node curr : adjacencies) {
            this.getUcPdPsHelper(curr, soFar, n2, ucPdPaths);
        }
        return ucPdPaths;
    }

    private void getUcPdPsHelper(Node curr, List<Node> soFar, Node end, List<List<Node>> ucPdPaths) {
        Node prev2;
        if (soFar.contains(curr)) {
            return;
        }
        Node prev = soFar.get(soFar.size() - 1);
        if (this.graph.getEndpoint(prev, curr) == Endpoint.TAIL || this.graph.getEndpoint(curr, prev) == Endpoint.ARROW) {
            return;
        }
        if (soFar.size() >= 2 && this.graph.isAdjacentTo(prev2 = soFar.get(soFar.size() - 2), curr)) {
            return;
        }
        soFar.add(curr);
        if (((Object)curr).equals(end)) {
            ucPdPaths.add(new LinkedList<Node>(soFar));
        } else {
            List<Node> adjacents = this.graph.getAdjacentNodes(curr);
            for (Node next : adjacents) {
                this.getUcPdPsHelper(next, soFar, end, ucPdPaths);
            }
        }
        soFar.remove(soFar.get(soFar.size() - 1));
    }

    private List<List<Node>> getUcCirclePaths(Node n1, Node n2) {
        LinkedList<List<Node>> ucCirclePaths = new LinkedList<List<Node>>();
        List<List<Node>> ucPdPaths = this.getUcPdPaths(n1, n2);
        for (List<Node> path : ucPdPaths) {
            Node sj;
            Node j;
            for (int i = 0; i < path.size() - 1 && this.graph.getEndpoint(j = path.get(i), sj = path.get(i + 1)) == Endpoint.CIRCLE && this.graph.getEndpoint(sj, j) == Endpoint.CIRCLE; ++i) {
                if (i != path.size() - 2) continue;
                ucCirclePaths.add(path);
            }
        }
        return ucCirclePaths;
    }

    private boolean ruleR8(Node a, Node c) {
        List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (!this.graph.isAdjacentTo(a, b) || !this.graph.isAdjacentTo(b, c) || this.graph.getEndpoint(b, a) != Endpoint.TAIL || this.graph.getEndpoint(c, b) != Endpoint.TAIL || this.graph.getEndpoint(a, b) == Endpoint.TAIL) continue;
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R8", this.graph.getEdge(c, a)));
            this.graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), c, a, Endpoint.TAIL);
            return true;
        }
        return false;
    }

    private boolean ruleR9(Node a, Node c) {
        List<List<Node>> ucPdPsToC = this.getUcPdPaths(a, c);
        block0: for (List<Node> u : ucPdPsToC) {
            Node b = u.get(1);
            if (this.graph.isAdjacentTo(b, c) || b == c) continue;
            for (int i = 2; i < u.size(); ++i) {
                if (!this.getNoncolliderTriples().contains(new Triple(u.get(i - 2), u.get(i - 1), u.get(i)))) continue block0;
            }
            this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R9", this.graph.getEdge(c, a)));
            this.graph.setEndpoint(c, a, Endpoint.TAIL);
            this.changeFlag = true;
            this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), c, a, Endpoint.TAIL);
            return true;
        }
        return false;
    }

    private boolean ruleR10(Node a, Node c) {
        List<Node> intoCArrows = this.graph.getNodesInTo(c, Endpoint.ARROW);
        for (Node b : intoCArrows) {
            if (b == a || this.graph.getEndpoint(c, b) != Endpoint.TAIL) continue;
            for (Node d : intoCArrows) {
                if (d == a || d == b || this.graph.getEndpoint(d, c) != Endpoint.TAIL) continue;
                List<List<Node>> ucPdPsToB = this.getUcPdPaths(a, b);
                List<List<Node>> ucPdPsToD = this.getUcPdPaths(a, d);
                block2: for (List<Node> u1 : ucPdPsToB) {
                    Node m = u1.get(1);
                    for (List<Node> u2 : ucPdPsToD) {
                        int i;
                        Node n = u2.get(1);
                        for (i = 2; i < u1.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u1.get(i - 2), u1.get(i - 1), u1.get(i)))) continue block2;
                        }
                        for (i = 2; i < u2.size(); ++i) {
                            if (!this.getNoncolliderTriples().contains(new Triple(u2.get(i - 2), u2.get(i - 1), u2.get(i)))) continue block2;
                        }
                        if (((Object)m).equals(n) || this.graph.isAdjacentTo(m, n)) continue;
                        this.logger.log("impliedOrientations", SearchLogUtils.edgeOrientedMsg("R10", this.graph.getEdge(c, a)));
                        this.graph.setEndpoint(c, a, Endpoint.TAIL);
                        this.changeFlag = true;
                        this.orientSimilarPairs(this.getGraph(), this.getKnowledge(), c, a, Endpoint.TAIL);
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private void fciOrientbk(Knowledge bk, Graph graph, List<Node> variables) {
        Node to;
        Node from;
        KnowledgeEdge edge;
        this.logger.log("info", "Starting BK Orientation.");
        Iterator<KnowledgeEdge> it = bk.forbiddenEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(to, from, Endpoint.ARROW);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
        it = bk.requiredEdgesIterator();
        while (it.hasNext()) {
            edge = it.next();
            from = SearchGraphUtils.translate(edge.getFrom(), variables);
            to = SearchGraphUtils.translate(edge.getTo(), variables);
            if (from == null || to == null || graph.getEdge(from, to) == null) continue;
            graph.setEndpoint(from, to, Endpoint.ARROW);
            graph.setEndpoint(to, from, Endpoint.TAIL);
            this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(from, to)));
        }
    }

    private boolean isArrowpointAllowed(Node x, Node y) {
        if (this.getGraph().getEndpoint(x, y) == Endpoint.ARROW) {
            return true;
        }
        if (this.getGraph().getEndpoint(x, y) == Endpoint.TAIL) {
            return false;
        }
        if (this.getGraph().getEndpoint(y, x) == Endpoint.ARROW && this.getGraph().getEndpoint(x, y) == Endpoint.CIRCLE) {
            return true;
        }
        return !this.knowledge.isForbiddenByTiers(x.getName(), y.getName());
    }

    public boolean isPossibleDsepSearchDone() {
        return this.possibleDsepSearchDone;
    }

    public void setPossibleDsepSearchDone(boolean possibleDsepSearchDone) {
        this.possibleDsepSearchDone = possibleDsepSearchDone;
    }

    public int getMaxReachablePathLength() {
        return this.maxReachablePathLength == Integer.MAX_VALUE ? -1 : this.maxReachablePathLength;
    }

    public void setMaxReachablePathLength(int maxReachablePathLength) {
        if (maxReachablePathLength < -1) {
            throw new IllegalArgumentException("Max path length must be -1 (unlimited) or >= 0: " + maxReachablePathLength);
        }
        this.maxReachablePathLength = maxReachablePathLength == -1 ? Integer.MAX_VALUE : maxReachablePathLength;
    }

    private void fciOrientInstEdges(Knowledge bk, Graph graph, List<Node> variables) {
        this.logger.log("info", "Starting Instantaneous Edge Orientation.");
        int ntiers = bk.getNumTiers();
        for (int i = 0; i < ntiers; ++i) {
            int[] choice;
            List<String> tier = bk.getTier(i);
            ChoiceGenerator cg = new ChoiceGenerator(tier.size(), 2);
            while ((choice = cg.next()) != null) {
                Node nodeB;
                String a = tier.get(choice[0]);
                String b = tier.get(choice[1]);
                Node nodeA = this.independenceTest.getVariable(a);
                if (!graph.isAdjacentTo(nodeA, nodeB = this.independenceTest.getVariable(b))) continue;
                graph.setEndpoint(nodeA, nodeB, Endpoint.ARROW);
                graph.setEndpoint(nodeB, nodeA, Endpoint.ARROW);
                this.logger.log("knowledgeOrientation", SearchLogUtils.edgeOrientedMsg("Knowledge", graph.getEdge(nodeA, nodeB)));
            }
        }
        this.logger.log("info", "Finishing Instantaneous Edge Orientation.");
    }

    private void findDefiniteColliders(Graph graph, List<Node> variables) {
        this.logger.log("info", "Checking if ambiguous triples were oriented as colliders by background knowledge or other collider triples");
        Set<Triple> ambig = this.getAmbiguousTriples();
        Set<Triple> coll = this.getColliderTriples();
        System.out.println("Ambiguous triples: " + ambig);
        for (Triple trip : ambig) {
            Node x = trip.getX();
            Node y = trip.getY();
            Node z = trip.getZ();
            if (graph.isAdjacentTo(x, z) || graph.getEndpoint(x, y) != Endpoint.ARROW || graph.getEndpoint(z, y) != Endpoint.ARROW) continue;
            System.out.println("Ambiguous triple " + x + ", " + y + ", " + z + " redefined as collider triple because of previous background knowledge orientations and other collider orientations.");
            this.colliderTriples.add(trip);
            this.ambiguousTriples.remove(trip);
            graph.removeAmbiguousTriple(x, y, z);
        }
    }

    private void orientSimilarPairs(Graph graph, Knowledge knowledge, Node x, Node y, Endpoint mark) {
        int i;
        int ntiers = knowledge.getNumTiers();
        int indx_tier = knowledge.isInWhichTier(x);
        int indy_tier = knowledge.isInWhichTier(y);
        int tier_diff = Math.max(indx_tier, indy_tier) - Math.min(indx_tier, indy_tier);
        int indx_comp = -1;
        int indy_comp = -1;
        List<String> tier_x = knowledge.getTier(indx_tier);
        List<String> tier_y = knowledge.getTier(indy_tier);
        for (i = 0; i < tier_x.size(); ++i) {
            if (!x.getName().equals(tier_x.get(i))) continue;
            indx_comp = i;
            break;
        }
        for (i = 0; i < tier_y.size(); ++i) {
            if (!y.getName().equals(tier_y.get(i))) continue;
            indy_comp = i;
            break;
        }
        for (i = 0; i < ntiers - tier_diff; ++i) {
            Node y1;
            Node x1;
            String B;
            String A;
            if (indx_tier >= indy_tier) {
                if (i == indy_tier) continue;
                A = knowledge.getTier(i + tier_diff).get(indx_comp);
                B = knowledge.getTier(i).get(indy_comp);
                x1 = this.independenceTest.getVariable(A);
                if (!graph.isAdjacentTo(x1, y1 = this.independenceTest.getVariable(B)) || graph.getEndpoint(x1, y1) != Endpoint.CIRCLE) continue;
                graph.setEndpoint(x1, y1, mark);
                System.out.println("Orient edge by structure knowledge: " + graph.getEdge(x1, y1).toString());
                continue;
            }
            if (i == indx_tier) continue;
            A = knowledge.getTier(i).get(indx_comp);
            B = knowledge.getTier(i + tier_diff).get(indy_comp);
            x1 = this.independenceTest.getVariable(A);
            if (!graph.isAdjacentTo(x1, y1 = this.independenceTest.getVariable(B)) || graph.getEndpoint(x1, y1) != Endpoint.CIRCLE) continue;
            graph.setEndpoint(x1, y1, mark);
            System.out.println("Orient edge by structure knowledge: " + graph.getEdge(x1, y1).toString());
        }
    }

    private static enum TripleType {
        COLLIDER,
        NONCOLLIDER,
        AMBIGUOUS;

    }
}

