/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.math;

import edu.cmu.tetrad.search.fastica.math.Matrix;
import edu.cmu.tetrad.search.fastica.math.Vector;

public class EigenValueDecompositionSymm {
    private double[] eigenValues;
    private double[][] eigenVectors;

    public EigenValueDecompositionSymm(double[][] matrix) {
        int i;
        int i2;
        int m = Matrix.getNumOfRows(matrix);
        int n = Matrix.getNumOfColumns(matrix);
        this.eigenVectors = Matrix.clone(matrix);
        this.eigenValues = Vector.newVector(m);
        double[] accu = Vector.newVector(m);
        for (i2 = 0; i2 < m; ++i2) {
            this.eigenValues[i2] = this.eigenVectors[m - 1][i2];
        }
        for (i2 = m - 1; i2 > 0; --i2) {
            int j;
            double sc = 0.0;
            double h1 = 0.0;
            for (j = 0; j < i2; ++j) {
                sc += Math.abs(this.eigenValues[j]);
            }
            if (sc == 0.0) {
                accu[i2] = this.eigenValues[i2 - 1];
                for (j = 0; j < i2; ++j) {
                    this.eigenValues[j] = this.eigenVectors[i2 - 1][j];
                    this.eigenVectors[i2][j] = 0.0;
                    this.eigenVectors[j][i2] = 0.0;
                }
            } else {
                int j2;
                int j3;
                for (j = 0; j < i2; ++j) {
                    double evj;
                    this.eigenValues[j] = evj = this.eigenValues[j] / sc;
                    h1 += evj * evj;
                }
                double f = this.eigenValues[i2 - 1];
                double g = Math.sqrt(h1);
                if (f > 0.0) {
                    g = -g;
                }
                accu[i2] = sc * g;
                h1 -= f * g;
                this.eigenValues[i2 - 1] = f - g;
                for (j3 = 0; j3 < i2; ++j3) {
                    accu[j3] = 0.0;
                }
                for (j3 = 0; j3 < i2; ++j3) {
                    this.eigenVectors[j3][i2] = f = this.eigenValues[j3];
                    g = accu[j3] + this.eigenVectors[j3][j3] * f;
                    for (int k = j3 + 1; k <= i2 - 1; ++k) {
                        g += this.eigenVectors[k][j3] * this.eigenValues[k];
                        int n2 = k;
                        accu[n2] = accu[n2] + this.eigenVectors[k][j3] * f;
                    }
                    accu[j3] = g;
                }
                f = 0.0;
                for (j3 = 0; j3 < i2; ++j3) {
                    int n3 = j3;
                    accu[n3] = accu[n3] / h1;
                    f += accu[j3] * this.eigenValues[j3];
                }
                double h2 = f / (h1 + h1);
                for (j2 = 0; j2 < i2; ++j2) {
                    int n4 = j2;
                    accu[n4] = accu[n4] - h2 * this.eigenValues[j2];
                }
                for (j2 = 0; j2 < i2; ++j2) {
                    f = this.eigenValues[j2];
                    g = accu[j2];
                    for (int k = j2; k <= i2 - 1; ++k) {
                        double[] dArray = this.eigenVectors[k];
                        int n5 = j2;
                        dArray[n5] = dArray[n5] - (f * accu[k] + g * this.eigenValues[k]);
                    }
                    this.eigenValues[j2] = this.eigenVectors[i2 - 1][j2];
                    this.eigenVectors[i2][j2] = 0.0;
                }
            }
            this.eigenValues[i2] = h1;
        }
        for (i2 = 0; i2 < m - 1; ++i2) {
            int j;
            this.eigenVectors[m - 1][i2] = this.eigenVectors[i2][i2];
            this.eigenVectors[i2][i2] = 1.0;
            double h = this.eigenValues[i2 + 1];
            if (h != 0.0) {
                for (j = 0; j <= i2; ++j) {
                    this.eigenValues[j] = this.eigenVectors[j][i2 + 1] / h;
                }
                for (j = 0; j <= i2; ++j) {
                    int k;
                    double g = 0.0;
                    for (k = 0; k <= i2; ++k) {
                        g += this.eigenVectors[k][i2 + 1] * this.eigenVectors[k][j];
                    }
                    for (k = 0; k <= i2; ++k) {
                        double[] dArray = this.eigenVectors[k];
                        int n6 = j;
                        dArray[n6] = dArray[n6] - g * this.eigenValues[k];
                    }
                }
            }
            for (j = 0; j <= i2; ++j) {
                this.eigenVectors[j][i2 + 1] = 0.0;
            }
        }
        for (i2 = 0; i2 < m; ++i2) {
            this.eigenValues[i2] = this.eigenVectors[m - 1][i2];
            this.eigenVectors[m - 1][i2] = 0.0;
        }
        this.eigenVectors[m - 1][m - 1] = 1.0;
        accu[0] = 0.0;
        double a = 0.0;
        double piv = 0.0;
        double eps = 1.0E-16;
        for (i = 1; i < n; ++i) {
            accu[i - 1] = accu[i];
        }
        accu[n - 1] = 0.0;
        for (i = 0; i < n; ++i) {
            int l;
            piv = Math.max(piv, Math.abs(this.eigenValues[i]) + Math.abs(accu[i]));
            for (l = i; l < n && !(Math.abs(accu[l]) <= eps * piv); ++l) {
            }
            if (l > i) {
                int iter = 0;
                do {
                    ++iter;
                    double f = this.eigenValues[i];
                    double g = (this.eigenValues[i + 1] - f) / (2.0 * accu[i]);
                    double r = EigenValueDecompositionSymm.dist(g, 1.0);
                    if (g < 0.0) {
                        r = -r;
                    }
                    this.eigenValues[i] = accu[i] / (g + r);
                    this.eigenValues[i + 1] = accu[i] * (g + r);
                    double ev1 = this.eigenValues[i + 1];
                    double h = f - this.eigenValues[i];
                    int j = i + 2;
                    while (j < n) {
                        int n7 = j++;
                        this.eigenValues[n7] = this.eigenValues[n7] - h;
                    }
                    a += h;
                    g = this.eigenValues[l];
                    double ac1 = accu[i + 1];
                    double b1 = 1.0;
                    double b2 = 1.0;
                    double b3 = 1.0;
                    double s1 = 0.0;
                    double s2 = 0.0;
                    for (int j4 = l - 1; j4 >= i; --j4) {
                        b3 = b2;
                        b2 = b1;
                        s2 = s1;
                        f = b1 * accu[j4];
                        h = b1 * g;
                        r = EigenValueDecompositionSymm.dist(g, accu[j4]);
                        accu[j4 + 1] = s1 * r;
                        s1 = accu[j4] / r;
                        b1 = g / r;
                        g = b1 * this.eigenValues[j4] - s1 * f;
                        this.eigenValues[j4 + 1] = h + s1 * (b1 * f + s1 * this.eigenValues[j4]);
                        for (int k = 0; k < n; ++k) {
                            h = this.eigenVectors[k][j4 + 1];
                            this.eigenVectors[k][j4 + 1] = s1 * this.eigenVectors[k][j4] + b1 * h;
                            this.eigenVectors[k][j4] = b1 * this.eigenVectors[k][j4] - s1 * h;
                        }
                    }
                    g = -s1 * s2 * b3 * ac1 * accu[i] / ev1;
                    accu[i] = s1 * g;
                    this.eigenValues[i] = b1 * g;
                } while (Math.abs(accu[i]) > eps * piv);
            }
            this.eigenValues[i] = this.eigenValues[i] + a;
            accu[i] = 0.0;
        }
    }

    private static double dist(double a, double b) {
        if (Math.abs(a) > Math.abs(b)) {
            double r = b / a;
            return Math.abs(a) * Math.sqrt(1.0 + r * r);
        }
        if (b != 0.0) {
            double r = a / b;
            return Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return 0.0;
    }

    public double[] getEigenValues() {
        return this.eigenValues;
    }

    public double[][] getEigenVectors() {
        return this.eigenVectors;
    }

    public static void main(String[] args) {
        double[][] mat = Matrix.random(4, 4);
        mat = Matrix.mult(mat, Matrix.transpose(mat));
        System.out.println(Matrix.toString(mat));
        System.out.println();
        EigenValueDecompositionSymm evd = new EigenValueDecompositionSymm(mat);
        System.out.println(Vector.toString(evd.getEigenValues()));
        System.out.println();
        System.out.println(Matrix.toString(evd.getEigenVectors()));
        System.out.println();
    }
}

