/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.swing;

import edu.cmu.tetrad.search.fastica.ContrastFunction;
import edu.cmu.tetrad.search.fastica.EigenValueFilter;
import edu.cmu.tetrad.search.fastica.FastICA;
import edu.cmu.tetrad.search.fastica.FastICAConfig;
import edu.cmu.tetrad.search.fastica.FastICAException;
import edu.cmu.tetrad.search.fastica.ProgressListener;
import edu.cmu.tetrad.search.fastica.swing.FastICAApp;
import edu.cmu.tetrad.search.fastica.swing.FastICAFrame;
import javax.swing.SwingUtilities;

public class FastICAThread
extends Thread {
    private FastICAFrame mainFrame;
    private double[][] inVectors;
    private FastICAConfig config;
    private ContrastFunction conFunction;
    private EigenValueFilter evFilter;
    private ProgressListener listener;
    private FastICA fica;

    public FastICAThread(FastICAFrame mainFrame, double[][] inVectors, FastICAConfig config, ContrastFunction conFunction, EigenValueFilter evFilter) {
        this.mainFrame = mainFrame;
        this.inVectors = inVectors;
        this.config = config;
        this.conFunction = conFunction;
        this.evFilter = evFilter;
        this.listener = null;
        this.fica = null;
    }

    private void lock() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FastICAThread.this.mainFrame.setLock(true);
                }
            });
        }
        catch (Exception exc) {
            FastICAApp.exceptionDialog(exc);
        }
    }

    private void unlock() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FastICAThread.this.mainFrame.setLock(false);
                }
            });
        }
        catch (Exception exc) {
            FastICAApp.exceptionDialog(exc);
        }
    }

    private void save() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FastICAThread.this.mainFrame.saveAudioVectors(FastICAThread.this.fica.getICVectors(), "Analysed Collection");
                }
            });
        }
        catch (Exception exc) {
            FastICAApp.exceptionDialog(exc);
        }
    }

    private void setProgress(int proVal, String proStr) {
        final int tmpVal = proVal;
        final String tmpStr = proStr;
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    FastICAThread.this.mainFrame.setProgress(tmpVal, tmpStr);
                }
            });
        }
        catch (Exception exc) {
            FastICAApp.exceptionDialog(exc);
        }
    }

    @Override
    public void run() {
        this.lock();
        this.listener = new ProgressListener(){

            @Override
            public void progressMade(ProgressListener.ComputationState state, int component, int iteration, int maxComps) {
                switch (state) {
                    case WHITENING: {
                        FastICAThread.this.setProgress(0, "...Whitening...");
                        break;
                    }
                    case SYMMETRIC: {
                        FastICAThread.this.setProgress(1024 * iteration / FastICAThread.this.config.getMaxIterations(), "...Analysing...");
                        break;
                    }
                    case DEFLATION: {
                        int progress = 1024 * (iteration + FastICAThread.this.config.getMaxIterations() * component) / (FastICAThread.this.config.getMaxIterations() * maxComps);
                        FastICAThread.this.setProgress(progress, "...Analysing...");
                        break;
                    }
                    case READY: {
                        FastICAThread.this.setProgress(0, "Ready.");
                    }
                }
            }
        };
        try {
            this.fica = new FastICA(this.inVectors, this.config, this.conFunction, this.evFilter, this.listener);
        }
        catch (FastICAException exc) {
            FastICAApp.exceptionDialog(exc);
            this.unlock();
            return;
        }
        System.gc();
        this.save();
        this.unlock();
    }
}

