/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.fastica.util;

import edu.cmu.tetrad.search.fastica.math.Matrix;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;

public class AudioVector {
    public static double[] readAudioFile(File audioFile, float sampleRate) throws IOException, UnsupportedAudioFileException {
        AudioInputStream audioStream = AudioSystem.getAudioInputStream(audioFile);
        AudioFormat audioFormat = new AudioFormat(sampleRate, 16, 1, true, true);
        DataInputStream dataStream = new DataInputStream(new BufferedInputStream(AudioSystem.getAudioInputStream(audioFormat, audioStream)));
        int m = (int)audioStream.getFrameLength();
        double[] audioData = new double[m];
        for (int i = 0; i < m; ++i) {
            audioData[i] = (double)dataStream.readShort() / 32768.0;
        }
        return audioData;
    }

    public static double[] normalise(double[] audioData, double value) {
        double max = 0.0;
        int m = audioData.length;
        for (int i = 0; i < m; ++i) {
            double tmp = Math.abs(audioData[i]);
            if (!(tmp > max)) continue;
            max = tmp;
        }
        double[] audioDataRes = new double[m];
        max = value / max;
        for (int i = 0; i < m; ++i) {
            audioDataRes[i] = audioData[i] * max;
        }
        return audioDataRes;
    }

    public static double[] normalise(double[] audioData) {
        return AudioVector.normalise(audioData, 1.0);
    }

    public static double[][] toMatrix(double[][] audioVectors) {
        int m = audioVectors.length;
        int n = 0;
        for (int i = 0; i < m; ++i) {
            int tmp = audioVectors[i].length;
            if (tmp <= n) continue;
            n = tmp;
        }
        double[][] audioMatrix = Matrix.newMatrix(m, n);
        for (int i = 0; i < m; ++i) {
            int j;
            for (j = 0; j < audioVectors[i].length; ++j) {
                audioMatrix[i][j] = audioVectors[i][j];
            }
            for (j = audioVectors[i].length; j < n; ++j) {
                audioMatrix[i][j] = 0.0;
            }
        }
        return audioMatrix;
    }

    public static AudioInputStream toAudioInputStream(double[] audioData, float sampleRate) {
        int m = audioData.length;
        AudioFormat format = new AudioFormat(sampleRate, 16, 1, true, false);
        byte[] byteArray = new byte[m * 2];
        for (int i = 0; i < m; ++i) {
            int val = (int)(audioData[i] * 32767.0);
            if (val < 0) {
                val = -val - 1;
                byteArray[i * 2] = (byte)(~(val & 0xFF));
                byteArray[i * 2 + 1] = (byte)(~(val >> 8));
                continue;
            }
            byteArray[i * 2] = (byte)(val & 0xFF);
            byteArray[i * 2 + 1] = (byte)(val >> 8);
        }
        AudioInputStream audioStream = new AudioInputStream(new ByteArrayInputStream(byteArray), format, m);
        return audioStream;
    }
}

