/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.search.test;

import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.regression.RegressionOld;
import edu.cmu.tetrad.regression.RegressionResult;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.RegressionParams;
import edu.cmu.tetradapp.model.RegressionRunner;
import java.util.LinkedList;

public class RegressionRunnerTester {
    public static void main(String[] args) {
        double[] accel = new double[]{7.1, 6.1, 5.8, 4.0, 3.6, 5.5, 4.4, 6.7, 7.8};
        double[] hp = new double[]{250.0, 227.0, 340.0, 180.0, 348.0, 240.0, 190.0, 178.0, 200.0};
        double[] torque = new double[]{250.0, 217.0, 302.0, 145.0, 328.0, 162.0, 138.0, 166.0, 220.0};
        double[] weight = new double[]{3640.0, 3256.0, 4173.0, 1257.0, 2062.0, 2866.0, 1930.0, 2596.0, 3460.0};
        double[] ratio = new double[]{3.6, 3.9, 3.89, 3.62, 3.55, 4.1, 4.53, 4.1, 3.29};
        double[] disp = new double[]{2457.0, 1994.0, 4163.0, 1988.0, 4942.0, 2157.0, 1796.0, 1840.0, 3498.0};
        double[][] regressors = new double[][]{hp, torque, weight, ratio, disp};
        String[] names = new String[]{"Acceleration", "HP", "Torque", "Weight", "RAR", "Disp"};
        LinkedList<Node> variables = new LinkedList<Node>();
        ContinuousVariable accelVar = new ContinuousVariable(names[0]);
        variables.add(accelVar);
        ContinuousVariable hpVar = new ContinuousVariable(names[1]);
        variables.add(hpVar);
        ContinuousVariable torqueVar = new ContinuousVariable(names[2]);
        variables.add(torqueVar);
        ContinuousVariable weightVar = new ContinuousVariable(names[3]);
        variables.add(weightVar);
        ContinuousVariable ratioVar = new ContinuousVariable(names[4]);
        variables.add(ratioVar);
        ContinuousVariable dispVar = new ContinuousVariable(names[5]);
        variables.add(dispVar);
        ColtDataSet accelerations = new ColtDataSet(accel.length, variables);
        int col = accelerations.getVariables().indexOf(accelVar);
        for (int i = 0; i < accel.length; ++i) {
            accelerations.setDouble(i, col, accel[i]);
        }
        int col1 = accelerations.getVariables().indexOf(hpVar);
        for (int i1 = 0; i1 < hp.length; ++i1) {
            accelerations.setDouble(i1, col1, hp[i1]);
        }
        int col2 = accelerations.getVariables().indexOf(torqueVar);
        for (int i2 = 0; i2 < torque.length; ++i2) {
            accelerations.setDouble(i2, col2, torque[i2]);
        }
        int col3 = accelerations.getVariables().indexOf(weightVar);
        for (int i3 = 0; i3 < weight.length; ++i3) {
            accelerations.setDouble(i3, col3, weight[i3]);
        }
        int col4 = accelerations.getVariables().indexOf(ratioVar);
        for (int i4 = 0; i4 < ratio.length; ++i4) {
            accelerations.setDouble(i4, col4, ratio[i4]);
        }
        int col5 = accelerations.getVariables().indexOf(dispVar);
        for (int i5 = 0; i5 < disp.length; ++i5) {
            accelerations.setDouble(i5, col5, disp[i5]);
        }
        DataWrapper dataWrapper = new DataWrapper(accelerations);
        RegressionParams params = new RegressionParams();
        params.setTargetName(names[0]);
        params.setAlpha(0.05);
        RegressionRunner runner = new RegressionRunner(dataWrapper, params);
        runner.execute();
        String report = runner.getResult().toString();
        System.out.println("Report using Regression Runner:");
        System.out.println(report);
        String[] namesD = new String[]{"HP", "Torque", "Weight", "RAR", "Disp"};
        RegressionOld regression = new RegressionOld();
        regression.setRegressors(regressors);
        regression.setRegressorNames(namesD);
        RegressionResult result = regression.regress(accel, "Accel");
        System.out.println("Report using Regression directly:");
        System.out.println(result);
        double[] coeffs = result.getCoef();
    }
}

