/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.DoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.GraphUtils;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemEstimatorGibbs;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemStdErrorEstimator;

public class ExploreSemEstimatorGibbs {
    public static void main(String[] args) {
        Parameter parameter;
        int sampleSize = 200;
        Dag leadGraph = GraphUtils.randomDag(5, 2, 5, 3, 3, 3, false);
        SemPm semPm = new SemPm(leadGraph);
        SemIm semIm = new SemIm(semPm);
        DataSet dat = semIm.simulateData(sampleSize, false);
        CovarianceMatrix covMatrix = new CovarianceMatrix(dat);
        double[][] sampleCovars1 = covMatrix.getMatrix().toArray();
        System.out.println("Graph as retrieved from SemPm");
        System.out.println(semPm.getGraph());
        System.out.println(semIm);
        semIm.setCovMatrix(covMatrix);
        System.out.println(semIm.getEdgeCoef());
        System.out.println(covMatrix);
        boolean flatPrior = true;
        double stretch = 2.0;
        int numIterations = 2500;
        SemEstimatorGibbs gibbsEstimator = new SemEstimatorGibbs(semPm, semIm, sampleCovars1, flatPrior, stretch, numIterations);
        gibbsEstimator.estimate();
        SemIm gibbsSemIm = gibbsEstimator.getEstimatedSem();
        System.out.println(gibbsSemIm);
        DoubleMatrix2D data = gibbsEstimator.getDataSet();
        double[] means = new double[data.rows()];
        for (int i = 0; i < data.rows(); ++i) {
            double v = 0.0;
            for (int j = 0; j < data.columns(); ++j) {
                if (Double.isInfinite(data.get(i, j))) continue;
                v += data.get(i, j);
            }
            means[i] = v /= (double)data.columns();
            parameter = gibbsSemIm.getSemPm().getParameters().get(i);
            gibbsSemIm.setParamValue(parameter, means[i]);
            System.out.println("mean(" + parameter + ") = " + v);
        }
        SemStdErrorEstimator errors = new SemStdErrorEstimator();
        errors.computeStdErrors(gibbsSemIm);
        double[] eArray = errors.getStdErrors();
        for (int i = 0; i < eArray.length; ++i) {
            parameter = gibbsSemIm.getSemPm().getParameters().get(i);
            System.out.println("SE(" + parameter + ") = " + eArray[i]);
        }
        System.out.println("\n\nTest using standard sem estimation.");
        SemEstimator estimator = new SemEstimator(covMatrix, new SemPm(leadGraph));
        estimator.estimate();
        SemStdErrorEstimator errors2 = new SemStdErrorEstimator();
        errors2.computeStdErrors(estimator.getEstimatedSem());
        double[] eArray2 = errors2.getStdErrors();
        for (int i = 0; i < eArray2.length; ++i) {
            Parameter parameter2 = gibbsSemIm.getSemPm().getParameters().get(i);
            System.out.println("SE(" + parameter2.getName() + ") = " + eArray2[i]);
        }
    }
}

