/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Edges;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.TemplateExpander;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.model.calculator.expression.Expression;
import edu.cmu.tetradapp.model.calculator.parser.ExpressionParser;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class GeneralizedSemPm
implements TetradSerializable {
    static final long serialVersionUID = 23L;
    private SemGraph graph;
    private List<Node> nodes;
    private List<Node> variableNodes;
    private List<Node> measuredNodes;
    private List<Node> errorNodes;
    private Map<String, Set<Node>> referencedParameters;
    private Map<Node, Set<Node>> referencedNodes;
    private Map<Node, Expression> nodeExpressions;
    private Map<Node, String> nodeExpressionStrings;
    private Map<String, Expression> parameterExpressions;
    private Map<String, String> parameterExpressionStrings;
    private String variablesTemplate = "TSUM(NEW(b)*$)";
    private String errorsTemplate = "Normal(0, NEW(s))";
    private String parametersTemplate = "U(0, 1)";

    public GeneralizedSemPm(Graph graph) {
        this(new SemGraph(graph));
    }

    public GeneralizedSemPm(SemGraph graph) {
        if (graph == null) {
            throw new NullPointerException("Graph must not be null.");
        }
        this.graph = new SemGraph(graph);
        this.graph.setShowErrorTerms(true);
        for (Edge edge : this.graph.getEdges()) {
            if (!Edges.isBidirectedEdge(edge)) continue;
            throw new IllegalArgumentException("The generalized SEM PM cannot currently deal with bidirected edges. Sorry.");
        }
        this.nodes = Collections.unmodifiableList(this.graph.getNodes());
        this.variableNodes = new ArrayList<Node>();
        this.measuredNodes = new ArrayList<Node>();
        for (Node variable : this.nodes) {
            if (variable.getNodeType() == NodeType.MEASURED || variable.getNodeType() == NodeType.LATENT) {
                this.variableNodes.add(variable);
            }
            if (variable.getNodeType() != NodeType.MEASURED) continue;
            this.measuredNodes.add(variable);
        }
        this.errorNodes = new ArrayList<Node>();
        for (Node variable : this.nodes) {
            if (variable.getNodeType() != NodeType.ERROR) continue;
            this.errorNodes.add(variable);
        }
        this.referencedParameters = new HashMap<String, Set<Node>>();
        this.referencedNodes = new HashMap<Node, Set<Node>>();
        this.nodeExpressions = new HashMap<Node, Expression>();
        this.nodeExpressionStrings = new HashMap<Node, String>();
        this.parameterExpressions = new HashMap<String, Expression>();
        this.parameterExpressionStrings = new HashMap<String, String>();
        try {
            Set<String> parameters;
            String formula;
            String template;
            List<Node> variableNodes = this.getVariableNodes();
            for (int i = 0; i < variableNodes.size(); ++i) {
                Node node = variableNodes.get(i);
                template = this.getVariablesTemplate();
                formula = TemplateExpander.getInstance().expandTemplate(template, this, node);
                this.setNodeExpression(node, formula);
                parameters = this.getReferencedParameters(node);
                for (String parameter : parameters) {
                    this.setParameterExpression(parameter, "Split(-1.5, -.5, .5, 1.5)");
                }
            }
            for (Node node : this.errorNodes) {
                template = this.getErrorsTemplate();
                formula = TemplateExpander.getInstance().expandTemplate(template, this, node);
                this.setNodeExpression(node, formula);
                parameters = this.getReferencedParameters(node);
                for (String parameter : parameters) {
                    this.setParameterExpression(parameter, "U(1, 3)");
                }
            }
        }
        catch (ParseException e) {
            throw new IllegalStateException("Parse error in constructing initial model.", e);
        }
    }

    public GeneralizedSemPm(SemPm semPm) {
        this(semPm.getGraph());
        System.out.println(this);
        try {
            List<Node> variableNodes = this.getVariableNodes();
            for (int i = 0; i < variableNodes.size(); ++i) {
                Node node = variableNodes.get(i);
                List<Node> parents = this.getVariableParents(node);
                StringBuilder buf = new StringBuilder();
                for (int j = 0; j < parents.size(); ++j) {
                    if (!variableNodes.contains(parents.get(j))) continue;
                    Node parent = parents.get(j);
                    Parameter _parameter = semPm.getParameter(parent, node);
                    String parameter = _parameter.getName();
                    HashSet<Node> nodes = new HashSet<Node>();
                    nodes.add(node);
                    this.referencedParameters.put(parameter, nodes);
                    buf.append(parameter);
                    buf.append("*");
                    buf.append(parents.get(j).getName());
                    if (j >= parents.size() - 1) continue;
                    buf.append(" + ");
                }
                if (buf.toString().trim().length() != 0) {
                    buf.append(" + ");
                }
                buf.append(this.errorNodes.get(i));
                this.setNodeExpression(node, buf.toString());
            }
            for (Node node : variableNodes) {
                Parameter _parameter = semPm.getParameter(node, node);
                String parameter = _parameter.getName();
                HashSet<Node> nodes = new HashSet<Node>();
                nodes.add(node);
                this.referencedParameters.put(parameter, nodes);
                String distributionFormula = "N(0, " + parameter + ")";
                this.setNodeExpression(this.getErrorNode(node), distributionFormula);
            }
            System.out.println(this.getParameters());
        }
        catch (ParseException e) {
            throw new IllegalStateException("Parse error in constructing initial model.", e);
        }
    }

    public GeneralizedSemPm(GeneralizedSemPm semPm) {
        this.graph = new SemGraph(semPm.graph);
        this.nodes = new ArrayList<Node>(semPm.nodes);
        this.variableNodes = new ArrayList<Node>(semPm.variableNodes);
        this.measuredNodes = new ArrayList<Node>(semPm.measuredNodes);
        this.errorNodes = new ArrayList<Node>(semPm.errorNodes);
        this.referencedParameters = new HashMap<String, Set<Node>>();
        this.referencedNodes = new HashMap<Node, Set<Node>>();
        for (String parameter : semPm.referencedParameters.keySet()) {
            this.referencedParameters.put(parameter, new HashSet(semPm.referencedParameters.get(parameter)));
        }
        for (Node node : semPm.referencedNodes.keySet()) {
            this.referencedNodes.put(node, new HashSet(semPm.referencedNodes.get(node)));
        }
        this.nodeExpressions = new HashMap<Node, Expression>(semPm.nodeExpressions);
        this.nodeExpressionStrings = new HashMap<Node, String>(semPm.nodeExpressionStrings);
        this.parameterExpressions = new HashMap<String, Expression>(semPm.parameterExpressions);
        this.parameterExpressionStrings = new HashMap<String, String>(semPm.parameterExpressionStrings);
        this.variablesTemplate = semPm.variablesTemplate;
        this.errorsTemplate = semPm.errorsTemplate;
        this.parametersTemplate = semPm.parametersTemplate;
    }

    public static GeneralizedSemPm serializableInstance() {
        Dag dag = new Dag();
        GraphNode node1 = new GraphNode("X");
        dag.addNode(node1);
        return new GeneralizedSemPm(Dag.serializableInstance());
    }

    public Expression getNodeExpression(Node node) {
        return this.nodeExpressions.get(node);
    }

    public String getNodeExpressionString(Node node) {
        return this.nodeExpressionStrings.get(node);
    }

    public void setNodeExpression(Node node, String expressionString) throws ParseException {
        Set<Node> nodes;
        if (node == null) {
            throw new NullPointerException("Node was null.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        ArrayList<String> variableNames = new ArrayList<String>();
        List<Node> parents = this.graph.getParents(node);
        LinkedList<String> parentNames = new LinkedList<String>();
        for (Node parent : parents) {
            parentNames.add(parent.getName());
        }
        for (Node variable : this.nodes) {
            if (!parentNames.contains(variable.getName())) continue;
            parameterNames.remove(variable.getName());
            variableNames.add(variable.getName());
        }
        for (Node variable : this.nodes) {
            if (!parameterNames.contains(variable.getName())) continue;
            throw new IllegalArgumentException("The list of parameter names may not include variables: " + variable.getName());
        }
        LinkedList<String> parametersToRemove = new LinkedList<String>();
        for (String parameter : this.referencedParameters.keySet()) {
            nodes = this.referencedParameters.get(parameter);
            if (nodes.contains(node)) {
                nodes.remove(node);
            }
            if (!nodes.isEmpty()) continue;
            parametersToRemove.add(parameter);
        }
        for (String parameter : parametersToRemove) {
            this.referencedParameters.remove(parameter);
            this.parameterExpressions.remove(parameter);
            this.parameterExpressionStrings.remove(parameter);
        }
        for (String parameterString : parameterNames) {
            if (this.referencedParameters.get(parameterString) == null) {
                this.referencedParameters.put(parameterString, new HashSet());
            }
            nodes = this.referencedParameters.get(parameterString);
            nodes.add(node);
            this.setParameterExpression(parameterString, "U(0, 1)");
        }
        LinkedList<Node> nodesToRemove = new LinkedList<Node>();
        for (Node _node : this.referencedNodes.keySet()) {
            Set<Node> nodes2 = this.referencedNodes.get(_node);
            if (nodes2.contains(node)) {
                nodes2.remove(node);
            }
            if (!nodes2.isEmpty()) continue;
            nodesToRemove.add(_node);
        }
        for (Node _node : nodesToRemove) {
            this.referencedNodes.remove(_node);
        }
        for (String variableString : variableNames) {
            Node _node = this.getNode(variableString);
            if (this.referencedNodes.get(_node) == null) {
                this.referencedNodes.put(_node, new HashSet());
            }
            Set<Node> nodes3 = this.referencedNodes.get(_node);
            nodes3.add(node);
        }
        this.nodeExpressions.put(node, expression);
        this.nodeExpressionStrings.put(node, expressionString);
    }

    public void setParameterExpression(String parameter, String expressionString) throws ParseException {
        if (parameter == null) {
            throw new NullPointerException("Parameter was null.");
        }
        if (expressionString == null) {
            throw new NullPointerException("Expression string was null.");
        }
        ExpressionParser parser = new ExpressionParser();
        Expression expression = parser.parseExpression(expressionString);
        List<String> parameterNames = parser.getParameters();
        if (parameterNames.size() > 0) {
            throw new IllegalArgumentException("Initial distribution may not contain parameters.");
        }
        this.parameterExpressions.put(parameter, expression);
        this.parameterExpressionStrings.put(parameter, expressionString);
    }

    public Set<String> getParameters() {
        return new HashSet<String>(this.parameterExpressions.keySet());
    }

    public Expression setParameterExpression(String parameter) {
        return this.parameterExpressions.get(parameter);
    }

    public String getParameterExpressionString(String parameter) {
        return this.parameterExpressionStrings.get(parameter);
    }

    public SemGraph getGraph() {
        return new SemGraph(this.graph);
    }

    public List<Node> getNodes() {
        return new ArrayList<Node>(this.nodes);
    }

    public List<Node> getVariableNodes() {
        return new ArrayList<Node>(this.variableNodes);
    }

    public List<Node> getMeasuredNodes() {
        return new ArrayList<Node>(this.measuredNodes);
    }

    public List<Node> getErrorNodes() {
        return new ArrayList<Node>(this.errorNodes);
    }

    public Node getVariableNode(Node errorNode) {
        int index = this.errorNodes.indexOf(errorNode);
        if (index == -1) {
            throw new NullPointerException(errorNode + " is not an error node in this model.");
        }
        return this.variableNodes.get(index);
    }

    public Node getErrorNode(Node node) {
        if (this.errorNodes.contains(node)) {
            return node;
        }
        int index = this.variableNodes.indexOf(node);
        if (index == -1) {
            throw new NullPointerException(node + " is not a node in this model.");
        }
        return this.errorNodes.get(index);
    }

    public Node getNode(String name) {
        for (Node node : this.nodes) {
            if (!name.equals(node.getName())) continue;
            return node;
        }
        throw new IllegalArgumentException("There is no variable node by that name in the model: " + name);
    }

    public Set<Node> getReferencingNodes(String parameter) {
        Set<Node> set = this.referencedParameters.get(parameter);
        return set == null ? new HashSet<Node>() : new HashSet<Node>(set);
    }

    public Set<String> getReferencedParameters(Node node) {
        HashSet<String> parameters = new HashSet<String>();
        for (String parameter : this.referencedParameters.keySet()) {
            if (!this.referencedParameters.get(parameter).contains(node)) continue;
            parameters.add(parameter);
        }
        return parameters;
    }

    public Set<Node> getReferencingNodes(Node node) {
        Set<Node> set = this.referencedNodes.get(node);
        return set == null ? new HashSet<Node>() : new HashSet<Node>(set);
    }

    public Set<Node> getReferencedNodes(Node node) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (Node _node : this.referencedNodes.keySet()) {
            if (!this.referencedNodes.get(_node).contains(node)) continue;
            nodes.add(_node);
        }
        return nodes;
    }

    public String nextParameterName(String base, List<String> usedNames) {
        if (this.getGraph().getNode(base) != null) {
            throw new IllegalArgumentException(base + " is a variable name.");
        }
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (String parameter : this.referencedParameters.keySet()) {
                if (!parameter.equals(name)) continue;
                continue block0;
            }
            for (String parameter : usedNames) {
                if (!parameter.equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    public List<Node> getParents(Node node) {
        List<Node> parents = this.graph.getParents(node);
        parents = this.putErrorNodesLast(parents);
        return new ArrayList<Node>(parents);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\nEquations:\n");
        for (Node node : this.variableNodes) {
            buf.append("\n").append(node).append(" = ").append(this.nodeExpressionStrings.get(node));
        }
        buf.append("\n\nDistributions:\n");
        for (Node node : this.errorNodes) {
            buf.append("\n").append(node).append(" ~ ").append(this.nodeExpressionStrings.get(node));
        }
        return buf.toString();
    }

    private List<Node> getVariableParents(Node node) {
        List<Node> allParents = this.graph.getParents(node);
        LinkedList<Node> parents = new LinkedList<Node>();
        for (Node _parent : allParents) {
            if (_parent.getNodeType() == NodeType.ERROR) continue;
            parents.add(_parent);
        }
        return parents;
    }

    private String getVariableString(List<Node> parents) {
        StringBuilder buf = new StringBuilder();
        List<Node> sortedNodes = this.putErrorNodesLast(parents);
        for (int i = 0; i < sortedNodes.size(); ++i) {
            Node node = sortedNodes.get(i);
            buf.append(node.getName());
            if (i >= sortedNodes.size() - 1) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    private List<Node> putErrorNodesLast(List<Node> parents) {
        LinkedList<Node> sortedNodes = new LinkedList<Node>();
        for (Node node : parents) {
            if (node.getNodeType() == NodeType.ERROR) continue;
            sortedNodes.add(node);
        }
        for (Node node : parents) {
            if (node.getNodeType() != NodeType.ERROR) continue;
            sortedNodes.add(node);
        }
        return sortedNodes;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
    }

    public String getVariablesTemplate() {
        return this.variablesTemplate;
    }

    public void setVariablesTemplate(String variablesTemplate) throws ParseException {
        if (variablesTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(this.errorsTemplate);
        this.variablesTemplate = variablesTemplate;
    }

    public String getErrorsTemplate() {
        return this.errorsTemplate;
    }

    public void setErrorsTemplate(String errorsTemplate) throws ParseException {
        if (errorsTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(errorsTemplate);
        this.errorsTemplate = errorsTemplate;
    }

    public String getParametersTemplate() {
        return this.parametersTemplate;
    }

    public void setParametersTemplate(String parametersTemplate) throws ParseException {
        if (parametersTemplate == null) {
            throw new NullPointerException();
        }
        ExpressionParser parser = new ExpressionParser();
        parser.parseExpression(this.errorsTemplate);
        this.parametersTemplate = parametersTemplate;
    }
}

