/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.Tsls;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import java.rmi.MarshalledObject;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import pal.math.ConjugateGradientSearch;
import pal.math.MFWithGradient;

public class MimBuildEstimator {
    static int NUM_ITER_TSLS = 10;
    static int NUM_ITER = 20;
    int numIterTsls;
    int numIter;
    private SemPm semPm;
    private CovarianceMatrix covMatrix;
    private SemIm estimatedSem;
    private DataSet dataSet = null;
    private static final double FUNC_TOLERANCE = 1.0E-4;
    private static final double PARAM_TOLERANCE = 0.001;
    int numIndicators;
    int numLatents;
    int numFixedIndicators;
    Node[] indicators;
    Node[] latents;
    double[][] beta;
    double[][] fi;
    double[][] iBeta;
    double[][] iSigma;
    double[] theta;
    double[][] bigLambda;
    double[][] iMinusB;
    double[][] iMinusBT;
    double[][] J;
    List<int[]> latentParents;
    int[] indicatorParents;
    int[] lambdaIndex;
    int[] betaIndex;
    int indicatorErrorsIndex;
    int latentErrorsIndex;
    double[][] latentImpliedCovar;
    double[][] observedImpliedCovar;
    double[][] covMatrixValue;
    boolean[][][] latentImportant;

    public MimBuildEstimator(CovarianceMatrix covMatrix, SemPm semPm, int numIter, int numIterTsls) {
        if (covMatrix == null) {
            throw new NullPointerException("DataWrapper must not be null.");
        }
        if (semPm == null) {
            throw new NullPointerException("Sem PM must not be null.");
        }
        if (!MimBuildEstimator.checkPurifiedStructure(semPm.getGraph())) {
            throw new RuntimeException("Input graph should be a pure measurement/structural model.");
        }
        ArrayList<Node> latents = new ArrayList<Node>();
        ArrayList<Node> measured = new ArrayList<Node>();
        for (Node node : semPm.getVariableNodes()) {
            if (node.getNodeType() == NodeType.LATENT) {
                latents.add(node);
            }
            if (node.getNodeType() != NodeType.MEASURED) continue;
            measured.add(node);
        }
        if (latents.size() > 0 && measured.size() == 0) {
            throw new IllegalArgumentException("If there are no measured variables, there can't be latents.");
        }
        this.covMatrix = this.fixVarOrder(semPm, covMatrix);
        this.covMatrixValue = this.covMatrix.getMatrix().toArray();
        this.semPm = semPm;
        this.numIter = numIter;
        this.numIterTsls = numIterTsls;
        this.buildMeasurementStructuralModel();
        this.buildIndexes();
    }

    public static MimBuildEstimator newInstance(DataSet dataSet, SemPm semPm) {
        MimBuildEstimator me = new MimBuildEstimator(new CovarianceMatrix(dataSet), semPm, NUM_ITER, NUM_ITER_TSLS);
        me.dataSet = dataSet;
        return me;
    }

    public static MimBuildEstimator newInstance(DataSet dataSet, SemPm semPm, int numIter, int numIterTsls) {
        MimBuildEstimator me = new MimBuildEstimator(new CovarianceMatrix(dataSet), semPm, numIter, numIterTsls);
        me.dataSet = dataSet;
        return me;
    }

    public static MimBuildEstimator newInstance(CovarianceMatrix covMatrix, SemPm semPm) {
        return new MimBuildEstimator(covMatrix, semPm, NUM_ITER, NUM_ITER_TSLS);
    }

    public static MimBuildEstimator newInstance(CovarianceMatrix covMatrix, SemPm semPm, int numIter, int numIterTsls) {
        return new MimBuildEstimator(covMatrix, semPm, numIter, numIterTsls);
    }

    public static boolean checkPurifiedStructure(Graph graph) {
        return true;
    }

    private void buildMeasurementStructuralModel() {
        int i;
        List<Node> semPmVars = this.semPm.getVariableNodes();
        ArrayList<Node> indicatorsL = new ArrayList<Node>(semPmVars.size());
        ArrayList<Node> latentsL = new ArrayList<Node>(semPmVars.size());
        for (Node nextNode : semPmVars) {
            if (nextNode.getNodeType() == NodeType.LATENT) {
                latentsL.add(nextNode);
                continue;
            }
            indicatorsL.add(nextNode);
        }
        this.numIndicators = indicatorsL.size();
        this.numFixedIndicators = latentsL.size() > 0 ? latentsL.size() : 0;
        this.numLatents = this.numFixedIndicators;
        if (this.numFixedIndicators > this.numIndicators) {
            this.numFixedIndicators = this.numIndicators;
        }
        this.indicators = new Node[indicatorsL.size()];
        for (i = 0; i < this.numIndicators; ++i) {
            this.indicators[i] = (Node)indicatorsL.get(i);
        }
        this.latents = new Node[latentsL.size()];
        for (i = 0; i < this.numLatents; ++i) {
            this.latents[i] = (Node)latentsL.get(i);
        }
        this.latentImpliedCovar = new double[this.numLatents][this.numLatents];
        this.observedImpliedCovar = new double[this.numIndicators][this.numIndicators];
        this.latentImportant = new boolean[this.numLatents][this.numIndicators][this.numIndicators];
        for (int l = 0; l < this.numLatents; ++l) {
            for (int i2 = 0; i2 < this.numIndicators; ++i2) {
                for (int j = 0; j < this.numIndicators; ++j) {
                    this.latentImportant[l][i2][j] = this.semPm.getGraph().isAncestorOf(this.latents[l], this.indicators[i2]) && this.semPm.getGraph().isAncestorOf(this.latents[l], this.indicators[j]);
                }
            }
        }
        this.iSigma = new double[this.numIndicators][this.numIndicators];
        for (i = 0; i < this.numIndicators; ++i) {
            for (int j = 0; j < this.numIndicators; ++j) {
                this.iSigma[i][j] = i == j ? 1.0 : 0.0;
            }
        }
    }

    private void buildIndexes() {
        int i;
        int i2;
        boolean[] fixedIndicators = new boolean[this.numIndicators];
        boolean[] markedLatents = new boolean[this.numLatents];
        this.indicatorParents = new int[this.numIndicators];
        for (i2 = 0; i2 < this.numLatents; ++i2) {
            markedLatents[i2] = false;
        }
        block1: for (i2 = 0; i2 < this.numIndicators; ++i2) {
            for (int j = 0; j < this.numLatents; ++j) {
                if (!this.semPm.getGraph().isParentOf(this.latents[j], this.indicators[i2])) continue;
                this.indicatorParents[i2] = j;
                if (!markedLatents[j]) {
                    markedLatents[j] = true;
                    fixedIndicators[i2] = true;
                    continue block1;
                }
                fixedIndicators[i2] = false;
                continue block1;
            }
        }
        int count = 0;
        this.lambdaIndex = new int[this.numIndicators];
        for (i = 0; i < this.numIndicators; ++i) {
            this.lambdaIndex[i] = fixedIndicators[i] ? -1 : count++;
        }
        this.latentParents = new ArrayList<int[]>(this.numLatents);
        this.beta = new double[this.numLatents][this.numLatents];
        this.fi = new double[this.numLatents][this.numLatents];
        this.iBeta = new double[this.numLatents][this.numLatents];
        for (i = 0; i < this.numLatents; ++i) {
            LinkedList<Integer> parentsL = new LinkedList<Integer>();
            for (int j = 0; j < this.numLatents; ++j) {
                if (this.semPm.getGraph().isParentOf(this.latents[j], this.latents[i])) {
                    parentsL.add(j);
                }
                this.beta[i][j] = 0.0;
                this.fi[i][j] = 0.0;
                this.iBeta[i][j] = i == j ? 1.0 : 0.0;
            }
            int[] parents = new int[parentsL.size()];
            for (int j = 0; j < parentsL.size(); ++j) {
                parents[j] = (Integer)parentsL.get(j);
            }
            this.latentParents.add(parents);
        }
        this.betaIndex = new int[this.numLatents];
        System.out.println("EE numIndicators = " + this.numIndicators + " numFixedIndicators = " + this.numFixedIndicators);
        this.betaIndex[0] = this.numIndicators - this.numFixedIndicators;
        for (i = 1; i < this.numLatents; ++i) {
            System.out.println("DD betaIndex[i - 1]" + this.betaIndex[i - 1]);
            System.out.println("DD latentParents.get(i - 1).length = " + this.latentParents.get(i - 1).length);
            this.betaIndex[i] = this.betaIndex[i - 1] + this.latentParents.get(i - 1).length;
        }
        System.out.println("CC betaIndex[numLatents - 1] = " + this.betaIndex[this.numLatents - 1]);
        System.out.println("CC (latentParents.get(numLatents - 1)).length" + this.latentParents.get(this.numLatents - 1).length);
        this.indicatorErrorsIndex = this.betaIndex[this.numLatents - 1] + this.latentParents.get(this.numLatents - 1).length;
        System.out.println("BB indicatorErrorsIndex = " + this.indicatorErrorsIndex);
        System.out.println("BB numIndicators = " + this.numIndicators);
        this.latentErrorsIndex = this.indicatorErrorsIndex + this.numIndicators;
        this.theta = new double[this.latentErrorsIndex + this.numLatents];
        this.bigLambda = new double[this.numIndicators][this.numLatents];
        for (i = 0; i < this.numIndicators; ++i) {
            for (int j = 0; j < this.numLatents; ++j) {
                this.bigLambda[i][j] = 0.0;
            }
        }
        this.J = new double[this.numLatents][this.numLatents];
        for (i = 0; i < this.numLatents; ++i) {
            for (int j = 0; j < this.numLatents; ++j) {
                this.J[i][j] = 0.0;
            }
        }
    }

    private void randomizeParameters() {
        for (int i = 0; i < this.theta.length; ++i) {
            if (i < this.indicatorErrorsIndex) {
                do {
                    this.theta[i] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
                } while (Math.abs(this.theta[i]) < 0.1);
                continue;
            }
            this.theta[i] = RandomUtil.getInstance().nextDouble() + 0.1;
        }
    }

    private void randomizeVariancesOnly() {
        for (int i = this.indicatorErrorsIndex; i < this.theta.length; ++i) {
            System.out.println("AA indicatorErrorsIndex = " + this.indicatorErrorsIndex);
            this.theta[i] = RandomUtil.getInstance().nextDouble() + 0.1;
        }
    }

    private void initializeByTSLS() {
        this.randomizeVariancesOnly();
        if (this.dataSet == null) {
            return;
        }
        ArrayList<String> fixedLoadings = new ArrayList<String>();
        for (int i = 0; i < this.indicators.length; ++i) {
            if (this.lambdaIndex[i] >= 0) continue;
            fixedLoadings.add(this.indicators[i].getName());
        }
        Tsls tsls = new Tsls(this.semPm, this.dataSet, null, fixedLoadings);
        SemIm semIm = tsls.estimate();
        List<Parameter> parameters = semIm.getFreeParameters();
        block1: for (Parameter nextP : parameters) {
            int i;
            if (nextP.getType() != ParamType.COEF) continue;
            Node nodeA = nextP.getNodeA();
            Node nodeB = nextP.getNodeB();
            int aIndex = -1;
            int bIndex = -1;
            boolean bIsIndicator = false;
            for (i = 0; i < this.numLatents; ++i) {
                if (!this.latents[i].getName().equals(nodeA.getName())) continue;
                aIndex = i;
                break;
            }
            for (i = 0; i < this.numIndicators; ++i) {
                if (!this.indicators[i].getName().equals(nodeB.getName())) continue;
                bIsIndicator = true;
                bIndex = i;
                break;
            }
            if (!bIsIndicator) {
                for (i = 0; i < this.numLatents; ++i) {
                    if (!this.latents[i].getName().equals(nodeB.getName())) continue;
                    bIndex = i;
                    break;
                }
            }
            if (bIsIndicator) {
                if (this.lambdaIndex[bIndex] < 0) continue;
                this.theta[this.lambdaIndex[bIndex]] = semIm.getParamValue(nextP);
                continue;
            }
            int[] parents = this.latentParents.get(bIndex);
            for (int i2 = 0; i2 < parents.length; ++i2) {
                if (!this.latents[parents[i2]].getName().equals(this.latents[aIndex].getName())) continue;
                this.theta[this.betaIndex[bIndex] + i2] = semIm.getParamValue(nextP);
                continue block1;
            }
        }
    }

    private void computeImpliedCovar() throws IllegalArgumentException {
        int i;
        for (i = 0; i < this.numLatents; ++i) {
            int[] parents = this.latentParents.get(i);
            for (int j = 0; j < parents.length; ++j) {
                this.beta[i][parents[j]] = this.theta[this.betaIndex[i] + j];
            }
            this.fi[i][i] = this.theta[this.latentErrorsIndex + i];
        }
        this.iMinusB = MatrixUtils.inverse(MatrixUtils.subtract(this.iBeta, this.beta));
        this.iMinusBT = MatrixUtils.transpose(this.iMinusB);
        this.latentImpliedCovar = MatrixUtils.product(this.iMinusB, MatrixUtils.product(this.fi, this.iMinusBT));
        for (i = 0; i < this.numIndicators; ++i) {
            for (int j = i; j < this.numIndicators; ++j) {
                double coeff1 = this.lambdaIndex[i] < 0 ? 1.0 : this.theta[this.lambdaIndex[i]];
                double coeff2 = this.lambdaIndex[j] < 0 ? 1.0 : this.theta[this.lambdaIndex[j]];
                this.observedImpliedCovar[i][j] = coeff1 * coeff2 * this.latentImpliedCovar[this.indicatorParents[i]][this.indicatorParents[j]];
                if (i == j) {
                    double[] dArray = this.observedImpliedCovar[i];
                    int n = j;
                    dArray[n] = dArray[n] + this.theta[this.indicatorErrorsIndex + i];
                    continue;
                }
                this.observedImpliedCovar[j][i] = this.observedImpliedCovar[i][j];
            }
        }
    }

    private double[] computeGradient(double[] gradient) {
        this.computeImpliedCovar();
        try {
            double[][] inverse = MatrixUtils.inverse(this.observedImpliedCovar);
            double[][] inner_term = MatrixUtils.product(this.covMatrixValue, inverse);
            double[][] gradient_sigma = MatrixUtils.subtract(inverse, MatrixUtils.product(inverse, inner_term));
            for (int d1 = 0; d1 < this.numIndicators; ++d1) {
                gradient[this.indicatorErrorsIndex + d1] = gradient_sigma[d1][d1];
                if (this.lambdaIndex[d1] < 0) continue;
                gradient[this.lambdaIndex[d1]] = 0.0;
                for (int d2 = 0; d2 < this.numIndicators; ++d2) {
                    double coeff = this.lambdaIndex[d2] < 0 ? 1.0 : this.theta[this.lambdaIndex[d2]];
                    int n = this.lambdaIndex[d1];
                    gradient[n] = gradient[n] + 2.0 * gradient_sigma[d1][d2] * coeff * this.latentImpliedCovar[this.indicatorParents[d1]][this.indicatorParents[d2]];
                }
            }
            for (int i = 0; i < this.numIndicators; ++i) {
                this.bigLambda[i][this.indicatorParents[i]] = this.lambdaIndex[i] < 0 ? 1.0 : this.theta[this.lambdaIndex[i]];
            }
            double[][] deltaB0 = MatrixUtils.product(this.bigLambda, this.iMinusB);
            double[][] deltaB1 = MatrixUtils.transpose(MatrixUtils.product(MatrixUtils.product(deltaB0, this.fi), this.iMinusBT));
            double[][] deltaB2 = MatrixUtils.transpose(deltaB0);
            for (int i = 0; i < this.numLatents; ++i) {
                int[] parents = this.latentParents.get(i);
                for (int j = 0; j < parents.length; ++j) {
                    gradient[this.betaIndex[i] + j] = 0.0;
                    for (int d1 = 0; d1 < this.numIndicators; ++d1) {
                        for (int d2 = 0; d2 < this.numIndicators; ++d2) {
                            int n = this.betaIndex[i] + j;
                            gradient[n] = gradient[n] + gradient_sigma[d1][d2] * (deltaB0[d1][i] * deltaB1[parents[j]][d2] + deltaB0[d2][i] * deltaB1[parents[j]][d1]);
                        }
                    }
                }
                gradient[this.latentErrorsIndex + i] = 0.0;
                for (int d1 = 0; d1 < this.numIndicators; ++d1) {
                    for (int d2 = 0; d2 < this.numIndicators; ++d2) {
                        int n = this.latentErrorsIndex + i;
                        gradient[n] = gradient[n] + gradient_sigma[d1][d2] * deltaB0[d1][i] * deltaB2[i][d2];
                    }
                }
            }
        }
        catch (Exception e) {
            for (int i = 0; i < gradient.length; ++i) {
                gradient[i] = 0.0;
            }
        }
        return gradient;
    }

    private CovarianceMatrix fixVarOrder(SemPm semPm, CovarianceMatrix covMatrix) {
        List<Node> semPmVars = semPm.getVariableNodes();
        int observedNodes = 0;
        for (Node semPmVar : semPmVars) {
            if (semPmVar.getNodeType() == NodeType.LATENT) continue;
            ++observedNodes;
        }
        int index = 0;
        String[] semPmVarNames = new String[observedNodes];
        for (Node semPmVar1 : semPmVars) {
            if (semPmVar1.getNodeType() == NodeType.LATENT) continue;
            semPmVarNames[index++] = ((Object)semPmVar1).toString();
        }
        return covMatrix.getSubmatrix(semPmVarNames);
    }

    private SemIm getOptimizedSem() {
        SemPm fixedPm;
        try {
            fixedPm = new MarshalledObject<SemPm>(this.semPm).get();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        for (Parameter nextP : fixedPm.getParameters()) {
            if (nextP.getType() != ParamType.COEF) continue;
            Node nodeB = nextP.getNodeB();
            int bIndex = -1;
            boolean bIsIndicator = false;
            for (int i = 0; i < this.numIndicators; ++i) {
                if (!this.indicators[i].getName().equals(nodeB.getName())) continue;
                bIsIndicator = true;
                bIndex = i;
                break;
            }
            if (!bIsIndicator || this.lambdaIndex[bIndex] >= 0) continue;
            nextP.setFixed(true);
        }
        SemIm semIm = new SemIm(fixedPm, this.covMatrix);
        List<Parameter> parameters = semIm.getFreeParameters();
        block4: for (Parameter nextP : parameters) {
            Node nodeA;
            if (nextP.getType() == ParamType.COEF) {
                int i;
                nodeA = nextP.getNodeA();
                Node nodeB = nextP.getNodeB();
                int aIndex = -1;
                int bIndex = -1;
                boolean bIsIndicator = false;
                for (i = 0; i < this.numLatents; ++i) {
                    if (!this.latents[i].getName().equals(nodeA.getName())) continue;
                    aIndex = i;
                    break;
                }
                for (i = 0; i < this.numIndicators; ++i) {
                    if (!this.indicators[i].getName().equals(nodeB.getName())) continue;
                    bIsIndicator = true;
                    bIndex = i;
                    break;
                }
                if (!bIsIndicator) {
                    for (i = 0; i < this.numLatents; ++i) {
                        if (!this.latents[i].getName().equals(nodeB.getName())) continue;
                        bIndex = i;
                        break;
                    }
                }
                if (bIsIndicator) {
                    if (this.lambdaIndex[bIndex] < 0) {
                        semIm.setParamValue(nextP, 1.0);
                        continue;
                    }
                    semIm.setParamValue(nextP, this.theta[this.lambdaIndex[bIndex]]);
                    continue;
                }
                int[] parents = this.latentParents.get(bIndex);
                for (int i2 = 0; i2 < parents.length; ++i2) {
                    if (!this.latents[parents[i2]].getName().equals(this.latents[aIndex].getName())) continue;
                    semIm.setParamValue(nextP, this.theta[this.betaIndex[bIndex] + i2]);
                    continue block4;
                }
                continue;
            }
            if (nextP.getType() == ParamType.VAR) {
                int i;
                nodeA = nextP.getNodeA();
                if (nodeA.getNodeType() == NodeType.LATENT) {
                    for (int i3 = 0; i3 < this.numLatents; ++i3) {
                        if (!this.latents[i3].getName().equals(nodeA.getName())) continue;
                        semIm.setParamValue(nextP, this.theta[this.latentErrorsIndex + i3]);
                        continue block4;
                    }
                    continue;
                }
                boolean foundIndicator = false;
                String childName = ((Object)semIm.getSemPm().getGraph().getVarNode(nodeA)).toString();
                for (i = 0; i < this.numIndicators; ++i) {
                    if (!this.indicators[i].getName().equals(childName)) continue;
                    foundIndicator = true;
                    semIm.setParamValue(nextP, this.theta[this.indicatorErrorsIndex + i]);
                    break;
                }
                if (foundIndicator) continue;
                for (i = 0; i < this.numLatents; ++i) {
                    if (!this.latents[i].getName().equals(childName)) continue;
                    semIm.setParamValue(nextP, this.theta[this.latentErrorsIndex + i]);
                    continue block4;
                }
                continue;
            }
            throw new RuntimeException("Invalid parameter!");
        }
        parameters = semIm.getFixedParameters();
        for (Parameter next : parameters) {
            semIm.setFixedParamValue(next, 1.0);
        }
        return semIm;
    }

    private double getFittingScore() {
        this.computeImpliedCovar();
        Object inverse = new double[][]{};
        inverse = MatrixUtils.inverse(this.observedImpliedCovar);
        double[][] product = MatrixUtils.product(this.covMatrixValue, (double[][])inverse);
        return Math.log(MatrixUtils.determinant(this.observedImpliedCovar)) + MatrixUtils.trace(product);
    }

    public void debugFml() {
        this.computeImpliedCovar();
        double[][] inverse = MatrixUtils.inverse(this.observedImpliedCovar);
        double[][] product = MatrixUtils.product(this.covMatrixValue, inverse);
        System.out.println("logDetSigma = " + Math.log(MatrixUtils.determinant(this.observedImpliedCovar)));
        System.out.println("traceSSigmaInv = " + MatrixUtils.trace(product));
        System.out.println("logDetS = " + Math.log(MatrixUtils.determinant(this.covMatrixValue)));
        System.out.println("numMeasVars = " + this.numIndicators);
    }

    public void estimate() {
        this.estimatedSem = null;
        int iter = 0;
        double bestScore = Double.MAX_VALUE;
        this.initializeByTSLS();
        double[] thetaTSLS = new double[this.theta.length];
        System.arraycopy(this.theta, 0, thetaTSLS, 0, this.theta.length);
        do {
            if (iter < this.numIterTsls) {
                if (iter > 0) {
                    System.arraycopy(thetaTSLS, 0, this.theta, 0, this.theta.length);
                    this.randomizeVariancesOnly();
                }
            } else {
                this.randomizeParameters();
            }
            double[] start = new double[this.theta.length];
            System.arraycopy(this.theta, 0, start, 0, this.theta.length);
            try {
                new ConjugateGradientSearch().optimize(new MimBuildFittingFunction(this), start, 1.0E-4, 0.001);
            }
            catch (Exception e) {
                continue;
            }
            System.arraycopy(start, 0, this.theta, 0, this.theta.length);
            double score = this.getFittingScore();
            if (score < bestScore) {
                this.estimatedSem = this.getOptimizedSem();
                bestScore = score;
            }
            ++iter;
        } while (iter < this.numIter);
    }

    public SemIm getEstimatedSem() {
        return this.estimatedSem;
    }

    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        StringBuilder buf = new StringBuilder();
        buf.append("\nSemEstimator");
        if (this.estimatedSem == null) {
            buf.append("\n\t...SemIm has not been estimated yet.");
        } else {
            SemIm sem = this.estimatedSem;
            buf.append("\n\n\tfml = ");
            buf.append(nf.format(sem.getFml()));
            buf.append("\n\n\tnegtruncll = ");
            buf.append(nf.format(-sem.getTruncLL()));
            buf.append("\n\n\tmeasuredNodes:\n");
            buf.append("\t").append(sem.getMeasuredNodes());
            buf.append("\n\n\tedgeCoef:\n");
            buf.append(MatrixUtils.toString(sem.getEdgeCoef().toArray()));
            buf.append("\n\n\terrCovar:\n");
            buf.append(MatrixUtils.toString(sem.getErrCovar().toArray()));
        }
        return buf.toString();
    }

    static class MimBuildFittingFunction
    implements MFWithGradient {
        static final long serialVersionUID = 23L;
        private final MimBuildEstimator mim;

        public MimBuildFittingFunction(MimBuildEstimator mim) {
            this.mim = mim;
        }

        @Override
        public double evaluate(double[] argument) {
            System.arraycopy(argument, 0, this.mim.theta, 0, this.mim.theta.length);
            return this.mim.getFittingScore();
        }

        @Override
        public double evaluate(double[] argument, double[] gradient) {
            this.computeGradient(argument, gradient);
            return this.mim.getFittingScore();
        }

        @Override
        public void computeGradient(double[] argument, double[] gradient) {
            System.arraycopy(argument, 0, this.mim.theta, 0, this.mim.theta.length);
            this.mim.computeGradient(gradient);
        }

        @Override
        public int getNumArguments() {
            return this.mim.theta.length;
        }

        @Override
        public double getLowerBound(int n) {
            if (n >= this.mim.indicatorErrorsIndex) {
                return 1.0E-4;
            }
            return -1000.0;
        }

        @Override
        public double getUpperBound(int n) {
            return 1000.0;
        }
    }
}

