/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.DoubleFactory2D;
import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import cern.colt.matrix.linalg.EigenvalueDecomposition;
import cern.jet.math.Functions;
import cern.jet.math.PlusMult;
import edu.cmu.tetrad.data.ColtDataSet;
import edu.cmu.tetrad.data.ContinuousVariable;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ConnectionFunction;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.Mapping;
import edu.cmu.tetrad.sem.OptimizationSemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemImInitializationParams;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemStdErrorEstimator;
import edu.cmu.tetrad.util.MatrixUtils;
import edu.cmu.tetrad.util.ProbUtils;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.rmi.MarshalledObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class SemIm
implements ISemIm,
TetradSerializable,
OptimizationSemIm {
    static final long serialVersionUID = 23L;
    private final SemPm semPm;
    private final List<Node> variableNodes;
    private final List<Node> exogenousNodes = null;
    private final List<Node> measuredNodes;
    private List<Parameter> freeParameters;
    private List<Parameter> fixedParameters;
    private List<Parameter> meanParameters;
    private double[][] edgeCoef;
    private DoubleMatrix2D edgeCoefC;
    private double[][] errCovar;
    private DoubleMatrix2D errCovarC;
    private double[] variableMeans;
    private double[] variableMeansStdDev;
    private double[][] sampleCovar;
    private DoubleMatrix2D sampleCovarC;
    private int sampleSize;
    private double[][] implCovar;
    private DoubleMatrix2D implCovarC;
    private double[][] implCovarMeas;
    private DoubleMatrix2D implCovarMeasC;
    private List<Mapping> freeMappings;
    private List<Mapping> fixedMappings;
    private double[] standardErrors;
    private boolean parameterBoundsEnforced = true;
    private boolean estimated = false;
    private transient Algebra algebra;
    private boolean cyclic;
    private transient double logDetSample;
    private SemImInitializationParams initializationParams = new SemImInitializationParams();
    private boolean checkPositiveDefinite;
    private Map<Node, Distribution> distributions;
    private Map<Node, ConnectionFunction> functions;
    private boolean cyclicTested = false;
    private boolean simulatedPositiveDataOnly = false;

    public SemIm(SemPm semPm) {
        this(semPm, null, null);
    }

    public SemIm(SemPm semPm, SemImInitializationParams params) {
        this(semPm, null, params);
    }

    public SemIm(SemPm semPm, SemIm oldSemIm, SemImInitializationParams params) {
        if (semPm == null) {
            throw new NullPointerException("Sem PM must not be null.");
        }
        if (params != null) {
            this.setInitializationParams(params);
        }
        this.semPm = new SemPm(semPm);
        this.variableNodes = Collections.unmodifiableList(semPm.getVariableNodes());
        this.measuredNodes = Collections.unmodifiableList(semPm.getMeasuredNodes());
        int numVars = this.variableNodes.size();
        this.edgeCoefC = new SparseDoubleMatrix2D(numVars, numVars);
        this.errCovarC = new SparseDoubleMatrix2D(numVars, numVars);
        this.variableMeans = new double[numVars];
        this.variableMeansStdDev = new double[numVars];
        this.freeParameters = this.initFreeParameters();
        this.freeMappings = this.createMappings(this.getFreeParameters());
        this.fixedParameters = this.initFixedParameters();
        this.fixedMappings = this.createMappings(this.getFixedParameters());
        this.meanParameters = this.initMeanParameters();
        for (int i = 0; i < numVars; ++i) {
            this.variableMeans[i] = 0.0;
            this.variableMeansStdDev[i] = Double.NaN;
        }
        this.initializeValues();
        if (oldSemIm != null && this.getInitializationParams().isRetainPreviousValues()) {
            this.retainPreviousValues(oldSemIm);
        }
        this.distributions = new HashMap<Node, Distribution>();
        this.functions = new HashMap<Node, ConnectionFunction>();
    }

    public SemIm(SemPm semPm, CovarianceMatrix covMatrix) {
        this(semPm);
        this.setCovMatrix(covMatrix);
    }

    private SemIm(SemIm semIm, DoubleMatrix2D covariances, DoubleMatrix1D means) {
        this(semIm);
        if (covariances.rows() != covariances.columns()) {
            throw new IllegalArgumentException("Expecting covariances to be square.");
        }
        if (!MatrixUtils.isPositiveDefinite(covariances)) {
            throw new IllegalArgumentException("Covariances must be symmetric positive definite.");
        }
        if (means.size() != this.semPm.getVariableNodes().size()) {
            throw new IllegalArgumentException("Number of means does not equal number of variables.");
        }
        if (covariances.rows() != this.semPm.getVariableNodes().size()) {
            throw new IllegalArgumentException("Dimension of covariance matrix does not equal number of variables.");
        }
        this.errCovarC = covariances;
        this.variableMeans = means.toArray();
        this.freeParameters = this.initFreeParameters();
        this.freeMappings = this.createMappings(this.getFreeParameters());
        this.fixedParameters = this.initFixedParameters();
        this.fixedMappings = this.createMappings(this.getFixedParameters());
    }

    public SemIm updatedIm(DoubleMatrix2D covariances, DoubleMatrix1D means) {
        return new SemIm(this, covariances, means);
    }

    public SemIm(SemIm semIm) {
        try {
            SemIm _semIm = new MarshalledObject<SemIm>(semIm).get();
            this.semPm = _semIm.semPm;
            this.variableNodes = _semIm.variableNodes;
            this.measuredNodes = _semIm.measuredNodes;
            this.freeParameters = _semIm.freeParameters;
            this.fixedParameters = _semIm.fixedParameters;
            this.meanParameters = _semIm.meanParameters;
            this.edgeCoefC = _semIm.edgeCoefC;
            this.errCovarC = _semIm.errCovarC;
            this.variableMeans = _semIm.variableMeans;
            this.variableMeansStdDev = _semIm.variableMeansStdDev;
            this.sampleCovarC = _semIm.sampleCovarC;
            this.sampleSize = _semIm.sampleSize;
            this.implCovarC = _semIm.implCovarC;
            this.implCovarMeasC = _semIm.implCovarMeasC;
            this.freeMappings = _semIm.freeMappings;
            this.fixedMappings = _semIm.fixedMappings;
            this.standardErrors = _semIm.standardErrors;
            this.parameterBoundsEnforced = _semIm.parameterBoundsEnforced;
            this.estimated = _semIm.estimated;
            this.cyclic = _semIm.cyclic;
        }
        catch (IOException e) {
            throw new RuntimeException("SemIm could not be deep cloned.", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("SemIm could not be deep cloned.", e);
        }
    }

    public static SemIm retainValues(SemIm semIm, SemGraph graph) {
        SemPm newSemPm = new SemPm(graph);
        SemIm newSemIm = new SemIm(newSemPm);
        for (Parameter p1 : newSemIm.getSemPm().getParameters()) {
            Node nodeA = semIm.getSemPm().getGraph().getNode(p1.getNodeA().getName());
            Node nodeB = semIm.getSemPm().getGraph().getNode(p1.getNodeB().getName());
            for (Parameter p2 : semIm.getSemPm().getParameters()) {
                if (p2.getNodeA() != nodeA || p2.getNodeB() != nodeB || p2.getType() != p1.getType()) continue;
                newSemIm.setParamValue(p1, semIm.getParamValue(p2));
            }
        }
        newSemIm.sampleSize = semIm.sampleSize;
        return newSemIm;
    }

    public static SemIm serializableInstance() {
        return new SemIm(SemPm.serializableInstance());
    }

    public void setCovMatrix(CovarianceMatrix covMatrix) {
        if (covMatrix == null) {
            throw new NullPointerException("Covariance matrix must not be null.");
        }
        CovarianceMatrix covMatrix2 = this.fixVarOrder(covMatrix);
        this.sampleCovarC = covMatrix2.getMatrix().copy();
        this.sampleSize = covMatrix2.getSampleSize();
        if (this.sampleSize < 0) {
            throw new IllegalArgumentException("Sample size out of range: " + this.sampleSize);
        }
    }

    public void setDataSet(DataSet dataSet) {
        this.setCovMatrix(new CovarianceMatrix(dataSet));
    }

    @Override
    public SemPm getSemPm() {
        return this.semPm;
    }

    @Override
    public double[] getFreeParamValues() {
        double[] paramValues = new double[this.freeMappings().size()];
        for (int i = 0; i < this.freeMappings().size(); ++i) {
            Mapping mapping = this.freeMappings().get(i);
            paramValues[i] = mapping.getValue();
        }
        return paramValues;
    }

    @Override
    public void setFreeParamValues(double[] params) {
        if (params.length != this.getNumFreeParams()) {
            throw new IllegalArgumentException("The array provided must be of the same length as the number of free parameters.");
        }
        for (int i = 0; i < this.freeMappings().size(); ++i) {
            Mapping mapping = this.freeMappings().get(i);
            mapping.setValue(params[i]);
        }
    }

    @Override
    public double getParamValue(Parameter parameter) {
        if (parameter == null) {
            throw new NullPointerException();
        }
        if (this.getFreeParameters().contains(parameter)) {
            int index = this.getFreeParameters().indexOf(parameter);
            Mapping mapping = this.freeMappings.get(index);
            return mapping.getValue();
        }
        if (this.getFixedParameters().contains(parameter)) {
            int index = this.getFixedParameters().indexOf(parameter);
            Mapping mapping = this.fixedMappings.get(index);
            return mapping.getValue();
        }
        if (this.getMeanParameters().contains(parameter)) {
            int index = this.getMeanParameters().indexOf(parameter);
            return this.variableMeans[index];
        }
        throw new IllegalArgumentException("Not a parameter in this model: " + parameter);
    }

    @Override
    public void setParamValue(Parameter parameter, double value) {
        if (this.getFreeParameters().contains(parameter)) {
            int index = this.getFreeParameters().indexOf(parameter);
            Mapping mapping = this.freeMappings.get(index);
            mapping.setValue(value);
        } else if (this.getMeanParameters().contains(parameter)) {
            int index = this.getMeanParameters().indexOf(parameter);
            this.variableMeans[index] = value;
        } else {
            throw new IllegalArgumentException("That parameter cannot be set in this model: " + parameter);
        }
    }

    @Override
    public void setFixedParamValue(Parameter parameter, double value) {
        if (!this.getFixedParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a fixed parameter in this model: " + parameter);
        }
        int index = this.getFixedParameters().indexOf(parameter);
        Mapping mapping = this.fixedMappings.get(index);
        mapping.setValue(value);
    }

    public double getErrVar(Node x) {
        Parameter param = this.semPm.getVarianceParameter(x);
        return this.getParamValue(param);
    }

    public double getErrCovar(Node x, Node y) {
        Parameter param = this.semPm.getCovarianceParameter(x, y);
        return this.getParamValue(param);
    }

    public double getEdgeCoef(Node x, Node y) {
        Parameter param = this.semPm.getCoefficientParameter(x, y);
        return this.getParamValue(param);
    }

    public double getEdgeCoef(Edge edge) {
        return this.getEdgeCoef(edge.getNode1(), edge.getNode2());
    }

    @Override
    public void setErrVar(Node x, double value) {
        Parameter param = this.semPm.getVarianceParameter(x);
        this.setParamValue(param, value);
    }

    @Override
    public void setEdgeCoef(Node x, Node y, double value) {
        Parameter param = this.semPm.getCoefficientParameter(x, y);
        this.setParamValue(param, value);
    }

    public boolean existsEdgeCoef(Node x, Node y) {
        if (x == y) {
            return false;
        }
        return this.semPm.getCoefficientParameter(x, y) != null;
    }

    public void setErrCovar(Node x, double value) {
        SemGraph graph = this.getSemPm().getGraph();
        Node exogenousX = graph.getExogenous(x);
        this.setParamValue(exogenousX, exogenousX, value);
    }

    public void setErrCovar(Node x, Node y, double value) {
        Parameter param = this.semPm.getCovarianceParameter(x, y);
        this.setParamValue(param, value);
    }

    @Override
    public void setMean(Node node, double mean) {
        int index = this.variableNodes.indexOf(node);
        this.variableMeans[index] = mean;
    }

    public void setMeanStandardDeviation(Node node, double mean) {
        int index = this.variableNodes.indexOf(node);
        this.variableMeansStdDev[index] = mean;
    }

    @Override
    public void setIntercept(Node node, double intercept) {
        Node _node;
        int i;
        if (this.isCyclic()) {
            throw new UnsupportedOperationException("Setting and getting of intercepts is supported for acyclic SEMs only. The internal parameterizations uses variable means; the relationship between variable means and intercepts has not been fully worked out for the cyclic case.");
        }
        SemGraph semGraph = this.getSemPm().getGraph();
        List<Node> tierOrdering = semGraph.getTierOrdering();
        double[] intercepts = new double[tierOrdering.size()];
        for (i = 0; i < tierOrdering.size(); ++i) {
            _node = tierOrdering.get(i);
            intercepts[i] = this.getIntercept(_node);
        }
        intercepts[tierOrdering.indexOf((Object)node)] = intercept;
        for (i = 0; i < tierOrdering.size(); ++i) {
            _node = tierOrdering.get(i);
            List<Node> parents = semGraph.getParents(_node);
            double weightedSumOfParentMeans = 0.0;
            for (Node parent : parents) {
                if (parent.getNodeType() == NodeType.ERROR) continue;
                double coef = this.getEdgeCoef(parent, _node);
                double mean = this.getMean(parent);
                weightedSumOfParentMeans += coef * mean;
            }
            double mean = weightedSumOfParentMeans + intercepts[i];
            this.setMean(_node, mean);
        }
    }

    @Override
    public double getIntercept(Node node) {
        if (this.isCyclic()) {
            return Double.NaN;
        }
        SemGraph semGrapb = this.getSemPm().getGraph();
        List<Node> parents = semGrapb.getParents(node);
        double weightedSumOfParentMeans = 0.0;
        for (Node parent : parents) {
            if (parent.getNodeType() == NodeType.ERROR) continue;
            double coef = this.getEdgeCoef(parent, node);
            double mean = this.getMean(parent);
            weightedSumOfParentMeans += coef * mean;
        }
        double mean = this.getMean(node);
        double intercept = mean - weightedSumOfParentMeans;
        return this.round(intercept, 10);
    }

    @Override
    public double getMean(Node node) {
        int index = this.variableNodes.indexOf(node);
        return this.variableMeans[index];
    }

    public double[] getMeans() {
        double[] means = new double[this.variableMeans.length];
        System.arraycopy(this.variableMeans, 0, means, 0, this.variableMeans.length);
        return means;
    }

    @Override
    public double getMeanStdDev(Node node) {
        int index = this.variableNodes.indexOf(node);
        return this.variableMeansStdDev[index];
    }

    @Override
    public double getVariance(Node node) {
        if (this.getSemPm().getGraph().isExogenous(node)) {
            Parameter parameter = this.getSemPm().getVarianceParameter(node);
            if (parameter == null) {
                return Double.NaN;
            }
            return this.getParamValue(parameter);
        }
        int index = this.variableNodes.indexOf(node);
        DoubleMatrix2D impliedCovar = this.getImplCovar();
        return impliedCovar.get(index, index);
    }

    @Override
    public double getStdDev(Node node) {
        return Math.sqrt(this.getVariance(node));
    }

    @Override
    public double getParamValue(Node nodeA, Node nodeB) {
        Parameter parameter = null;
        if (nodeA == nodeB) {
            parameter = this.getSemPm().getVarianceParameter(nodeA);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCovarianceParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCoefficientParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            return Double.NaN;
        }
        if (!this.getFreeParameters().contains(parameter)) {
            return Double.NaN;
        }
        return this.getParamValue(parameter);
    }

    @Override
    public void setParamValue(Node nodeA, Node nodeB, double value) {
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("Parameters must be set to defined values (not NaN).");
        }
        Parameter parameter = null;
        if (nodeA == nodeB) {
            parameter = this.getSemPm().getVarianceParameter(nodeA);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCoefficientParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            parameter = this.getSemPm().getCovarianceParameter(nodeA, nodeB);
        }
        if (parameter == null) {
            throw new IllegalArgumentException("There is no parameter in model for an edge from " + nodeA + " to " + nodeB + ".");
        }
        if (!this.getFreeParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a free parameter in this model: " + parameter);
        }
        this.setParamValue(parameter, value);
    }

    @Override
    public List<Parameter> getFreeParameters() {
        return this.freeParameters;
    }

    @Override
    public int getNumFreeParams() {
        return this.getFreeParameters().size();
    }

    @Override
    public List<Parameter> getFixedParameters() {
        return this.fixedParameters;
    }

    public List<Parameter> getMeanParameters() {
        return this.meanParameters;
    }

    public int getNumFixedParams() {
        return this.getFixedParameters().size();
    }

    @Override
    public List<Node> getVariableNodes() {
        return this.variableNodes;
    }

    @Override
    public List<Node> getMeasuredNodes() {
        return this.measuredNodes;
    }

    @Override
    public int getSampleSize() {
        return this.sampleSize;
    }

    public DoubleMatrix2D getEdgeCoef() {
        return this.edgeCoef().copy();
    }

    public DoubleMatrix2D getErrCovar() {
        return this.errCovar().copy();
    }

    @Override
    public DoubleMatrix2D getImplCovar() {
        return this.implCovar().copy();
    }

    @Override
    public DoubleMatrix2D getImplCovarMeas() {
        return this.implCovarMeas().copy();
    }

    public DoubleMatrix2D getSampleCovar() {
        return this.sampleCovar() == null ? null : this.sampleCovar().copy();
    }

    public void setDistribution(Node node, Distribution distribution) {
        if (node == null) {
            throw new NullPointerException();
        }
        if (!this.getVariableNodes().contains(node)) {
            throw new IllegalArgumentException("Not a node in this SEM.");
        }
        if (distribution == null) {
            throw new NullPointerException("Distribution must be specified.");
        }
        this.distributions.put(node, distribution);
    }

    @Override
    public double getFml() {
        DoubleMatrix2D implCovarMeas;
        try {
            implCovarMeas = this.implCovarMeas();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        DoubleMatrix2D sampleCovar = this.sampleCovar();
        double logDetSigma = this.logDet(implCovarMeas);
        double traceSSigmaInv = this.traceABInv(sampleCovar, implCovarMeas);
        double logDetSample = this.logDetSample();
        int pPlusQ = this.getMeasuredNodes().size();
        double fml = logDetSigma + traceSSigmaInv - logDetSample - (double)pPlusQ;
        if (Math.abs(fml) < 1.0E-14) {
            fml = 0.0;
        }
        return fml;
    }

    public double getLogLikelihood() {
        DoubleMatrix2D SigmaTheta;
        try {
            SigmaTheta = this.implCovarMeas();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        DoubleMatrix2D sStar = this.sampleCovar();
        double logDetSigmaTheta = this.logDet(SigmaTheta);
        double traceSStarSigmaInv = this.traceABInv(sStar, SigmaTheta);
        int pPlusQ = this.getMeasuredNodes().size();
        return -((double)this.sampleSize / 2.0) * (double)pPlusQ * Math.log(Math.PI * 2) - (double)this.sampleSize / 2.0 * logDetSigmaTheta - (double)this.sampleSize / 2.0 * traceSStarSigmaInv;
    }

    public double getFml2() {
        DoubleMatrix2D sigma;
        try {
            sigma = this.implCovarMeas();
        }
        catch (Exception e) {
            return Double.NaN;
        }
        DoubleMatrix2D s = this.sampleCovar();
        DoubleMatrix2D sInv = new Algebra().inverse(s);
        DoubleMatrix2D prod = new Algebra().mult(sigma, sInv);
        DoubleMatrix2D identity = DoubleFactory2D.dense.identity(s.rows());
        prod.assign(identity, PlusMult.plusMult(-1.0));
        double trace = MatrixUtils.trace(new Algebra().mult(prod, prod));
        double f = 0.5 * trace;
        return f;
    }

    public double getTruncLL() {
        DoubleMatrix2D Sigma = this.implCovarMeas();
        DoubleMatrix2D S = this.sampleCovar();
        int n = this.getSampleSize();
        return (double)(-(n - 1)) / 2.0 * (this.logDet(Sigma) + this.traceAInvB(Sigma, S));
    }

    @Override
    public double getBicScore() {
        int dof = this.getSemPm().getDof();
        return this.getChiSquare() - (double)dof * Math.log(this.sampleSize);
    }

    public double getFullBicScore() {
        int sampleSize = this.getSampleSize();
        double penalty = (double)this.getNumFreeParams() * Math.log(sampleSize);
        double L = this.getLogLikelihood();
        return -2.0 * L + penalty;
    }

    public double getKicScore() {
        double fml = this.getFml();
        int edgeCount = this.getSemPm().getGraph().getNumEdges();
        int sampleSize = this.getSampleSize();
        return -fml - (double)edgeCount * Math.log(sampleSize);
    }

    @Override
    public double getChiSquare() {
        return (double)(this.getSampleSize() - 1) * this.getFml();
    }

    @Override
    public double getPValue() {
        double pValue = 1.0 - ProbUtils.chisqCdf(this.getChiSquare(), this.semPm.getDof());
        return pValue;
    }

    public DataSet simulateData(int sampleSize, boolean latentDataSaved) {
        return this.simulateDataReducedForm(sampleSize, latentDataSaved);
    }

    public DataSet simulateData(int sampleSize, boolean latentDataSaved, long sampleSeed) {
        RandomUtil random = RandomUtil.getInstance();
        long seed = random.getSeed();
        random.setSeed(sampleSeed);
        DataSet dataSet = this.simulateData(sampleSize, latentDataSaved);
        random.setSeed(seed);
        return dataSet;
    }

    public DataSet simulateDataCholesky(int sampleSize, boolean latentDataSaved) {
        LinkedList<Node> variables = new LinkedList<Node>();
        if (latentDataSaved) {
            for (Node node : this.getVariableNodes()) {
                variables.add(node);
            }
        } else {
            for (Node node : this.getMeasuredNodes()) {
                variables.add(node);
            }
        }
        ArrayList<Node> newVariables = new ArrayList<Node>();
        for (Node node : variables) {
            ContinuousVariable continuousVariable = new ContinuousVariable(node.getName());
            continuousVariable.setNodeType(node.getNodeType());
            newVariables.add(continuousVariable);
        }
        DoubleMatrix2D impliedCovar = this.implCovar();
        ColtDataSet fullDataSet = new ColtDataSet(sampleSize, newVariables);
        DoubleMatrix2D cholesky = MatrixUtils.choleskyC(impliedCovar);
        block3: for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.rows()];
            for (int i = 0; i < exoData.length; ++i) {
                exoData[i] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            }
            double[] point = new double[exoData.length];
            for (int i = 0; i < exoData.length; ++i) {
                double sum = 0.0;
                for (int j = 0; j <= i; ++j) {
                    sum += cholesky.get(i, j) * exoData[j];
                }
                point[i] = sum;
            }
            double[] rowData = point;
            for (int col = 0; col < variables.size(); ++col) {
                int index = this.getVariableNodes().indexOf(variables.get(col));
                double value = rowData[index] + this.variableMeans[col];
                if (Double.isNaN(value) || Double.isInfinite(value)) {
                    throw new IllegalArgumentException("Value out of range: " + value);
                }
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block3;
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataRecursive(int sampleSize, boolean latentDataSaved) {
        LinkedList<Node> variables = new LinkedList<Node>();
        List<Node> variableNodes = this.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            variables.add(var);
        }
        ColtDataSet fullDataSet = new ColtDataSet(sampleSize, variables);
        SemGraph graph = this.getSemPm().getGraph();
        List<Node> tierOrdering = graph.getTierOrdering();
        int[] tierIndices = new int[variableNodes.size()];
        for (int i = 0; i < tierIndices.length; ++i) {
            tierIndices[i] = variableNodes.indexOf(tierOrdering.get(i));
        }
        int[][] _parents = new int[variableNodes.size()][];
        for (int i = 0; i < variableNodes.size(); ++i) {
            Node node = variableNodes.get(i);
            List<Node> parents = graph.getParents(node);
            Iterator<Node> j = parents.iterator();
            while (j.hasNext()) {
                Node _node = j.next();
                if (_node.getNodeType() != NodeType.ERROR) continue;
                j.remove();
            }
            _parents[i] = new int[parents.size()];
            for (int j2 = 0; j2 < parents.size(); ++j2) {
                Node _parent = parents.get(j2);
                _parents[i][j2] = variableNodes.indexOf(_parent);
            }
        }
        DoubleMatrix2D cholesky = MatrixUtils.choleskyC(this.errCovar());
        block5: for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.rows()];
            for (int i = 0; i < exoData.length; ++i) {
                exoData[i] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            }
            double[] point = new double[exoData.length];
            for (int i = 0; i < exoData.length; ++i) {
                double sum = 0.0;
                for (int j1 = 0; j1 <= i; ++j1) {
                    sum += cholesky.get(i, j1) * exoData[j1];
                }
                point[i] = sum;
            }
            DenseDoubleMatrix1D e = new DenseDoubleMatrix1D(point);
            for (int tier = 0; tier < tierOrdering.size(); ++tier) {
                Node node = tierOrdering.get(tier);
                ConnectionFunction function = this.functions.get(node);
                int col = tierIndices[tier];
                Distribution distribution = this.distributions.get(node);
                double value = distribution == null ? e.get(col) : distribution.nextRandom();
                if (function != null) {
                    Node[] parents = function.getInputNodes();
                    double[] parentValues = new double[parents.length];
                    for (int j = 0; j < parents.length; ++j) {
                        Node parent = parents[j];
                        int index = variableNodes.indexOf(parent);
                        parentValues[j] = fullDataSet.getDouble(row, index);
                    }
                    value += function.valueAt(parentValues);
                    if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                        --row;
                        continue block5;
                    }
                    fullDataSet.setDouble(row, col, value);
                    continue;
                }
                for (int j = 0; j < _parents[col].length; ++j) {
                    int parent = _parents[col][j];
                    double parentValue = fullDataSet.getDouble(row, parent);
                    double parentCoef = this.edgeCoefC.get(parent, col);
                    value += parentValue * parentCoef;
                }
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block5;
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        for (int i = 0; i < fullDataSet.getNumRows(); ++i) {
            for (int j = 0; j < fullDataSet.getNumColumns(); ++j) {
                fullDataSet.setDouble(i, j, fullDataSet.getDouble(i, j) + this.variableMeans[j]);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataRecursiveNonlinear(int sampleSize, boolean latentDataSaved, double kappa) {
        int i;
        LinkedList<Node> variables = new LinkedList<Node>();
        List<Node> variableNodes = this.getVariableNodes();
        for (Node node : variableNodes) {
            ContinuousVariable var = new ContinuousVariable(node.getName());
            var.setNodeType(node.getNodeType());
            variables.add(var);
        }
        ColtDataSet fullDataSet = new ColtDataSet(sampleSize, variables);
        SemGraph graph = this.getSemPm().getGraph();
        List<Node> tierOrdering = graph.getTierOrdering();
        int[] tierIndices = new int[variableNodes.size()];
        for (int i2 = 0; i2 < tierIndices.length; ++i2) {
            tierIndices[i2] = variableNodes.indexOf(tierOrdering.get(i2));
        }
        int[][] _parents = new int[variableNodes.size()][];
        for (i = 0; i < variableNodes.size(); ++i) {
            Node node = variableNodes.get(i);
            List<Node> parents = graph.getParents(node);
            Iterator<Node> j = parents.iterator();
            while (j.hasNext()) {
                Node _node = j.next();
                if (_node.getNodeType() != NodeType.ERROR) continue;
                j.remove();
            }
            _parents[i] = new int[parents.size()];
            for (int j2 = 0; j2 < parents.size(); ++j2) {
                Node _parent = parents.get(j2);
                _parents[i][j2] = variableNodes.indexOf(_parent);
            }
        }
        block5: for (int row = 0; row < sampleSize; ++row) {
            for (int tier = 0; tier < tierOrdering.size(); ++tier) {
                int j;
                Node node = tierOrdering.get(tier);
                ConnectionFunction function = this.functions.get(node);
                int col = tierIndices[tier];
                Distribution distribution = this.distributions.get(node);
                double value = distribution == null ? RandomUtil.getInstance().nextNormal(0.0, Math.sqrt(this.getErrVar(node))) : distribution.nextRandom();
                if (function != null) {
                    Node[] parents = function.getInputNodes();
                    double[] parentValues = new double[parents.length];
                    for (j = 0; j < parents.length; ++j) {
                        Node parent = parents[j];
                        int index = variableNodes.indexOf(parent);
                        parentValues[j] = fullDataSet.getDouble(row, index);
                    }
                    value += function.valueAt(parentValues);
                    if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                        --row;
                        continue block5;
                    }
                    fullDataSet.setDouble(row, col, value);
                    continue;
                }
                double val = value;
                value = 0.0;
                for (j = 0; j < _parents[col].length; ++j) {
                    int parent = _parents[col][j];
                    double parentValue = fullDataSet.getDouble(row, parent);
                    double parentCoef = this.edgeCoefC.get(parent, col);
                    value += parentValue * parentCoef;
                }
                value += val;
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block5;
                }
                fullDataSet.setDouble(row, col, value);
            }
        }
        for (i = 0; i < fullDataSet.getNumRows(); ++i) {
            for (int j = 0; j < fullDataSet.getNumColumns(); ++j) {
                fullDataSet.setDouble(i, j, fullDataSet.getDouble(i, j) + this.variableMeans[j]);
            }
        }
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public DataSet simulateDataReducedForm(int sampleSize, boolean latentDataSaved) {
        int numVars = this.getVariableNodes().size();
        DoubleMatrix2D edgeCoef = this.edgeCoef().copy().viewDice();
        DoubleMatrix2D iMinusB = DoubleFactory2D.dense.identity(edgeCoef.rows());
        iMinusB.assign(edgeCoef, Functions.minus);
        DoubleMatrix2D inv = new Algebra().inverse(iMinusB);
        DenseDoubleMatrix2D sim = new DenseDoubleMatrix2D(sampleSize, numVars);
        DoubleMatrix2D cholesky = MatrixUtils.choleskyC(this.errCovar());
        block0: for (int row = 0; row < sampleSize; ++row) {
            double[] exoData = new double[cholesky.rows()];
            for (int i1 = 0; i1 < exoData.length; ++i1) {
                exoData[i1] = RandomUtil.getInstance().nextNormal(0.0, 1.0);
            }
            double[] point = new double[exoData.length];
            for (int i1 = 0; i1 < exoData.length; ++i1) {
                double sum = 0.0;
                for (int j1 = 0; j1 <= i1; ++j1) {
                    sum += cholesky.get(i1, j1) * exoData[j1];
                }
                point[i1] = sum;
            }
            DenseDoubleMatrix1D e = new DenseDoubleMatrix1D(point);
            for (int j = 0; j < e.size(); ++j) {
                Node node = this.getVariableNodes().get(j);
                Distribution distribution = this.distributions.get(node);
                if (distribution == null) continue;
                e.set(j, distribution.nextRandom());
            }
            DoubleMatrix1D ePrime = new Algebra().mult(inv, (DoubleMatrix1D)e);
            sim.viewRow(row).assign(ePrime);
            for (int col = 0; col < ePrime.size(); ++col) {
                double value = sim.get(row, col) + this.variableMeans[col];
                if (this.isSimulatedPositiveDataOnly() && value < 0.0) {
                    --row;
                    continue block0;
                }
                sim.set(row, col, value);
            }
        }
        ColtDataSet fullDataSet = ColtDataSet.makeContinuousData(this.getVariableNodes(), sim);
        if (latentDataSaved) {
            return fullDataSet;
        }
        return DataUtils.restrictToMeasured(fullDataSet);
    }

    public final void initializeValues() {
        int trial = 0;
        if (++trial < 2000) {
            Parameter parameter;
            for (Mapping fixedMapping : this.fixedMappings) {
                parameter = fixedMapping.getParameter();
                fixedMapping.setValue(this.initialValue(parameter));
            }
            for (Mapping freeMapping : this.freeMappings) {
                parameter = freeMapping.getParameter();
                freeMapping.setValue(this.initialValue(parameter));
            }
            return;
        }
        throw new IllegalArgumentException("Could not find a parameterization of the SEM in which the error covariance matrix was positive definite and the edge coefficients were stable.");
    }

    private static boolean allEigenvaluesAreSmallerThanOneInModulus(DoubleMatrix2D b) {
        EigenvalueDecomposition dec = new EigenvalueDecomposition(b);
        DoubleMatrix1D realEigenvalues = dec.getRealEigenvalues();
        DoubleMatrix1D imagEigenvalues = dec.getImagEigenvalues();
        boolean allEigenvaluesSmallerThanOneInModulus = true;
        for (int i = 0; i < realEigenvalues.size(); ++i) {
            double realEigenvalue = realEigenvalues.get(i);
            double imagEigenvalue = imagEigenvalues.get(i);
            double modulus = Math.sqrt(Math.pow(realEigenvalue, 2.0) + Math.pow(imagEigenvalue, 2.0));
            if (!(modulus >= 1.0)) continue;
            allEigenvaluesSmallerThanOneInModulus = false;
        }
        return allEigenvaluesSmallerThanOneInModulus;
    }

    @Override
    public double getStandardError(Parameter parameter, int maxFreeParams) {
        if (this.getFreeParameters().contains(parameter)) {
            if (this.getNumFreeParams() <= maxFreeParams) {
                if (this.sampleCovar() == null) {
                    this.standardErrors = null;
                    return Double.NaN;
                }
                int index = this.getFreeParameters().indexOf(parameter);
                return this.standardErrors()[index];
            }
            return Double.NaN;
        }
        if (this.getFixedParameters().contains(parameter)) {
            return 0.0;
        }
        throw new IllegalArgumentException("That is not a parameter of this model: " + parameter);
    }

    @Override
    public List<Node> listUnmeasuredLatents() {
        return this.unmeasuredLatents(this.getSemPm());
    }

    @Override
    public double getTValue(Parameter parameter, int maxFreeParams) {
        return this.getParamValue(parameter) / this.getStandardError(parameter, maxFreeParams);
    }

    @Override
    public double getPValue(Parameter parameter, int maxFreeParams) {
        double tValue = this.getTValue(parameter, maxFreeParams);
        int df = this.getSampleSize() - 1;
        return 2.0 * (1.0 - ProbUtils.tCdf(Math.abs(tValue), df));
    }

    @Override
    public boolean isParameterBoundsEnforced() {
        return this.parameterBoundsEnforced;
    }

    @Override
    public void setParameterBoundsEnforced(boolean parameterBoundsEnforced) {
        this.parameterBoundsEnforced = parameterBoundsEnforced;
    }

    @Override
    public boolean isEstimated() {
        return this.estimated;
    }

    public void setEstimated(boolean estimated) {
        this.estimated = estimated;
    }

    @Override
    public boolean isCyclic() {
        if (!this.cyclicTested) {
            this.cyclic = this.semPm.getGraph().existsDirectedCycle();
        }
        return this.cyclic;
    }

    public boolean isCheckPositiveDefinite() {
        return this.checkPositiveDefinite;
    }

    public void setCheckPositiveDefinite(boolean checkPositiveDefinite) {
        this.checkPositiveDefinite = checkPositiveDefinite;
    }

    public Node getVariableNode(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        List<Node> variables = this.getVariableNodes();
        for (Node variable : variables) {
            if (!name.equals(variable.getName())) continue;
            return variable;
        }
        return null;
    }

    public String toString() {
        Mapping iMapping;
        int i;
        StringBuilder buf = new StringBuilder();
        buf.append("\nVariable nodes:\n\n");
        buf.append(this.getVariableNodes());
        buf.append("\n\nMeasured nodes:\n\n");
        buf.append(this.getMeasuredNodes());
        buf.append("\n\nEdge coefficient matrix:\n");
        buf.append(MatrixUtils.toString(this.edgeCoef().toArray()));
        buf.append("\n\nError covariance matrix:\n");
        buf.append(MatrixUtils.toString(this.getErrCovar().toArray()));
        buf.append("\n\nVariable means:\n");
        for (i = 0; i < this.getVariableNodes().size(); ++i) {
            buf.append("\nMean(");
            buf.append(this.getVariableNodes().get(i));
            buf.append(") = ");
            buf.append(this.variableMeans[i]);
        }
        buf.append("\n\nSample size = ");
        buf.append(this.sampleSize);
        if (this.sampleCovarC == null) {
            buf.append("\n\nSample covaraince matrix not specified**");
        } else {
            buf.append("\n\nsample cov:\n");
            buf.append(MatrixUtils.toString(this.getSampleCovar().toArray()));
        }
        buf.append("\n\nimplCovar:\n");
        buf.append(MatrixUtils.toString(this.implCovar().toArray()));
        buf.append("\n\nimplCovarMeas:\n");
        buf.append(MatrixUtils.toString(this.implCovarMeas().toArray()));
        if (this.sampleCovarC != null) {
            buf.append("\n\nmodel chi square = ");
            buf.append(this.getChiSquare());
            buf.append("\nmodel dof = ");
            buf.append(this.semPm.getDof());
            buf.append("\nmodel p-value = ");
            buf.append(this.getPValue());
        }
        buf.append("\n\nfree mappings:\n");
        for (i = 0; i < this.freeMappings.size(); ++i) {
            iMapping = this.freeMappings.get(i);
            buf.append("\n");
            buf.append(i);
            buf.append(". ");
            buf.append(iMapping);
        }
        buf.append("\n\nfixed mappings:\n");
        for (i = 0; i < this.fixedMappings.size(); ++i) {
            iMapping = this.fixedMappings.get(i);
            buf.append("\n");
            buf.append(i);
            buf.append(". ");
            buf.append(iMapping);
        }
        return buf.toString();
    }

    private final void retainPreviousValues(SemIm oldSemIm) {
        if (oldSemIm == null) {
            System.out.println("old sem im null");
            return;
        }
        System.out.println("Resetting param values");
        List<Node> nodes = this.semPm.getGraph().getNodes();
        SemGraph oldGraph = oldSemIm.getSemPm().getGraph();
        for (Node nodeA : nodes) {
            for (Node nodeB : nodes) {
                Node _nodeA = oldGraph.getNode(nodeA.getName());
                Node _nodeB = oldGraph.getNode(nodeB.getName());
                if (_nodeA == null || _nodeB == null) continue;
                double _value = oldSemIm.getParamValue(_nodeA, _nodeB);
                if (!Double.isNaN(_value)) {
                    try {
                        Parameter _parameter = oldSemIm.getSemPm().getParameter(_nodeA, _nodeB);
                        Parameter parameter = this.getSemPm().getParameter(nodeA, nodeB);
                        if (parameter == null || _parameter == null || parameter.getType() != _parameter.getType() || parameter.isFixed()) continue;
                        this.setParamValue(nodeA, nodeB, _value);
                    }
                    catch (IllegalArgumentException e) {
                        System.out.println("Couldn't set " + nodeA + ", " + nodeB);
                    }
                    continue;
                }
                System.out.println("NaN: " + nodeA + ", " + nodeB);
            }
        }
    }

    private double logDetSample() {
        if (this.logDetSample == 0.0 && this.getSampleCovar() != null) {
            double det = MatrixUtils.determinant(this.getSampleCovar());
            this.logDetSample = Math.log(det);
        }
        return this.logDetSample;
    }

    private List<Node> unmeasuredLatents(SemPm semPm) {
        SemGraph graph = semPm.getGraph();
        LinkedList<Node> unmeasuredLatents = new LinkedList<Node>();
        block0: for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            for (Node child : graph.getChildren(node)) {
                if (child.getNodeType() != NodeType.MEASURED) continue;
                continue block0;
            }
            unmeasuredLatents.add(node);
        }
        return unmeasuredLatents;
    }

    private DoubleMatrix2D errCovar() {
        return this.errCovarC;
    }

    private DoubleMatrix2D implCovar() {
        this.computeImpliedCovar();
        return this.implCovarC;
    }

    private DoubleMatrix2D implCovarMeas() {
        this.computeImpliedCovar();
        return this.implCovarMeasC;
    }

    private List<Parameter> initFreeParameters() {
        return Collections.unmodifiableList(this.semPm.getFreeParameters());
    }

    private double initialValue(Parameter parameter) {
        if (!this.getSemPm().getParameters().contains(parameter)) {
            throw new IllegalArgumentException("Not a parameter for this SEM: " + parameter);
        }
        if (parameter.isInitializedRandomly()) {
            if (parameter.getType() == ParamType.COEF) {
                double value;
                if (this.getInitializationParams().getCoefLow() == this.getInitializationParams().getCoefHigh()) {
                    value = this.getInitializationParams().getCoefLow();
                } else if (this.getInitializationParams().isCoefSymmetric()) {
                    while ((value = RandomUtil.getInstance().nextUniform(-this.getInitializationParams().getCoefHigh(), this.getInitializationParams().getCoefHigh())) > -this.getInitializationParams().getCoefLow() && value < this.getInitializationParams().getCoefLow()) {
                    }
                } else {
                    value = RandomUtil.getInstance().nextUniform(this.getInitializationParams().getCoefLow(), this.getInitializationParams().getCoefHigh());
                }
                return value;
            }
            if (parameter.getType() == ParamType.COVAR) {
                double value;
                if (this.getInitializationParams().getCovLow() == this.getInitializationParams().getCovHigh()) {
                    value = this.getInitializationParams().getCovLow();
                } else if (this.getInitializationParams().isCovSymmetric()) {
                    while ((value = RandomUtil.getInstance().nextUniform(-this.getInitializationParams().getCovHigh(), this.getInitializationParams().getCovHigh())) > -this.getInitializationParams().getCovLow() && value < this.getInitializationParams().getCovLow()) {
                    }
                } else {
                    value = RandomUtil.getInstance().nextUniform(this.getInitializationParams().getCovLow(), this.getInitializationParams().getCovHigh());
                }
                return value;
            }
            return RandomUtil.getInstance().nextUniform(this.getInitializationParams().getVarLow(), this.getInitializationParams().getVarHigh());
        }
        return parameter.getStartingValue();
    }

    private List<Mapping> freeMappings() {
        return this.freeMappings;
    }

    private CovarianceMatrix fixVarOrder(CovarianceMatrix covMatrix) {
        ArrayList<String> varNamesList = new ArrayList<String>();
        for (int i = 0; i < this.getMeasuredNodes().size(); ++i) {
            Node node = this.getMeasuredNodes().get(i);
            varNamesList.add(node.getName());
        }
        String[] measuredVarNames = varNamesList.toArray(new String[0]);
        return covMatrix.getSubmatrix(measuredVarNames);
    }

    private List<Mapping> createMappings(List<Parameter> parameters) {
        ArrayList<Mapping> mappings = new ArrayList<Mapping>();
        SemGraph graph = this.getSemPm().getGraph();
        for (Parameter parameter : parameters) {
            Mapping mapping;
            Node nodeA = graph.getVarNode(parameter.getNodeA());
            Node nodeB = graph.getVarNode(parameter.getNodeB());
            int i = this.getVariableNodes().indexOf(nodeA);
            int j = this.getVariableNodes().indexOf(nodeB);
            if (parameter.getType() == ParamType.COEF) {
                mapping = new Mapping(this, parameter, this.edgeCoef(), i, j);
                mappings.add(mapping);
                continue;
            }
            if (parameter.getType() == ParamType.VAR) {
                mapping = new Mapping(this, parameter, this.errCovar(), i, i);
                mappings.add(mapping);
                continue;
            }
            if (parameter.getType() != ParamType.COVAR) continue;
            mapping = new Mapping(this, parameter, this.errCovar(), i, j);
            mappings.add(mapping);
        }
        return Collections.unmodifiableList(mappings);
    }

    private List<Parameter> initFixedParameters() {
        ArrayList<Parameter> fixedParameters = new ArrayList<Parameter>();
        for (Parameter _parameter : this.getSemPm().getParameters()) {
            ParamType type = _parameter.getType();
            if (type != ParamType.VAR && type != ParamType.COVAR && type != ParamType.COEF || !_parameter.isFixed()) continue;
            fixedParameters.add(_parameter);
        }
        return Collections.unmodifiableList(fixedParameters);
    }

    private List<Parameter> initMeanParameters() {
        ArrayList<Parameter> meanParameters = new ArrayList<Parameter>();
        for (Parameter param : this.getSemPm().getParameters()) {
            if (param.getType() != ParamType.MEAN) continue;
            meanParameters.add(param);
        }
        return Collections.unmodifiableList(meanParameters);
    }

    private void computeImpliedCovar() {
        DoubleMatrix2D edgeCoefT = this.getAlgebra().transpose(this.edgeCoef());
        this.implCovarC = MatrixUtils.impliedCovarC(edgeCoefT, this.errCovar());
        int size = this.getMeasuredNodes().size();
        this.implCovarMeasC = new DenseDoubleMatrix2D(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                Node iNode = this.getMeasuredNodes().get(i);
                Node jNode = this.getMeasuredNodes().get(j);
                int _i = this.getVariableNodes().indexOf(iNode);
                int _j = this.getVariableNodes().indexOf(jNode);
                this.implCovarMeasC.set(i, j, this.implCovarC.get(_i, _j));
            }
        }
    }

    private double logDet(DoubleMatrix2D matrix2D) {
        return Math.log(new Algebra().det(matrix2D));
    }

    private double traceAInvB(DoubleMatrix2D A, DoubleMatrix2D B) {
        DoubleMatrix2D inverse = new Algebra().inverse(A);
        DoubleMatrix2D product = new Algebra().mult(inverse, B);
        double trace = new Algebra().trace(product);
        if (trace < 0.0) {
            throw new IllegalArgumentException("Trace was negative: " + trace);
        }
        return trace;
    }

    private double traceABInv(DoubleMatrix2D A, DoubleMatrix2D B) {
        DoubleMatrix2D inverse = new Algebra().inverse(B);
        DoubleMatrix2D product = new Algebra().mult(A, inverse);
        double trace = new Algebra().trace(product);
        if (trace < -1.0E-8) {
            throw new IllegalArgumentException("Trace was negative: " + trace);
        }
        return trace;
    }

    private DoubleMatrix2D sampleCovar() {
        return this.sampleCovarC;
    }

    private DoubleMatrix2D edgeCoef() {
        return this.edgeCoefC;
    }

    private double[] standardErrors() {
        if (this.standardErrors == null) {
            SemStdErrorEstimator estimator = new SemStdErrorEstimator();
            estimator.computeStdErrors(this);
            this.standardErrors = estimator.getStdErrors();
        }
        return this.standardErrors;
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.semPm == null) {
            throw new NullPointerException();
        }
        if (this.variableNodes == null) {
            throw new NullPointerException();
        }
        if (this.measuredNodes == null) {
            throw new NullPointerException();
        }
        if (this.edgeCoef != null) {
            this.edgeCoefC = new DenseDoubleMatrix2D(this.edgeCoef);
            this.edgeCoef = null;
        }
        if (this.errCovar != null) {
            this.errCovarC = new DenseDoubleMatrix2D(this.errCovar);
            this.errCovar = null;
        }
        if (this.sampleCovar != null) {
            this.sampleCovarC = new DenseDoubleMatrix2D(this.sampleCovar);
            this.sampleCovar = null;
        }
        if (this.implCovar != null) {
            this.implCovarC = new DenseDoubleMatrix2D(this.implCovar);
            this.implCovar = null;
        }
        if (this.implCovarMeas != null) {
            this.implCovarMeasC = new DenseDoubleMatrix2D(this.implCovarMeas);
            this.implCovarMeas = null;
        }
        if (this.variableMeans == null) {
            throw new NullPointerException();
        }
        if (this.freeParameters == null) {
            throw new NullPointerException();
        }
        if (this.freeMappings == null) {
            throw new NullPointerException();
        }
        if (this.fixedParameters == null) {
            throw new NullPointerException();
        }
        if (this.fixedMappings == null) {
            throw new NullPointerException();
        }
        if (this.meanParameters == null) {
            this.meanParameters = this.initMeanParameters();
        }
        if (this.sampleSize < 0) {
            throw new IllegalArgumentException("Sample size out of range: " + this.sampleSize);
        }
        if (this.getInitializationParams() == null) {
            this.setInitializationParams(new SemImInitializationParams());
        }
        if (this.distributions == null) {
            this.distributions = new HashMap<Node, Distribution>();
        }
    }

    private Algebra getAlgebra() {
        if (this.algebra == null) {
            this.algebra = new Algebra();
        }
        return this.algebra;
    }

    private double round(double value, int decimalPlace) {
        double power_of_ten = 1.0;
        while (decimalPlace-- > 0) {
            power_of_ten *= 10.0;
        }
        return (double)Math.round(value * power_of_ten) / power_of_ten;
    }

    public SemImInitializationParams getInitializationParams() {
        return this.initializationParams;
    }

    public void setInitializationParams(SemImInitializationParams initializationParams) {
        this.initializationParams = initializationParams;
    }

    public void setFunction(Node node, ConnectionFunction function) {
        List<Node> parents = this.semPm.getGraph().getParents(node);
        Iterator<Node> j = parents.iterator();
        while (j.hasNext()) {
            Node _node = j.next();
            if (_node.getNodeType() != NodeType.ERROR) continue;
            j.remove();
        }
        HashSet<Node> parentSet = new HashSet<Node>(parents);
        List<Node> inputList = Arrays.asList(function.getInputNodes());
        HashSet<Node> inputSet = new HashSet<Node>(inputList);
        if (!parentSet.equals(inputSet)) {
            throw new IllegalArgumentException("The given function for " + node + " may only use the parents of " + node + ": " + parents);
        }
        this.functions.put(node, function);
    }

    public ConnectionFunction getConnectionFunction(Node node) {
        return this.functions.get(node);
    }

    public double[] getVariableMeans() {
        return this.variableMeans;
    }

    @Override
    public boolean isSimulatedPositiveDataOnly() {
        return this.simulatedPositiveDataOnly;
    }

    @Override
    public void setSimulatedPositiveDataOnly(boolean simulatedPositiveDataOnly) {
        this.simulatedPositiveDataOnly = simulatedPositiveDataOnly;
    }
}

