/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.graph.SemGraph;
import edu.cmu.tetrad.sem.ISemIm;
import edu.cmu.tetrad.sem.ParamType;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import java.util.LinkedList;
import java.util.List;

public class SemStdErrorEstimator {
    private static final double CON = 1.4;
    private static final double CON2 = 1.9599999999999997;
    private static final double BIG = 1.0E30;
    private static final int NTAB = 10;
    private static final double SAFE = 2.0;
    private double[] stdErrs = null;

    public void computeStdErrors(ISemIm estSem) {
        int i;
        estSem.setParameterBoundsEnforced(false);
        double[] paramsOriginal = estSem.getFreeParamValues();
        SemFittingFunction fcn = new SemFittingFunction(estSem);
        boolean ridder = false;
        int n = fcn.getNumParameters();
        double[] params = new double[n];
        System.arraycopy(paramsOriginal, 0, params, 0, n);
        double delta = ridder ? 0.1 : 0.005;
        DenseDoubleMatrix2D hess = new DenseDoubleMatrix2D(n, n);
        List<Parameter> freeParameters = estSem.getFreeParameters();
        boolean containsCovararianceParameter = false;
        for (Parameter p : freeParameters) {
            if (p.getType() != ParamType.COVAR) continue;
            containsCovararianceParameter = true;
            break;
        }
        for (i = 0; i < n; ++i) {
            for (int j = i; j < n; ++j) {
                Parameter pi = freeParameters.get(i);
                Parameter pj = freeParameters.get(j);
                if (!containsCovararianceParameter && (i != j && (pi.getType() != ParamType.COEF || pj.getType() != ParamType.COEF) || pi.getNodeB() != pj.getNodeB())) continue;
                double v = ridder ? this.secondPartialDerivativeRidr(fcn, i, j, params, delta) : this.secondPartialDerivative(fcn, i, j, params, delta);
                if (Math.abs(v) < 1.0E-7) {
                    v = 0.0;
                }
                hess.set(i, j, v);
                hess.set(j, i, v);
            }
        }
        for (i = 0; i < hess.rows(); ++i) {
            for (int j = 0; j < hess.columns() && hess.get(i, j) == 0.0; ++j) {
            }
        }
        try {
            DoubleMatrix2D hessInv = MatrixUtils.ginverse(hess);
            this.stdErrs = new double[n];
            for (int i2 = 0; i2 < n; ++i2) {
                double v = Math.sqrt(2.0 / (double)(estSem.getSampleSize() - 1) * hessInv.get(i2, i2));
                if (v == 0.0) {
                    System.out.println("v = " + v + " hessInv(i, i) = " + hessInv.get(i2, i2));
                }
                this.stdErrs[i2] = v == 0.0 ? Double.NaN : v;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.stdErrs = new double[n];
            for (int i3 = 0; i3 < n; ++i3) {
                this.stdErrs[i3] = Double.NaN;
            }
        }
        estSem.setFreeParamValues(paramsOriginal);
        estSem.setParameterBoundsEnforced(true);
    }

    private List<Node> unmeasuredLatents(SemPm semPm) {
        SemGraph graph = semPm.getGraph();
        LinkedList<Node> unmeasuredLatents = new LinkedList<Node>();
        block0: for (Node node : graph.getNodes()) {
            if (node.getNodeType() != NodeType.LATENT) continue;
            for (Node child : graph.getChildren(node)) {
                if (child.getNodeType() != NodeType.MEASURED) continue;
                continue block0;
            }
            unmeasuredLatents.add(node);
        }
        return unmeasuredLatents;
    }

    public double[] getStdErrors() {
        return this.stdErrs;
    }

    public double secondPartialDerivative(FittingFunction f, int i, int j, double[] p, double delt) {
        double[] arg = new double[p.length];
        System.arraycopy(p, 0, arg, 0, p.length);
        int n = i;
        arg[n] = arg[n] + delt;
        int n2 = j;
        arg[n2] = arg[n2] + delt;
        double ff1 = f.evaluate(arg);
        int n3 = j;
        arg[n3] = arg[n3] - 2.0 * delt;
        double ff2 = f.evaluate(arg);
        int n4 = i;
        arg[n4] = arg[n4] - 2.0 * delt;
        int n5 = j;
        arg[n5] = arg[n5] + 2.0 * delt;
        double ff3 = f.evaluate(arg);
        int n6 = j;
        arg[n6] = arg[n6] - 2.0 * delt;
        double ff4 = f.evaluate(arg);
        double fsSum = ff1 - ff2 - ff3 + ff4;
        return fsSum / (4.0 * delt * delt);
    }

    public double secondPartialDerivativeRidr(FittingFunction f, int i, int j, double[] args, double delt) {
        double[] arg = new double[args.length];
        double[][] a = new double[10][10];
        double hh = delt;
        double ans = 0.0;
        System.arraycopy(args, 0, arg, 0, args.length);
        int n = i;
        arg[n] = arg[n] + delt;
        int n2 = j;
        arg[n2] = arg[n2] + delt;
        double ff1 = f.evaluate(arg);
        int n3 = j;
        arg[n3] = arg[n3] - 2.0 * delt;
        double ff2 = f.evaluate(arg);
        int n4 = i;
        arg[n4] = arg[n4] - 2.0 * delt;
        int n5 = j;
        arg[n5] = arg[n5] + 2.0 * delt;
        double ff3 = f.evaluate(arg);
        int n6 = j;
        arg[n6] = arg[n6] - 2.0 * delt;
        double ff4 = f.evaluate(arg);
        a[0][0] = (ff1 - ff2 - ff3 + ff4) / (4.0 * delt * delt);
        double err = 1.0E30;
        for (int ii = 1; ii < 10; ++ii) {
            System.arraycopy(args, 0, arg, 0, args.length);
            int n7 = i;
            arg[n7] = arg[n7] + (hh /= 1.4);
            int n8 = j;
            arg[n8] = arg[n8] + hh;
            ff1 = f.evaluate(arg);
            int n9 = j;
            arg[n9] = arg[n9] - 2.0 * hh;
            ff2 = f.evaluate(arg);
            int n10 = i;
            arg[n10] = arg[n10] - 2.0 * hh;
            int n11 = j;
            arg[n11] = arg[n11] + 2.0 * hh;
            ff3 = f.evaluate(arg);
            int n12 = j;
            arg[n12] = arg[n12] - 2.0 * hh;
            ff4 = f.evaluate(arg);
            a[0][ii] = (ff1 - ff2 - ff3 + ff4) / (4.0 * hh * hh);
            double fac = 1.9599999999999997;
            for (int jj = 1; jj < ii; ++jj) {
                a[jj][ii] = (a[jj - 1][ii] * fac - a[jj - 1][ii - 1]) / (fac - 1.0);
                fac = 1.9599999999999997 * fac;
                double errt = Math.max(Math.abs(a[jj][ii] - a[jj - 1][ii]), Math.abs(a[jj][ii] - a[jj - 1][ii - 1]));
                if (!(errt < err)) continue;
                err = errt;
                ans = a[jj][ii];
            }
            if (Math.abs(a[ii][ii] - a[ii - 1][ii - 1]) >= 2.0 * err) break;
        }
        return ans;
    }

    static class SemFittingFunction
    implements FittingFunction {
        private final ISemIm sem;

        public SemFittingFunction(ISemIm sem) {
            this.sem = sem;
        }

        @Override
        public double evaluate(double[] parameters) {
            List<Parameter> _parameters = this.sem.getSemPm().getParameters();
            for (int i = 0; i < _parameters.size(); ++i) {
                Parameter parameter = _parameters.get(i);
                if (parameter.getType() != ParamType.VAR || !(parameters[i] < 0.0)) continue;
                parameters[i] = 0.0;
            }
            this.sem.setFreeParamValues(parameters);
            return this.sem.getFml();
        }

        @Override
        public int getNumParameters() {
            return this.sem.getNumFreeParams();
        }
    }

    static interface FittingFunction {
        public double evaluate(double[] var1);

        public int getNumParameters();
    }
}

