/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataUtils;
import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.sem.ParamComparison;
import edu.cmu.tetrad.sem.Parameter;
import edu.cmu.tetrad.sem.SemEstimator;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.util.MatrixUtils;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSem
extends TestCase {
    public TestSem(String name) {
        super(name);
    }

    public void testSet1() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix1();
        SemIm sem = new SemIm(semPm, covMatrix);
        System.out.println(sem);
    }

    public void testSet2() {
        Graph graph = this.constructGraph2();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix2();
        SemIm sem = new SemIm(semPm, covMatrix);
        System.out.println(sem);
    }

    public void testSet3() {
        Graph graph = this.constructGraph2();
        SemPm semPm = new SemPm(graph);
        List<Parameter> parameters = semPm.getParameters();
        Parameter a = parameters.get(0);
        Parameter b = parameters.get(1);
        TestSem.assertEquals(ParamComparison.NC, semPm.getParamComparison(a, b));
        semPm.setParamComparison(a, b, ParamComparison.EQ);
        TestSem.assertEquals(ParamComparison.EQ, semPm.getParamComparison(a, b));
        TestSem.assertEquals(ParamComparison.EQ, semPm.getParamComparison(b, a));
    }

    public void testEstimation() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        CovarianceMatrix covMatrix = this.constructCovMatrix1();
        SemEstimator estimator = new SemEstimator(covMatrix, semPm);
        estimator.estimate();
        SemIm semIm2 = estimator.getEstimatedSem();
        System.out.println(semIm2);
        double[][] edgeCoef = semIm2.getEdgeCoef().toArray();
        double[][] _edgeCoef = new double[][]{{0.0, 0.775, 0.0, 1.3192, 0.0}, {0.0, 0.0, 1.0756, 0.0, 0.0}, {0.0, 0.0, 0.0, 0.9639, 0.0}, {0.0, 0.0, 0.0, 0.0, 0.5198}, {0.0, 0.0, 0.0, 0.0, 0.0}};
        for (int i = 0; i < edgeCoef.length; ++i) {
            for (int j = 0; j < edgeCoef[i].length; ++j) {
                TestSem.assertEquals(edgeCoef[i][j], _edgeCoef[i][j], 0.001);
            }
        }
        double[][] errCovar = semIm2.getErrCovar().toArray();
        double[][] _errCovar = new double[][]{{1.0439, 0.0, 0.0, 0.0, 0.0}, {0.0, 0.9293, 0.0, 0.0, 0.0}, {0.0, 0.0, 1.0756, 0.0, 0.0}, {0.0, 0.0, 0.0, 1.0233, 0.0}, {0.0, 0.0, 0.0, 0.0, 1.0465}};
        for (int i = 0; i < edgeCoef.length; ++i) {
            for (int j = 0; j < edgeCoef[i].length; ++j) {
                TestSem.assertEquals(errCovar[i][j], _errCovar[i][j], 0.001);
            }
        }
    }

    private Graph constructGraph1() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }

    private CovarianceMatrix constructCovMatrix1() {
        String[] vars = new String[]{"X1", "X2", "X3", "X4", "X5"};
        double[][] arr = new double[][]{{1.04408}, {0.80915, 1.55607}, {0.89296, 1.67375, 2.87584}, {2.23792, 2.68536, 3.94996, 7.78259}, {1.17516, 1.36337, 1.99039, 4.04533, 3.14922}};
        double[][] m = MatrixUtils.convertLowerTriangleToSymmetric(arr);
        DenseDoubleMatrix2D m2 = new DenseDoubleMatrix2D(m);
        System.out.println(MatrixUtils.toString(m));
        return new CovarianceMatrix(DataUtils.createContinuousVariables(vars), m2, 1000);
    }

    private Graph constructGraph2() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        GraphNode x6 = new GraphNode("X6");
        GraphNode x7 = new GraphNode("X7");
        GraphNode x8 = new GraphNode("X8");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addNode(x6);
        graph.addNode(x7);
        graph.addNode(x8);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x2, x6);
        graph.addDirectedEdge(x3, x7);
        graph.addDirectedEdge(x4, x5);
        graph.addDirectedEdge(x4, x6);
        graph.addDirectedEdge(x5, x3);
        graph.addDirectedEdge(x6, x8);
        graph.addDirectedEdge(x6, x7);
        return graph;
    }

    private CovarianceMatrix constructCovMatrix2() {
        String[] vars = new String[]{"X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8"};
        int sampleSize = 173;
        double[][] arr = new double[][]{{1.0}, {0.215, 1.0}, {-0.164, -0.472, 1.0}, {0.112, 0.079, -0.157, 1.0}, {0.034, 0.121, -0.184, 0.407, 1.0}, {0.101, 0.197, -0.19, 0.176, 0.12, 1.0}, {0.071, -0.172, 0.206, -0.049, -0.084, -0.291, 1.0}, {0.043, -0.038, -0.037, -0.062, 0.028, 0.166, -0.149, 1.0}};
        double[][] m = MatrixUtils.convertLowerTriangleToSymmetric(arr);
        DenseDoubleMatrix2D m2 = new DenseDoubleMatrix2D(m);
        return new CovarianceMatrix(DataUtils.createContinuousVariables(vars), m2, sampleSize);
    }

    public static Test suite() {
        return new TestSuite(TestSem.class);
    }
}

