/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.sem;

import edu.cmu.tetrad.graph.EdgeListGraph;
import edu.cmu.tetrad.graph.Graph;
import edu.cmu.tetrad.graph.GraphNode;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.sem.SemEvidence;
import edu.cmu.tetrad.sem.SemIm;
import edu.cmu.tetrad.sem.SemPm;
import edu.cmu.tetrad.sem.SemUpdater;
import java.util.List;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSemUpdater
extends TestCase {
    public TestSemUpdater(String name) {
        super(name);
    }

    public void testUpdate() {
        Graph graph = this.constructGraph1();
        SemPm semPm = new SemPm(graph);
        SemIm semIm = new SemIm(semPm);
        System.out.println("Original graph: " + semIm.getSemPm().getGraph());
        System.out.println("Original semIm: " + semIm);
        List<Node> nodes = semIm.getVariableNodes();
        SemUpdater semUpdater = new SemUpdater(semIm);
        SemEvidence evidence = new SemEvidence(semIm);
        evidence.getProposition().setValue(nodes.get(4), 10.0);
        semUpdater.setEvidence(evidence);
        evidence.setManipulated(1, true);
        SemIm manipulatedSemIm = semUpdater.getManipulatedSemIm();
        System.out.println("Manipulated Sem IM: " + manipulatedSemIm);
        System.out.println("Manipulated graph: " + manipulatedSemIm.getSemPm().getGraph());
        System.out.println("Manipulated semIm: " + manipulatedSemIm);
        SemIm updatedSemIm = semUpdater.getUpdatedSemIm();
        System.out.println("Updated graph: " + updatedSemIm.getSemPm().getGraph());
        System.out.println("Updated SEM = " + updatedSemIm);
    }

    public static Test suite() {
        return new TestSuite(TestSemUpdater.class);
    }

    private Graph constructGraph1() {
        EdgeListGraph graph = new EdgeListGraph();
        GraphNode x1 = new GraphNode("X1");
        GraphNode x2 = new GraphNode("X2");
        GraphNode x3 = new GraphNode("X3");
        GraphNode x4 = new GraphNode("X4");
        GraphNode x5 = new GraphNode("X5");
        graph.addNode(x1);
        graph.addNode(x2);
        graph.addNode(x3);
        graph.addNode(x4);
        graph.addNode(x5);
        graph.addDirectedEdge(x1, x2);
        graph.addDirectedEdge(x2, x3);
        graph.addDirectedEdge(x3, x4);
        graph.addDirectedEdge(x1, x4);
        graph.addDirectedEdge(x4, x5);
        return graph;
    }
}

