/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.session;

import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.session.SessionEvent;
import edu.cmu.tetrad.session.SessionListener;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetrad.session.Type6;
import edu.cmu.tetrad.session.Type7;
import edu.cmu.tetrad.session.Type8;
import java.rmi.MarshalledObject;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestSession
extends TestCase {
    private Session session;
    private String eventId;

    public TestSession(String name) {
        super(name);
    }

    @Override
    public void setUp() {
        this.session = new Session("Test");
    }

    public void testAddRemoveSessionNodes() {
        this.session.clearNodes();
        SessionNode node1 = new SessionNode(Type6.class);
        SessionNode node2 = new SessionNode(Type7.class);
        SessionNode node3 = new SessionNode(Type8.class);
        this.session.addNode(node1);
        this.session.addNode(node2);
        this.session.addNode(node3);
        TestSession.assertEquals(3, this.session.getNodes().size());
        TestSession.assertTrue(this.session.getNodes().contains(node1));
        TestSession.assertTrue(this.session.getNodes().contains(node2));
        TestSession.assertTrue(this.session.getNodes().contains(node3));
        this.session.removeNode(node2);
        TestSession.assertEquals(2, this.session.getNodes().size());
        TestSession.assertTrue(!this.session.getNodes().contains(node2));
        this.session.clearNodes();
        TestSession.assertEquals(0, this.session.getNodes().size());
    }

    public void testEvents() {
        boolean simulation = true;
        SessionListener listener = new SessionListener(){

            @Override
            public void nodeAdded(SessionEvent event) {
                TestSession.this.setEventId("nodeAdded");
            }

            @Override
            public void nodeRemoved(SessionEvent event) {
                TestSession.this.setEventId("nodeRemoved");
            }

            @Override
            public void parentAdded(SessionEvent event) {
                TestSession.this.setEventId("parentAdded");
            }

            @Override
            public void parentRemoved(SessionEvent event) {
                TestSession.this.setEventId("parentRemoved");
            }

            @Override
            public void modelCreated(SessionEvent event) {
                TestSession.this.setEventId("modelCreated");
            }

            @Override
            public void modelDestroyed(SessionEvent event) {
                TestSession.this.setEventId("modelDestroyed");
            }

            @Override
            public void modelUnclear(SessionEvent event) {
                TestSession.this.setEventId("modelUnclear");
            }

            @Override
            public void executionStarted(SessionEvent event) {
                TestSession.this.setEventId("executionBegun");
            }

            @Override
            public void repetitionChanged(SessionEvent event) {
                TestSession.this.setEventId("repetitionChanged");
            }

            @Override
            public void addingEdge(SessionEvent event) {
                TestSession.this.setEventId("addingEdge");
            }
        };
        this.session.addSessionListener(listener);
        try {
            this.setEventId(null);
            SessionNode node1 = new SessionNode(Type6.class);
            this.session.addNode(node1);
            TestSession.assertEquals("nodeAdded", this.getEventId());
            SessionNode node2 = new SessionNode(Type7.class);
            SessionNode node3 = new SessionNode(Type8.class);
            this.session.addNode(node2);
            this.session.addNode(node3);
            this.setEventId(null);
            node1.addParent(node2);
            TestSession.assertEquals("parentAdded", this.getEventId());
            this.setEventId(null);
            node2.createModel(Type7.class, simulation);
            TestSession.assertEquals("modelCreated", this.getEventId());
            this.setEventId(null);
            node2.destroyModel();
            TestSession.assertEquals("modelDestroyed", this.getEventId());
            this.setEventId(null);
            node1.removeParent(node2);
            TestSession.assertEquals("parentRemoved", this.getEventId());
            this.setEventId(null);
            this.session.removeNode(node2);
            TestSession.assertEquals("nodeRemoved", this.getEventId());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestSession.fail(e.getMessage());
        }
    }

    private void setEventId(String eventId) {
        this.eventId = eventId;
    }

    private String getEventId() {
        return this.eventId;
    }

    public void testSerialization() {
        boolean simulation = true;
        this.session.clearNodes();
        SessionNode node1 = new SessionNode(Type6.class);
        SessionNode node2 = new SessionNode(Type7.class);
        SessionNode node3 = new SessionNode(Type8.class);
        this.session.addNode(node1);
        this.session.addNode(node2);
        this.session.addNode(node3);
        node1.addParent(node2);
        node1.addParent(node3);
        node3.addParent(node2);
        try {
            node2.createModel(Type7.class, simulation);
            node3.createModel(Type8.class, simulation);
            node1.createModel(Type6.class, simulation);
        }
        catch (Exception e) {
            TestSession.fail("Model not created.");
        }
        try {
            new MarshalledObject<Session>(this.session).get();
        }
        catch (Exception e) {
            TestSession.fail("Serialization failed.");
        }
    }

    public static Test suite() {
        return new TestSuite(TestSession.class);
    }
}

