/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

public final class ArrUtils {
    public static double[] copy(double[] arr) {
        if (arr == null) {
            return null;
        }
        double[] copy = new double[arr.length];
        System.arraycopy(arr, 0, copy, 0, arr.length);
        return copy;
    }

    public static int[] copy(int[] arr) {
        if (arr == null) {
            return null;
        }
        int[] copy = new int[arr.length];
        System.arraycopy(arr, 0, copy, 0, arr.length);
        return copy;
    }

    public static boolean equals(double[] va, double[] vb) {
        if (va.length != vb.length) {
            throw new IllegalArgumentException("Incompatible matrix dimensions.");
        }
        for (int i = 0; i < va.length; ++i) {
            if (Math.abs(va[i] - vb[i]) == 0.0) continue;
            return false;
        }
        return true;
    }

    public static double[] concatenate(double[] arr1, double[] arr2) {
        double[] concat = new double[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, concat, 0, arr1.length);
        System.arraycopy(arr2, 0, concat, arr1.length, arr2.length);
        return concat;
    }

    public static double[][] asRow(double[] v) {
        double[][] arr = new double[1][v.length];
        System.arraycopy(v, 0, arr[0], 0, v.length);
        return arr;
    }

    public static double[][] asCol(double[] v) {
        double[][] arr = new double[v.length][1];
        for (int i = 0; i < v.length; ++i) {
            arr[i][0] = v[i];
        }
        return arr;
    }

    public static String toString(double[] arr) {
        DecimalFormat nf = new DecimalFormat(" 0.0000;-0.0000");
        return ArrUtils.toString(arr, nf);
    }

    public static String toString(int[] arr) {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        for (int anArr : arr) {
            buf.append(anArr).append("\t");
        }
        return buf.toString();
    }

    public static String toString(double[] arr, NumberFormat nf) {
        String result;
        if (nf == null) {
            throw new NullPointerException("NumberFormat must not be null.");
        }
        if (arr == null) {
            result = ArrUtils.nullMessage();
        } else {
            StringBuilder buf = new StringBuilder();
            buf.append("\n");
            buf.append("\t");
            for (double anArr : arr) {
                buf.append(nf.format(anArr)).append("\t");
            }
            result = buf.toString();
        }
        return result;
    }

    private static String nullMessage() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n");
        buf.append("\t");
        buf.append("<Matrix is null>");
        return buf.toString();
    }
}

