/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import edu.cmu.tetrad.util.Function;

public class Integrator {
    public static double getArea(Function f, double x1, double x2, int numIntervals) {
        if (f == null) {
            throw new IllegalArgumentException("Function not specified.");
        }
        if (!(x1 <= x2)) {
            throw new IllegalArgumentException("Integrating area under curve for interval [" + x1 + ", " + x2 + "], but " + x1 + " is not less than " + x2 + ".");
        }
        double deltaX = x2 - x1;
        double area = 0.0;
        for (int n = 0; n <= numIntervals; ++n) {
            double xValue = x1 + (double)n / (double)numIntervals * deltaX;
            if (n == 0) {
                area += f.valueAt(x1);
                continue;
            }
            if (n == numIntervals) {
                area += f.valueAt(x2);
                continue;
            }
            if (n % 2 == 1) {
                area += 4.0 * f.valueAt(xValue);
                continue;
            }
            area += 2.0 * f.valueAt(xValue);
        }
        return area *= deltaX / (3.0 * (double)numIntervals);
    }
}

