/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import java.util.Collections;
import java.util.LinkedList;

public final class PermutationGenerator {
    private int numObjects;
    private int[] choiceLocal;
    private int[] choiceReturned;
    private boolean begun;

    public PermutationGenerator(int a) {
        if (a < 0) {
            throw new IllegalArgumentException();
        }
        this.numObjects = a;
        this.choiceLocal = new int[a];
        for (int i = 0; i < a; ++i) {
            this.choiceLocal[i] = i;
        }
        this.begun = false;
    }

    public int[] next() {
        if (this.choiceReturned == null) {
            this.choiceReturned = new int[this.getNumObjects()];
            System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.numObjects);
            this.begun = true;
            return this.choiceReturned;
        }
        int i = this.getNumObjects() - 1;
        while (--i > -1) {
            LinkedList<Integer> h = new LinkedList<Integer>();
            for (int j = i; j < this.choiceLocal.length; ++j) {
                h.add(this.choiceLocal[j]);
            }
            Collections.sort(h);
            if (this.choiceLocal[i] >= (Integer)h.getLast()) continue;
            this.fill(i, h);
            this.begun = true;
            System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.numObjects);
            return this.choiceReturned;
        }
        if (this.begun) {
            return null;
        }
        this.begun = true;
        System.arraycopy(this.choiceLocal, 0, this.choiceReturned, 0, this.numObjects);
        return this.choiceReturned;
    }

    public static void testPrint(int a) {
        int[] choice;
        PermutationGenerator cg = new PermutationGenerator(a);
        System.out.println();
        System.out.println("Printing permutations for " + a + " objects:");
        System.out.println();
        while ((choice = cg.next()) != null) {
            if (choice.length == 0) {
                System.out.println("zero-length array");
                continue;
            }
            for (int aChoice : choice) {
                System.out.print(aChoice + "\t");
            }
            System.out.println();
        }
        System.out.println();
    }

    int getNumObjects() {
        return this.numObjects;
    }

    private void fill(int index, LinkedList<Integer> h) {
        h = new LinkedList<Integer>(h);
        int t = h.indexOf(this.choiceLocal[index]);
        Integer newVal = h.get(t + 1);
        this.choiceLocal[index] = newVal;
        h.remove(newVal);
        for (int i = index + 1; i < this.getNumObjects(); ++i) {
            this.choiceLocal[i] = h.get(i - index - 1);
        }
    }
}

