/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.matrix.DoubleMatrix1D;

public class Point
implements Comparable {
    private final DoubleMatrix1D vector;

    public Point(DoubleMatrix1D vector) {
        this.vector = vector.copy();
    }

    public double getValue(int index) {
        return this.vector.get(index);
    }

    public int getSize() {
        return this.vector.size();
    }

    public int compareTo(Object o) {
        if (o == this) {
            return 0;
        }
        Point p = (Point)o;
        for (int i = 0; i < this.getSize(); ++i) {
            if (this.getValue(i) == p.getValue(i)) continue;
            return (int)Math.signum(p.getValue(i) - this.getValue(i));
        }
        return 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("<");
        for (int i = 0; i < this.getSize(); ++i) {
            buf.append(this.getValue(i));
            if (i >= this.getSize() - 1) continue;
            buf.append(", ");
        }
        buf.append(">");
        return buf.toString();
    }

    public DoubleMatrix1D getVector() {
        return this.vector.copy();
    }
}

