/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util;

import cern.colt.list.DoubleArrayList;
import cern.colt.matrix.impl.DenseDoubleMatrix2D;
import cern.jet.stat.Descriptive;
import edu.cmu.tetrad.util.MatrixUtils;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;

public class TestMatrixUtils
extends TestCase {
    public TestMatrixUtils(String name) {
        super(name);
    }

    public void testEquals() {
        double[][] m1 = new double[][]{{1.0, 2.0, 3.0}};
        double[][] m2 = new double[][]{{6.0, 7.0}, {8.0, 9.0}};
        double[][] m3 = new double[][]{{6.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.0, 27.0}};
        double[][] m4 = new double[][]{{6.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.05, 27.0}};
        TestMatrixUtils.assertTrue(!MatrixUtils.equals(m1, m2));
        TestMatrixUtils.assertTrue(MatrixUtils.equals(m3, m3));
        TestMatrixUtils.assertTrue(MatrixUtils.equals(m3, m4, 0.1));
    }

    public void testSum() {
        double[][] m1 = new double[][]{{6.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.0, 27.0}};
        double[][] m2 = new double[][]{{3.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.05, 27.0}};
        double[][] m3 = MatrixUtils.sum(m1, m2);
        System.out.println(MatrixUtils.toString(m3));
    }

    public void testDeterminant() {
        double[][] m3 = new double[][]{{6.0, 7.0}, {8.0, 9.0}};
        double determinant = MatrixUtils.determinant(m3);
        TestMatrixUtils.assertEquals(-2.0, determinant, 0.01);
    }

    public void testDirectProduct() {
        double[][] m1 = new double[][]{{1.0, 2.0, 3.0}, {1.0, 2.0, 3.0}};
        double[][] m2 = new double[][]{{6.0, 7.0}, {8.0, 9.0}};
        double[][] result = new double[][]{{6.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.0, 27.0}, {6.0, 7.0, 12.0, 14.0, 18.0, 21.0}, {8.0, 9.0, 16.0, 18.0, 24.0, 27.0}};
        double[][] product = MatrixUtils.directProduct(m1, m2);
        TestMatrixUtils.assertTrue(MatrixUtils.equals(product, result));
    }

    public void testConcatenate() {
        double[][] m1 = new double[][]{{6.0, 7.0, 12.0, 14.0}, {8.0, 9.0, 16.0, 18.0}};
        double[] result = new double[]{6.0, 7.0, 12.0, 14.0, 8.0, 9.0, 16.0, 18.0};
        double[] concat = MatrixUtils.concatenate(m1);
        TestMatrixUtils.assertTrue(MatrixUtils.equals(concat, result));
    }

    public void testProduct() {
        double[][] m1 = new double[][]{{6.0, 7.0, 12.0, 14.0}, {8.0, 9.0, 16.0, 18.0}};
        double[][] m2 = new double[][]{{6.0, 7.0, 12.0}, {8.0, 9.0, 16.0}, {3.0, -2.0, 4.0}, {1.0, -4.0, 5.0}};
        double[][] result = new double[][]{{142.0, 25.0, 302.0}, {186.0, 33.0, 394.0}};
        double[][] product = MatrixUtils.product((double[][])m1, (double[][])m2);
        TestMatrixUtils.assertTrue(MatrixUtils.equals(product, result));
    }

    public void testSum0ToN() {
        TestMatrixUtils.assertEquals(0, MatrixUtils.sum0ToN(0));
        TestMatrixUtils.assertEquals(1, MatrixUtils.sum0ToN(1));
        TestMatrixUtils.assertEquals(3, MatrixUtils.sum0ToN(2));
        TestMatrixUtils.assertEquals(6, MatrixUtils.sum0ToN(3));
        TestMatrixUtils.assertEquals(10, MatrixUtils.sum0ToN(4));
    }

    public void testVechToVecLeft() {
        double[][] n = new double[][]{{6.0, 8.0, 6.0, 8.0}, {8.0, 9.0, 7.0, 9.0}, {6.0, 7.0, 12.0, 16.0}, {8.0, 9.0, 16.0, 18.0}};
        double[][] n1 = MatrixUtils.vec(n);
        double[][] n2 = MatrixUtils.vech(n);
        double[][] n3 = MatrixUtils.vechToVecLeft(4);
        double[][] n4 = MatrixUtils.product(n3, n2);
        TestMatrixUtils.assertTrue(MatrixUtils.equals(n4, n1));
    }

    public void testConvertCovMatrixToCorrMatrix() {
        double[][] data = new double[][]{{-0.377133, -1.480267, -1.696021, 1.195592, -0.345426}, {-0.694507, -2.568514, -4.654334, 0.094623, -6.081831}, {1.819202, 0.693551, 4.62622, 1.228998, 8.082}, {-0.131759, -0.256599, -1.319799, 0.304622, -2.588121}, {-1.407105, -1.455764, -2.185402, -3.848737, -4.357246}, {-1.099269, -1.892556, -1.63933, -1.156234, -4.174009}, {-0.27342, -0.079434, 0.226354, 0.919383, 1.151157}, {0.358854, -0.982877, 0.89074, 1.85012, 1.504533}, {-0.407574, -0.3164, -1.423396, 0.991819, -0.956139}, {1.243824, 1.690462, 4.045195, 1.34646, 5.247904}};
        double[][] dataT = MatrixUtils.transpose(data);
        int size = 5;
        DenseDoubleMatrix2D m = new DenseDoubleMatrix2D(size, size);
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                m.set(i, j, Descriptive.covariance(new DoubleArrayList(dataT[i]), new DoubleArrayList(dataT[j])));
            }
        }
        System.out.println("\n\nCovariance matrix: ");
        System.out.println(MatrixUtils.toString(m.toArray()));
        MatrixUtils.convertCovToCorr(m);
        System.out.println("\n\nCorrelation matrix:");
        System.out.println(MatrixUtils.toString(m.toArray()));
    }

    public static Test suite() {
        return new TestSuite(TestMatrixUtils.class);
    }
}

