/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.util.Arrays;

public class Discrete
implements Distribution {
    static final long serialVersionUID = 23L;
    private final double[] p;

    public Discrete(double ... p) {
        this.p = this.convert(p);
    }

    public static Discrete serializableInstance() {
        return new Discrete(0.1, 0.4, 0.9);
    }

    @Override
    public int getNumParameters() {
        return this.p.length;
    }

    @Override
    public String getName() {
        return "Discrete";
    }

    @Override
    public void setParameter(int index, double value) {
        this.p[index] = value;
    }

    @Override
    public double getParameter(int index) {
        return this.p[index];
    }

    @Override
    public String getParameterName(int index) {
        return "Cut #" + (index + 1);
    }

    @Override
    public double nextRandom() {
        double r = RandomUtil.getInstance().nextDouble();
        for (int i = 0; i < this.p.length; ++i) {
            if (!(r < this.p[i])) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public String toString() {
        return "Discrete(" + Arrays.toString(this.p) + ")";
    }

    private double[] convert(double ... p) {
        int i;
        for (double _p : p) {
            if (!(_p < 0.0)) continue;
            throw new IllegalArgumentException("All arguments must be >= 0: " + _p);
        }
        double sum = 0.0;
        for (double _p : p) {
            sum += _p;
        }
        for (i = 0; i < p.length; ++i) {
            int n = i;
            double d = p[n] / sum;
            p[n] = d;
            p[i] = d;
        }
        for (i = 1; i < p.length; ++i) {
            p[i] = p[i - 1] + p[i];
        }
        return p;
    }
}

