/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class ExponentialPower
implements Distribution {
    static final long serialVersionUID = 23L;
    private double tau;

    public ExponentialPower(double tau) {
        this.tau = tau;
    }

    public static ExponentialPower serializableInstance() {
        return new ExponentialPower(2.0);
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "Exponential Power";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.tau = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.tau;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Tau";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextExponentialPower(this.tau);
    }

    public String toString() {
        return "ExponentialPower(" + this.tau + ")";
    }
}

