/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class Hyperbolic
implements Distribution {
    static final long serialVersionUID = 23L;
    private double alpha;
    private double gamma;

    public Hyperbolic(double alpha, double gamma) {
        this.alpha = alpha;
        this.gamma = gamma;
    }

    public static Hyperbolic serializableInstance() {
        return new Hyperbolic(1.0, 2.0);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public String getName() {
        return "Hyperbolic";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.alpha = value;
        } else if (index == 1) {
            this.gamma = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.alpha;
        }
        if (index == 1) {
            return this.gamma;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Alpha";
        }
        if (index == 1) {
            return "Gamma";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextHyperbolic(this.alpha, this.gamma);
    }

    public String toString() {
        return "Hyperbolic(" + this.alpha + ", " + this.gamma + ")";
    }
}

