/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;

public class StudentT
implements Distribution {
    static final long serialVersionUID = 23L;
    private double df;

    public StudentT(double df) {
        if (df < 0.0) {
            throw new IllegalArgumentException("Degrees of Freedom must be >= 0: " + df);
        }
        this.df = df;
    }

    public static StudentT serializableInstance() {
        return new StudentT(1.0);
    }

    @Override
    public int getNumParameters() {
        return 1;
    }

    @Override
    public String getName() {
        return "Student T";
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0) {
            this.df = value;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.df;
        }
        throw new IllegalArgumentException();
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Degrees of freedom";
        }
        throw new IllegalArgumentException();
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextStudentT(this.df);
    }

    public String toString() {
        return "StudentT(" + this.df + ")";
    }
}

