/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetrad.util.dist;

import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetrad.util.RandomUtil;
import edu.cmu.tetrad.util.dist.Distribution;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.text.NumberFormat;

public class Uniform
implements Distribution {
    static final long serialVersionUID = 23L;
    private double a;
    private double b;

    public Uniform(double a, double b) {
        if (!(a <= b)) {
            throw new IllegalArgumentException("a must be less than or equal to b.");
        }
        this.a = a;
        this.b = b;
    }

    public static Uniform serializableInstance() {
        return new Uniform(0.0, 1.0);
    }

    @Override
    public void setParameter(int index, double value) {
        if (index == 0 && value < this.b) {
            this.a = value;
        } else if (index == 1 && value > this.a) {
            this.b = value;
        } else {
            throw new IllegalArgumentException("Illegal value for parameter " + index + ": " + value);
        }
    }

    @Override
    public double getParameter(int index) {
        if (index == 0) {
            return this.a;
        }
        if (index == 1) {
            return this.b;
        }
        throw new IllegalArgumentException("Illegal index: " + index);
    }

    @Override
    public String getParameterName(int index) {
        if (index == 0) {
            return "Lower Bound";
        }
        if (index == 1) {
            return "Upper Bound";
        }
        throw new IllegalArgumentException("Not a parameter index: " + index);
    }

    @Override
    public int getNumParameters() {
        return 2;
    }

    @Override
    public double nextRandom() {
        return RandomUtil.getInstance().nextUniform(this.a, this.b);
    }

    @Override
    public String getName() {
        return "Uniform";
    }

    public String toString() {
        NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();
        return "U(" + nf.format(this.getParameter(0)) + ", " + nf.format(this.getParameter(1)) + ")";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.a >= this.b) {
            throw new IllegalStateException();
        }
    }
}

