/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Endpoint;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.SessionNode;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.app.SessionNodeConfig;
import edu.cmu.tetradapp.app.TetradApplicationConfig;
import edu.cmu.tetradapp.model.SessionNodeWrapper;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;

final class ConstructTemplateAction
extends AbstractAction {
    private static final String[] TEMPLATE_NAMES = new String[]{"Simulate Data from IM", "Estimate from Simulated Data", "Search from Simulated Data", "Search from Simulated Data with Edge Comparisons", "Update IM", "--separator--", "Search from Loaded Data", "Estimate from Loaded Data (Bayes)", "Estimate from Loaded Data (SEM)", "Estimate from Search Result (Bayes)", "Estimate from Search Result (SEM)"};
    private String templateName;
    private SessionWrapper sessionWrapper;
    private SessionEditorWorkbench sessionWorkbench;

    public ConstructTemplateAction(String templateName) {
        super(templateName);
        if (templateName == null) {
            throw new NullPointerException("Template filename must not be null.");
        }
        this.templateName = templateName;
    }

    public static String[] getTemplateNames() {
        String[] templateNamesCopy = new String[TEMPLATE_NAMES.length];
        System.arraycopy(TEMPLATE_NAMES, 0, templateNamesCopy, 0, TEMPLATE_NAMES.length);
        return templateNamesCopy;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int leftX = this.getLeftX();
        if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[0])) {
            this.simulateData(leftX);
        } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[1])) {
            this.estimateFromSimulatedData(leftX);
        } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[2])) {
            this.searchFromSimulatedData(leftX);
        } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[3])) {
            this.searchFromSimulatedEdgeCompare(leftX);
        } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[4])) {
            this.updateFromSimulatedData(leftX);
        } else {
            if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[5])) {
                throw new IllegalStateException("Separator!");
            }
            if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[6])) {
                this.searchFromLoadedData(leftX);
            } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[7])) {
                this.estimateFromLoadedDataBayes(leftX);
            } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[8])) {
                this.estimateFromLoadedDataSem(leftX);
            } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[9])) {
                this.estimateUsingSearchResultBayes(leftX);
            } else if (this.templateName.equals(ConstructTemplateAction.getTemplateNames()[10])) {
                this.estimateUsingSearchResultSem(leftX);
            } else {
                throw new IllegalStateException("Unrecognized template name: " + this.templateName);
            }
        }
    }

    private int getLeftX() {
        Component[] components = this.getSessionWorkbench().getComponents();
        int leftX = 0;
        for (Component component : components) {
            Rectangle bounds = component.getBounds();
            int rightmost = bounds.x + bounds.width;
            if (rightmost <= leftX) continue;
            leftX = rightmost;
        }
        return leftX += 100;
    }

    private void searchFromLoadedData(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String data = ConstructTemplateAction.nextName("Data");
        String search = ConstructTemplateAction.nextName("Search");
        nodes.add(this.addNode("Data", data, leftX, 100));
        nodes.add(this.addNode("Search", search, 125 + leftX, 100));
        this.addEdge(data, search);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void estimateFromLoadedDataSem(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String data = ConstructTemplateAction.nextName("Data");
        String estimator = ConstructTemplateAction.nextName("Estimator");
        nodes.add(this.addNode("Data", data, leftX, 100));
        nodes.add(this.addNode("Graph", graph, 125 + leftX, 100));
        nodes.add(this.addNode("PM", pm, 125 + leftX, 200));
        nodes.add(this.addNode("Estimator", estimator, leftX, 200));
        this.addEdge(data, graph);
        this.addEdge(graph, pm);
        this.addEdge(pm, estimator);
        this.addEdge(data, estimator);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void estimateFromLoadedDataBayes(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String data = ConstructTemplateAction.nextName("Data");
        String estimator = ConstructTemplateAction.nextName("Estimator");
        nodes.add(this.addNode("Data", data, leftX, 100));
        nodes.add(this.addNode("Graph", graph, 125 + leftX, 100));
        nodes.add(this.addNode("PM", pm, 125 + leftX, 200));
        nodes.add(this.addNode("Estimator", estimator, leftX, 200));
        this.addEdge(data, graph);
        this.addEdge(graph, pm);
        this.addEdge(pm, estimator);
        this.addEdge(data, estimator);
        this.addEdge(data, pm);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void simulateData(int leftX) {
        this.getSessionWorkbench().deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String im = ConstructTemplateAction.nextName("IM");
        String data = ConstructTemplateAction.nextName("Data");
        nodes.add(this.addNode("Graph", graph, leftX, 100));
        nodes.add(this.addNode("PM", pm, leftX, 200));
        nodes.add(this.addNode("IM", im, leftX, 300));
        nodes.add(this.addNode("Data", data, leftX, 400));
        this.addEdge(graph, pm);
        this.addEdge(pm, im);
        this.addEdge(im, data);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void searchFromSimulatedData(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String im = ConstructTemplateAction.nextName("IM");
        String data = ConstructTemplateAction.nextName("Data");
        String search = ConstructTemplateAction.nextName("Search");
        nodes.add(this.addNode("Graph", graph, leftX, 100));
        nodes.add(this.addNode("PM", pm, leftX, 200));
        nodes.add(this.addNode("IM", im, leftX, 300));
        nodes.add(this.addNode("Data", data, leftX, 400));
        nodes.add(this.addNode("Search", search, 150 + leftX, 400));
        this.addEdge(graph, pm);
        this.addEdge(pm, im);
        this.addEdge(im, data);
        this.addEdge(data, search);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void searchFromSimulatedEdgeCompare(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String im = ConstructTemplateAction.nextName("IM");
        String data = ConstructTemplateAction.nextName("Data");
        String search = ConstructTemplateAction.nextName("Search");
        String compare = ConstructTemplateAction.nextName("Compare");
        nodes.add(this.addNode("Graph", graph, leftX, 100));
        nodes.add(this.addNode("PM", pm, leftX, 200));
        nodes.add(this.addNode("IM", im, leftX, 300));
        nodes.add(this.addNode("Data", data, leftX, 400));
        nodes.add(this.addNode("Search", search, 150 + leftX, 400));
        nodes.add(this.addNode("Compare", compare, 150 + leftX, 250));
        this.addEdge(graph, pm);
        this.addEdge(pm, im);
        this.addEdge(im, data);
        this.addEdge(data, search);
        this.addEdge(graph, compare);
        this.addEdge(search, compare);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void estimateFromSimulatedData(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String im = ConstructTemplateAction.nextName("IM");
        String data = ConstructTemplateAction.nextName("Data");
        String estimator = ConstructTemplateAction.nextName("Estimator");
        nodes.add(this.addNode("Graph", graph, leftX, 100));
        nodes.add(this.addNode("PM", pm, leftX, 200));
        nodes.add(this.addNode("IM", im, leftX, 300));
        nodes.add(this.addNode("Data", data, leftX, 400));
        nodes.add(this.addNode("Estimator", estimator, 150 + leftX, 250));
        this.addEdge(graph, pm);
        this.addEdge(pm, im);
        this.addEdge(im, data);
        this.addEdge(pm, estimator);
        this.addEdge(data, estimator);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void estimateUsingSearchResultBayes(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String data = ConstructTemplateAction.nextName("Data");
        String search = ConstructTemplateAction.nextName("Search");
        nodes.add(this.addNode("Data", data, leftX, 100));
        nodes.add(this.addNode("Search", search, leftX, 200));
        String graph = ConstructTemplateAction.nextName("Graph");
        nodes.add(this.addNode("Graph", graph, leftX + 150, 200));
        String pm = ConstructTemplateAction.nextName("PM");
        nodes.add(this.addNode("PM", pm, leftX + 300, 200));
        String estimator = ConstructTemplateAction.nextName("Estimator");
        nodes.add(this.addNode("Estimator", estimator, leftX + 300, 100));
        this.addEdge(data, search);
        this.addEdge(search, graph);
        this.addEdge(graph, pm);
        this.addEdge(data, estimator);
        this.addEdge(data, pm);
        this.addEdge(pm, estimator);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void estimateUsingSearchResultSem(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String data = ConstructTemplateAction.nextName("Data");
        String search = ConstructTemplateAction.nextName("Search");
        nodes.add(this.addNode("Data", data, leftX, 100));
        nodes.add(this.addNode("Search", search, leftX, 200));
        String graph2 = ConstructTemplateAction.nextName("Graph");
        nodes.add(this.addNode("Graph", graph2, 150 + leftX, 200));
        String pm2 = ConstructTemplateAction.nextName("PM");
        nodes.add(this.addNode("PM", pm2, 300 + leftX, 200));
        String estimator2 = ConstructTemplateAction.nextName("Estimator");
        nodes.add(this.addNode("Estimator", estimator2, 300 + leftX, 100));
        this.addEdge(data, search);
        this.addEdge(search, graph2);
        this.addEdge(graph2, pm2);
        this.addEdge(data, estimator2);
        this.addEdge(pm2, estimator2);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private void updateFromSimulatedData(int leftX) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        sessionWorkbench.deselectAll();
        LinkedList<Node> nodes = new LinkedList<Node>();
        String graph = ConstructTemplateAction.nextName("Graph");
        String pm = ConstructTemplateAction.nextName("PM");
        String im = ConstructTemplateAction.nextName("IM");
        String updater = ConstructTemplateAction.nextName("Updater");
        nodes.add(this.addNode("Graph", graph, leftX, 100));
        nodes.add(this.addNode("PM", pm, leftX, 200));
        nodes.add(this.addNode("IM", im, leftX, 300));
        nodes.add(this.addNode("Updater", updater, 150 + leftX, 300));
        this.addEdge(graph, pm);
        this.addEdge(pm, im);
        this.addEdge(im, updater);
        ConstructTemplateAction.selectSubgraph(nodes);
    }

    private static void selectSubgraph(List<Node> nodes) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        for (Node node : nodes) {
            sessionWorkbench.selectNode(node);
        }
        List<Edge> edges = sessionWorkbench.getGraph().getEdges();
        for (Edge edge : edges) {
            Node node1 = edge.getNode1();
            Node node2 = edge.getNode2();
            if (!nodes.contains(node1) || !nodes.contains(node2)) continue;
            sessionWorkbench.selectEdge(edge);
        }
        sessionWorkbench.scrollNodesToVisible(nodes);
    }

    private static String nextName(String base) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench sessionWorkbench = sessionEditor.getSessionWorkbench();
        SessionWrapper graph = sessionWorkbench.getSessionWrapper();
        if (base == null) {
            throw new NullPointerException("Base name must be non-null.");
        }
        int i = 0;
        block0: while (true) {
            String name = base + ++i;
            for (Node o : graph.getNodes()) {
                Node node = o;
                if (!node.getName().equals(name)) continue;
                continue block0;
            }
            break;
        }
        return base + i;
    }

    private SessionWrapper getSessionWrapper() {
        if (this.sessionWrapper == null) {
            this.sessionWrapper = this.getSessionWorkbench().getSessionWrapper();
        }
        return this.sessionWrapper;
    }

    private SessionEditorWorkbench getSessionWorkbench() {
        if (this.sessionWorkbench == null) {
            SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
            SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
            if (sessionEditor == null) {
                DesktopController.getInstance().newSessionEditor();
                sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
                sessionEditor = (SessionEditor)sessionEditorRef;
            }
            this.sessionWorkbench = sessionEditor.getSessionWorkbench();
        }
        return this.sessionWorkbench;
    }

    private Node addNode(String nodeType, String nodeName, int centerX, int centerY) {
        SessionNodeWrapper node = ConstructTemplateAction.getNewModelNode(nodeType, nodeName);
        node.setCenter(centerX, centerY);
        this.getSessionWrapper().addNode(node);
        return node;
    }

    private void addEdge(String nodeName1, String nodeName2) {
        Node node1 = this.getSessionWrapper().getNode(nodeName1);
        Node node2 = this.getSessionWrapper().getNode(nodeName2);
        if (node1 == null) {
            throw new RuntimeException("There was no node by name nodeName1 in the session wrapper: " + nodeName1);
        }
        if (node2 == null) {
            throw new RuntimeException("There was no node by name nodeName2 in the session wrapper: " + nodeName2);
        }
        SessionNodeWrapper nodeWrapper1 = (SessionNodeWrapper)node1;
        SessionNodeWrapper nodeWrapper2 = (SessionNodeWrapper)node2;
        Edge edge = new Edge(nodeWrapper1, nodeWrapper2, Endpoint.TAIL, Endpoint.ARROW);
        this.getSessionWrapper().addEdge(edge);
    }

    private static SessionNodeWrapper getNewModelNode(String nextButtonType, String name) {
        if (nextButtonType == null) {
            throw new NullPointerException("Next button type must be a non-null string.");
        }
        Class[] modelClasses = ConstructTemplateAction.getModelClasses(nextButtonType);
        SessionNode newNode = new SessionNode(nextButtonType, name, modelClasses);
        SessionNodeWrapper nodeWrapper = new SessionNodeWrapper(newNode);
        nodeWrapper.setButtonType(nextButtonType);
        return nodeWrapper;
    }

    private static Class[] getModelClasses(String nextButtonType) {
        TetradApplicationConfig tetradConfig = TetradApplicationConfig.getInstance();
        SessionNodeConfig config = tetradConfig.getSessionNodeConfig(nextButtonType);
        if (config == null) {
            throw new NullPointerException("There is no configuration for button: " + nextButtonType);
        }
        return config.getModels();
    }
}

