/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.graph.Edge;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.session.Session;
import edu.cmu.tetrad.util.TetradSerializable;
import edu.cmu.tetradapp.app.SessionEditorEdge;
import edu.cmu.tetradapp.app.SessionEditorNode;
import edu.cmu.tetradapp.app.SessionEditorToolbar;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

public final class SessionEditor
extends JComponent
implements SessionEditorIndirectRef {
    private SessionEditorToolbar toolbar;
    private SessionEditorWorkbench workbench;

    public SessionEditor(String name) {
        this(name, null);
    }

    public SessionEditor(String name, SessionEditorWorkbench workbench) {
        this.setName(name);
        if (workbench == null) {
            Session session = new Session(name);
            SessionWrapper wrapper = new SessionWrapper(session);
            workbench = new SessionEditorWorkbench(wrapper);
        }
        workbench.setName(name);
        this.setWorkbench(workbench);
        this.setToolbar(new SessionEditorToolbar(workbench));
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        this.setLayout(new BorderLayout());
        this.add((Component)workbenchScroll, "Center");
        this.add((Component)this.getToolbar(), "West");
        workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                String propertyName = e.getPropertyName();
                if ("name".equals(propertyName)) {
                    SessionEditor.this.firePropertyChange("name", e.getOldValue(), e.getNewValue());
                }
            }
        });
    }

    public SessionEditorWorkbench getSessionWorkbench() {
        return this.getWorkbench();
    }

    public List getSelectedModelComponents() {
        List<Component> selectedComponents = this.getWorkbench().getSelectedComponents();
        ArrayList<TetradSerializable> selectedModelComponents = new ArrayList<TetradSerializable>();
        for (Component comp : selectedComponents) {
            if (comp instanceof SessionEditorNode) {
                SessionEditorNode editorNode = (SessionEditorNode)comp;
                Node modelNode = editorNode.getModelNode();
                selectedModelComponents.add(modelNode);
                continue;
            }
            if (!(comp instanceof SessionEditorEdge)) continue;
            SessionEditorEdge editorEdge = (SessionEditorEdge)comp;
            Edge modelEdge = this.getWorkbench().getModelEdge(editorEdge);
            selectedModelComponents.add(modelEdge);
        }
        return selectedModelComponents;
    }

    public void pasteSubsession(List sessionElements, Point point) {
        this.getToolbar().setRespondingToEvents(false);
        this.getWorkbench().pasteSubsession(sessionElements, point);
        this.getToolbar().setRespondingToEvents(true);
    }

    @Override
    public final void setName(String name) {
        if (name == null) {
            throw new NullPointerException("Name must not be null.");
        }
        super.setName(name);
    }

    private SessionEditorToolbar getToolbar() {
        return this.toolbar;
    }

    private void setToolbar(SessionEditorToolbar toolbar) {
        this.toolbar = toolbar;
    }

    private SessionEditorWorkbench getWorkbench() {
        return this.workbench;
    }

    private void setWorkbench(SessionEditorWorkbench workbench) {
        this.workbench = workbench;
    }

    public void saveSessionImage() {
        SaveComponentImage action = new SaveComponentImage(this.workbench, "Save Session Image...");
        action.actionPerformed(new ActionEvent(this, 1001, "Save"));
    }

    public void firePropertyChange(String s, Object o, String name) {
        super.firePropertyChange(s, o, name);
    }
}

