/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionEditorWorkbench;
import edu.cmu.tetradapp.model.SessionWrapper;
import edu.cmu.tetradapp.model.TetradMetadata;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import edu.cmu.tetradapp.util.TetradMetadataIndirectRef;
import edu.cmu.tetradapp.util.Version;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class SessionVersionAction
extends AbstractAction {
    public SessionVersionAction() {
        super("Session Version");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SessionEditorIndirectRef sessionEditorRef = DesktopController.getInstance().getFrontmostSessionEditor();
        SessionEditor sessionEditor = (SessionEditor)sessionEditorRef;
        SessionEditorWorkbench workbench = sessionEditor.getSessionWorkbench();
        SessionWrapper sessionWrapper = workbench.getSessionWrapper();
        TetradMetadataIndirectRef metadataRef = DesktopController.getInstance().getTetradMetadata(sessionWrapper);
        TetradMetadata metadata = (TetradMetadata)metadataRef;
        StringBuilder buf = new StringBuilder();
        if (metadata == null) {
            buf.append("This session has not yet been saved or loaded. The current\n");
            buf.append("version you are working in is ");
            buf.append(Version.currentViewableVersion());
            buf.append(".");
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), buf.toString());
            return;
        }
        SimpleDateFormat df = new SimpleDateFormat("MMM dd, yyyy");
        buf.append("Version information for \"");
        buf.append(sessionWrapper.getName());
        buf.append("\":\n\n");
        buf.append("Last saved using Tetrad ");
        buf.append(metadata.getVersion());
        buf.append(" (");
        buf.append(df.format(metadata.getDate()));
        buf.append(").\n");
        buf.append("You are running Tetrad ");
        buf.append(Version.currentViewableVersion());
        buf.append(".");
        JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), buf.toString());
    }
}

