/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.app;

import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetrad.util.TetradLogger;
import edu.cmu.tetradapp.app.AboutTetradAction;
import edu.cmu.tetradapp.app.CloseSessionAction;
import edu.cmu.tetradapp.app.ConstructTemplateAction;
import edu.cmu.tetradapp.app.CopySubsessionAction;
import edu.cmu.tetradapp.app.CutSubsessionAction;
import edu.cmu.tetradapp.app.ExitAction;
import edu.cmu.tetradapp.app.LicenseAction;
import edu.cmu.tetradapp.app.LoadSessionAction;
import edu.cmu.tetradapp.app.NewSessionAction;
import edu.cmu.tetradapp.app.NumberFormatAction;
import edu.cmu.tetradapp.app.PasteSubsessionAction;
import edu.cmu.tetradapp.app.SaveSessionAction;
import edu.cmu.tetradapp.app.SaveSessionAsAction;
import edu.cmu.tetradapp.app.SessionEditor;
import edu.cmu.tetradapp.app.SessionVersionAction;
import edu.cmu.tetradapp.app.SetupLoggingAction;
import edu.cmu.tetradapp.app.TetradDesktop;
import edu.cmu.tetradapp.app.TetradHelpBroker;
import edu.cmu.tetradapp.app.WarrantyAction;
import edu.cmu.tetradapp.app.WindowMenuListener;
import edu.cmu.tetradapp.util.DesktopController;
import edu.cmu.tetradapp.util.SessionEditorIndirectRef;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.help.JHelp;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import javax.swing.border.EtchedBorder;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;

final class TetradMenuBar
extends JMenuBar {
    private final JMenuItem helpMI;
    private final TetradDesktop desktop;

    public TetradMenuBar(TetradDesktop desktop) {
        String[] templateNames;
        this.desktop = desktop;
        this.setBorder(new EtchedBorder());
        JMenu fileMenu = new JMenu("File");
        JMenu editMenu = new JMenu("Edit");
        JMenu loggingMenu = new JMenu("Logging");
        JMenu templateMenu = new JMenu("Template");
        JMenu windowMenu = new JMenu("Window");
        JMenu helpMenu = new JMenu("Help");
        this.add(fileMenu);
        this.add(editMenu);
        this.add(loggingMenu);
        this.add(templateMenu);
        this.add(windowMenu);
        this.add(helpMenu);
        JMenuItem newSession = new JMenuItem(new NewSessionAction());
        JMenuItem loadSession = new JMenuItem(new LoadSessionAction());
        JMenuItem closeSession = new JMenuItem(new CloseSessionAction());
        JMenuItem saveSession = new JMenuItem(new SaveSessionAction());
        fileMenu.add(newSession);
        fileMenu.add(loadSession);
        fileMenu.add(closeSession);
        fileMenu.addSeparator();
        fileMenu.add(saveSession);
        fileMenu.add(new SaveSessionAsAction());
        fileMenu.addSeparator();
        fileMenu.add(new SessionVersionAction());
        fileMenu.addSeparator();
        JMenuItem menuItem = new JMenuItem("Save Session Graph Image...");
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SessionEditorIndirectRef editorRef = DesktopController.getInstance().getFrontmostSessionEditor();
                SessionEditor editor = (SessionEditor)editorRef;
                editor.saveSessionImage();
            }
        });
        fileMenu.add(menuItem);
        fileMenu.addSeparator();
        JMenuItem exit = new JMenuItem(new ExitAction());
        fileMenu.add(exit);
        exit.setAccelerator(KeyStroke.getKeyStroke(81, 2));
        newSession.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        loadSession.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        saveSession.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        closeSession.setAccelerator(KeyStroke.getKeyStroke(87, 2));
        JMenuItem cut = new JMenuItem(new CutSubsessionAction());
        JMenuItem copy = new JMenuItem(new CopySubsessionAction());
        JMenuItem paste = new JMenuItem(new PasteSubsessionAction());
        JMenuItem numberFormat = new JMenuItem(new NumberFormatAction());
        cut.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        editMenu.add(cut);
        editMenu.add(copy);
        editMenu.add(paste);
        editMenu.addSeparator();
        editMenu.add(numberFormat);
        JDesktopPane pane = desktop.getDesktopPane();
        WindowMenuListener windowMenuListener = new WindowMenuListener(windowMenu, pane);
        windowMenu.addMenuListener(windowMenuListener);
        for (String templateName : templateNames = ConstructTemplateAction.getTemplateNames()) {
            if ("--separator--".equals(templateName)) {
                templateMenu.addSeparator();
                continue;
            }
            ConstructTemplateAction action = new ConstructTemplateAction(templateName);
            templateMenu.add(action);
        }
        JMenuItem help = new JMenuItem("Tetrad Manual");
        help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JHelp jhelp = new JHelp(TetradHelpBroker.getInstance().getHelpSet());
                JComponent centeringComp = JOptionUtils.centeringComp();
                Container owner = centeringComp.getTopLevelAncestor();
                JDialog dialog = owner instanceof Dialog ? new JDialog((Dialog)owner, "Tetrad Manual", true) : new JDialog((Frame)owner, "Tetrad Manual", true);
                dialog.setResizable(true);
                dialog.getContentPane().add((Component)jhelp, "Center");
                dialog.pack();
                dialog.setSize(new Dimension(900, 600));
                dialog.setLocationRelativeTo(centeringComp);
                dialog.setVisible(true);
            }
        });
        this.helpMI = help;
        helpMenu.add(help);
        helpMenu.add(new AboutTetradAction());
        helpMenu.add(new WarrantyAction());
        helpMenu.add(new LicenseAction());
        loggingMenu.addMenuListener(new LoggingMenuListener());
    }

    public void showHelp() {
        this.helpMI.doClick();
    }

    private void buildLoggingMenu(JMenu loggingMenu) {
        loggingMenu.removeAll();
        JMenuItem displayLogging = new JMenuItem();
        displayLogging.setText(this.desktop.isDisplayLogging() ? "Stop Logging" : "Start Logging");
        loggingMenu.add(displayLogging);
        loggingMenu.add(new SetupLoggingAction());
        displayLogging.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JMenuItem item = (JMenuItem)e.getSource();
                String text = item.getText();
                boolean logging = text.contains("Start");
                TetradMenuBar.this.desktop.setDisplayLogging(logging);
                TetradLogger.getInstance().setLogging(true);
                item.setText(logging ? "Start Logging" : "Stop Logging");
            }
        });
    }

    private class LoggingMenuListener
    implements MenuListener {
        private LoggingMenuListener() {
        }

        @Override
        public void menuSelected(MenuEvent e) {
            TetradMenuBar.this.buildLoggingMenu((JMenu)e.getSource());
        }

        @Override
        public void menuDeselected(MenuEvent e) {
        }

        @Override
        public void menuCanceled(MenuEvent e) {
        }
    }
}

