/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.bayes.BayesProperties;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.util.NumberFormatUtil;
import edu.cmu.tetradapp.editor.BayesEstimatorEditorWizard;
import edu.cmu.tetradapp.editor.SaveComponentImage;
import edu.cmu.tetradapp.model.BayesEstimatorWrapper;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.NumberFormat;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class BayesEstimatorEditor
extends JPanel {
    private BayesEstimatorEditorWizard wizard;
    private final NumberFormat nf = NumberFormatUtil.getInstance().getNumberFormat();

    private BayesEstimatorEditor(BayesIm bayesIm, DataSet dataSet) {
        if (bayesIm == null) {
            throw new NullPointerException("Bayes IM must not be null.");
        }
        BayesPm bayesPm = bayesIm.getBayesPm();
        Dag graph = bayesPm.getDag();
        GraphWorkbench workbench = new GraphWorkbench(graph);
        this.wizard = new BayesEstimatorEditorWizard(bayesIm, workbench);
        this.wizard.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorValueChanged".equals(evt.getPropertyName())) {
                    BayesEstimatorEditor.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        JScrollPane workbenchScroll = new JScrollPane(workbench);
        workbenchScroll.setPreferredSize(new Dimension(400, 400));
        JScrollPane wizardScroll = new JScrollPane(this.getWizard());
        BayesProperties properties = new BayesProperties(dataSet, graph);
        properties.setGraph(graph);
        StringBuilder buf = new StringBuilder();
        buf.append("\nP-value = ").append(properties.getVuongP());
        buf.append("\nDf = ").append(properties.getPValueDf());
        buf.append("\nChi square = ").append(this.nf.format(properties.getPValueChisq()));
        buf.append("\nBIC score = ").append(this.nf.format(properties.getBic()));
        buf.append("\n\nH0: Completely disconnected graph.");
        JTextArea modelParametersText = new JTextArea();
        modelParametersText.setText(buf.toString());
        JTabbedPane tabbedPane = new JTabbedPane();
        tabbedPane.add("Model", wizardScroll);
        tabbedPane.add("Model Statistics", modelParametersText);
        JSplitPane splitPane = new JSplitPane(1, workbenchScroll, tabbedPane);
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(workbenchScroll.getPreferredSize().width);
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
        this.setName("Bayes IM Editor");
        this.getWizard().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("editorClosing".equals(evt.getPropertyName())) {
                    BayesEstimatorEditor.this.firePropertyChange("editorClosing", null, BayesEstimatorEditor.this.getName());
                }
                if ("closeFrame".equals(evt.getPropertyName())) {
                    BayesEstimatorEditor.this.firePropertyChange("closeFrame", null, null);
                    BayesEstimatorEditor.this.firePropertyChange("editorClosing", true, true);
                }
            }
        });
        JMenuBar menuBar = new JMenuBar();
        JMenu file = new JMenu("File");
        menuBar.add(file);
        file.add(new SaveComponentImage(workbench, "Save Graph Image..."));
        this.add((Component)menuBar, "North");
    }

    public BayesEstimatorEditor(BayesEstimatorWrapper bayesEstWrapper) {
        this(bayesEstWrapper.getEstimatedBayesIm(), bayesEstWrapper.getDataSet());
    }

    @Override
    public void setName(String name) {
        String oldName = this.getName();
        super.setName(name);
        this.firePropertyChange("name", oldName, this.getName());
    }

    private BayesEstimatorEditorWizard getWizard() {
        return this.wizard;
    }
}

