/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesIm;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetradapp.editor.BayesImNodeEditingTable;
import edu.cmu.tetradapp.util.SortingComboBox;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.MatteBorder;
import javax.swing.table.TableCellEditor;

public final class BayesEstimatorEditorWizard
extends JPanel {
    private BayesIm bayesIm;
    private JComboBox varNamesComboBox;
    private GraphWorkbench workbench;
    private BayesImNodeEditingTable editingTable;
    private JPanel tablePanel;

    public BayesEstimatorEditorWizard(BayesIm bayesIm, GraphWorkbench workbench) {
        if (bayesIm == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        workbench.setAllowDoubleClickActions(false);
        this.setBorder(new MatteBorder(10, 10, 10, 10, this.getBackground()));
        this.setLayout(new BoxLayout(this, 1));
        this.setFont(new Font("SanSerif", 1, 12));
        this.varNamesComboBox = this.createVarNamesComboBox(bayesIm);
        workbench.scrollWorkbenchToNode((Node)this.varNamesComboBox.getSelectedItem());
        JButton nextButton = new JButton("Next");
        nextButton.setMnemonic('N');
        Node node = (Node)this.varNamesComboBox.getSelectedItem();
        this.editingTable = new BayesImNodeEditingTable(node, bayesIm);
        this.editingTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    BayesEstimatorEditorWizard.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.add((Component)scroll, "Center");
        this.editingTable.grabFocus();
        Box b1 = Box.createHorizontalBox();
        b1.add(new JLabel("Choose the next variable to view:  "));
        b1.add(this.varNamesComboBox);
        b1.add(nextButton);
        b1.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add((Component)this.tablePanel, "Center");
        this.add(b1);
        this.add(Box.createVerticalStrut(10));
        this.add(b4);
        this.varNamesComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)BayesEstimatorEditorWizard.this.varNamesComboBox.getSelectedItem();
                BayesEstimatorEditorWizard.this.getWorkbench().scrollWorkbenchToNode(node);
                BayesEstimatorEditorWizard.this.setCurrentNode(node);
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int current = BayesEstimatorEditorWizard.this.varNamesComboBox.getSelectedIndex();
                int max = BayesEstimatorEditorWizard.this.varNamesComboBox.getItemCount();
                if (++current == max) {
                    JOptionPane.showMessageDialog(BayesEstimatorEditorWizard.this, "There are no more variables.");
                }
                int set = current < max ? current : 0;
                BayesEstimatorEditorWizard.this.varNamesComboBox.setSelectedIndex(set);
            }
        });
        workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                List selection;
                if (e.getPropertyName().equals("selectedNodes") && (selection = (List)e.getNewValue()).size() == 1) {
                    Node node = (Node)selection.get(0);
                    BayesEstimatorEditorWizard.this.varNamesComboBox.setSelectedItem(node);
                }
            }
        });
        this.bayesIm = bayesIm;
        this.workbench = workbench;
    }

    private JComboBox createVarNamesComboBox(BayesIm bayesIm) {
        SortingComboBox varNamesComboBox = new SortingComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        varNamesComboBox.setBackground(Color.white);
        Dag graph = bayesIm.getBayesPm().getDag();
        for (Node o : graph.getNodes()) {
            ((JComboBox)varNamesComboBox).addItem(o);
        }
        if (graph.getNodes().size() > 0) {
            varNamesComboBox.setSelectedIndex(0);
        }
        return varNamesComboBox;
    }

    private void setCurrentNode(Node node) {
        TableCellEditor cellEditor = this.editingTable.getCellEditor();
        if (cellEditor != null) {
            cellEditor.cancelCellEditing();
        }
        this.editingTable = new BayesImNodeEditingTable(node, this.getBayesIm());
        this.editingTable.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("modelChanged".equals(evt.getPropertyName())) {
                    BayesEstimatorEditorWizard.this.firePropertyChange("modelChanged", null, null);
                }
            }
        });
        JScrollPane scroll = new JScrollPane(this.editingTable);
        scroll.setPreferredSize(new Dimension(0, 150));
        this.tablePanel.removeAll();
        this.tablePanel.add((Component)scroll, "Center");
        this.tablePanel.revalidate();
        this.tablePanel.repaint();
        this.editingTable.grabFocus();
    }

    public BayesIm getBayesIm() {
        return this.bayesIm;
    }

    private GraphWorkbench getWorkbench() {
        return this.workbench;
    }
}

