/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.ParameterEditor;
import edu.cmu.tetradapp.model.BayesImParams;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class BayesImParamsEditor
extends JPanel
implements ParameterEditor {
    private BayesImParams params = null;

    @Override
    public void setParams(Params params) {
        if (params == null) {
            throw new NullPointerException();
        }
        this.params = (BayesImParams)params;
    }

    @Override
    public void setParentModels(Object[] parentModels) {
    }

    @Override
    public void setup() {
        this.setLayout(new BorderLayout());
        JRadioButton manually = new JRadioButton();
        final JRadioButton randomly = new JRadioButton();
        final JCheckBox randomEveryTime = new JCheckBox();
        manually.setText("Manually.");
        randomly.setText("Randomly.");
        randomEveryTime.setText("<html>Pick new random values every time this <br>Bayes IM is re-initialized.</html>");
        randomEveryTime.setVerticalTextPosition(1);
        ButtonGroup group = new ButtonGroup();
        group.add(manually);
        group.add(randomly);
        if (this.getParams().getInitializationMode() == 0) {
            manually.setSelected(true);
            randomEveryTime.setEnabled(false);
            randomEveryTime.setSelected(false);
        } else if (this.getParams().getInitializationMode() == 1) {
            randomly.setSelected(true);
            randomEveryTime.setEnabled(true);
            randomEveryTime.setSelected(false);
        } else if (this.getParams().getInitializationMode() == 2) {
            randomly.setSelected(true);
            randomEveryTime.setEnabled(true);
            randomEveryTime.setSelected(true);
        } else {
            throw new IllegalStateException();
        }
        manually.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesImParamsEditor.this.getParams().setInitializationMode(0);
                randomEveryTime.setEnabled(false);
            }
        });
        randomly.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesImParamsEditor.this.getParams().setInitializationMode(1);
                randomEveryTime.setEnabled(true);
                randomEveryTime.setSelected(false);
            }
        });
        randomEveryTime.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!randomly.isSelected()) {
                    throw new IllegalStateException("Should only get here if initializing randomly.");
                }
                JCheckBox checkBox = (JCheckBox)e.getSource();
                if (checkBox.isSelected()) {
                    BayesImParamsEditor.this.getParams().setInitializationMode(2);
                } else {
                    BayesImParamsEditor.this.getParams().setInitializationMode(1);
                }
            }
        });
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Probability values for this Bayes IM should be filled in: "));
        b2.add(Box.createHorizontalGlue());
        Box b3 = Box.createHorizontalBox();
        b3.add(manually);
        b3.add(Box.createHorizontalGlue());
        Box b4 = Box.createHorizontalBox();
        b4.add(randomly);
        b4.add(Box.createHorizontalGlue());
        Box b5 = Box.createHorizontalBox();
        b5.add(Box.createHorizontalStrut(20));
        b5.add(randomEveryTime);
        b5.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(5));
        b1.add(b3);
        b1.add(b4);
        b1.add(b5);
        b1.add(Box.createHorizontalGlue());
        this.add((Component)b1, "Center");
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
    }

    @Override
    public boolean mustBeShown() {
        return false;
    }

    private synchronized BayesImParams getParams() {
        return this.params;
    }
}

