/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.bayes.BayesPm;
import edu.cmu.tetrad.data.DiscreteVariable;
import edu.cmu.tetrad.graph.Dag;
import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.graph.NodeType;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.util.SortingComboBox;
import edu.cmu.tetradapp.util.StringTextField;
import edu.cmu.tetradapp.workbench.GraphWorkbench;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.KeyStroke;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

final class BayesPmEditorWizard
extends JPanel {
    private BayesPm bayesPm;
    private JComboBox variableChooser;
    private boolean editingMeasuredVariablesAllowed = false;
    private boolean editingLatentVariablesAllowed = false;
    private GraphWorkbench workbench;
    private CategoryEditor categoryEditor;
    private SpinnerNumberModel spinnerModel;
    private String[][] presetStrings = new String[][]{{"Low", "High"}, {"Low", "Medium", "High"}, {"On", "Off"}, {"Yes", "No"}};
    private List copiedCategories;
    private Map<Object, Integer> labels = new HashMap<Object, Integer>();
    private JSpinner numCategoriesSpinner;
    private JMenu presetMenu;

    public BayesPmEditorWizard(BayesPm bayesPm, GraphWorkbench workbench) {
        if (bayesPm == null) {
            throw new NullPointerException();
        }
        if (workbench == null) {
            throw new NullPointerException();
        }
        this.bayesPm = bayesPm;
        this.workbench = workbench;
        this.workbench().setAllowDoubleClickActions(false);
        this.createVariableChooser(this.getBayesPm(), this.workbench());
        JButton nextButton = new JButton("Next");
        nextButton.setMnemonic('N');
        int numCategories = this.numCategories();
        Box b1 = Box.createVerticalBox();
        Box b2 = Box.createHorizontalBox();
        b2.add(new JLabel("Edit categories for: "));
        b2.add(this.variableChooser);
        b2.add(nextButton);
        b2.add(Box.createHorizontalGlue());
        b1.add(b2);
        b1.add(Box.createVerticalStrut(10));
        if (numCategories != 0) {
            this.spinnerModel = new SpinnerNumberModel(numCategories, 2, 1000, 1);
            this.numCategoriesSpinner = new JSpinner(this.spinnerModel){

                @Override
                public Dimension getMaximumSize() {
                    return this.getPreferredSize();
                }
            };
            this.numCategoriesSpinner.setFont(new Font("Serif", 0, 12));
            this.numCategoriesSpinner.addChangeListener(new ChangeListener(){

                @Override
                public void stateChanged(ChangeEvent e) {
                    JSpinner spinner = (JSpinner)e.getSource();
                    SpinnerNumberModel model = (SpinnerNumberModel)spinner.getModel();
                    BayesPmEditorWizard.this.setNumCategories(model.getNumber().intValue());
                }
            });
            Box b3 = Box.createHorizontalBox();
            b3.add(new JLabel("Number of categories:  "));
            b3.add(this.numCategoriesSpinner);
            b3.add(Box.createHorizontalGlue());
            b1.add(b3);
            b1.add(Box.createVerticalStrut(10));
        }
        this.categoryEditor = new CategoryEditor(bayesPm, this.getNode());
        Box b4 = Box.createHorizontalBox();
        b4.add(new JLabel("Category names: "));
        b4.add(Box.createHorizontalGlue());
        b1.add(b4);
        b1.add(Box.createVerticalStrut(10));
        Box b5 = Box.createHorizontalBox();
        b5.add(this.categoryEditor);
        b1.add(b5);
        Box b6 = Box.createHorizontalBox();
        b6.add(Box.createRigidArea(new Dimension(400, 0)));
        b1.add(b6);
        b1.add(Box.createVerticalGlue());
        JMenuBar menuBar = this.createMenuBar();
        b1.setBorder(new EmptyBorder(10, 10, 0, 10));
        this.setLayout(new BorderLayout());
        this.add((Component)b1, "Center");
        this.add((Component)menuBar, "North");
        workbench.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                List selection;
                if (evt.getPropertyName().equals("selectedNodes") && (selection = (List)evt.getNewValue()).size() == 1) {
                    Node node = (Node)selection.get(0);
                    BayesPmEditorWizard.this.variableChooser.setSelectedItem(node);
                }
            }
        });
        this.variableChooser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Node node = (Node)BayesPmEditorWizard.this.variableChooser.getSelectedItem();
                BayesPmEditorWizard.this.workbench().scrollWorkbenchToNode(node);
                BayesPmEditorWizard.this.setNode(node);
            }
        });
        nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int current = BayesPmEditorWizard.this.variableChooser.getSelectedIndex();
                int max = BayesPmEditorWizard.this.variableChooser.getItemCount();
                if (++current == max) {
                    JOptionPane.showMessageDialog(BayesPmEditorWizard.this, "There are no more variables.");
                }
                int set = current < max ? current : 0;
                BayesPmEditorWizard.this.variableChooser.setSelectedIndex(set);
            }
        });
        this.enableByNodeType();
    }

    private void enableByNodeType() {
        if (!this.isEditingMeasuredVariablesAllowed() && this.categoryEditor.getNode().getNodeType() == NodeType.MEASURED) {
            this.setEnabled(false);
        } else if (!this.isEditingLatentVariablesAllowed() && this.categoryEditor.getNode().getNodeType() == NodeType.LATENT) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.numCategoriesSpinner.setEnabled(enabled);
        this.categoryEditor.setEnabled(enabled);
    }

    private void setNumCategories(int numCategories) {
        this.categoryEditor.setNumCategories(numCategories);
        this.firePropertyChange("modelChanged", null, null);
    }

    private JMenuBar createMenuBar() {
        JMenu presetMenu;
        JMenuBar menuBar = new JMenuBar();
        this.presetMenu = presetMenu = new JMenu("Presets");
        menuBar.add(presetMenu);
        for (int i = 0; i < this.presetStrings.length; ++i) {
            StringBuilder buf = new StringBuilder();
            for (int j = 0; j < this.presetStrings[i].length; ++j) {
                buf.append(this.presetStrings[i][j]);
                if (j >= this.presetStrings[i].length - 1) continue;
                buf.append("-");
            }
            IndexedAction action = new IndexedAction(buf.toString(), i){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BayesPmEditorWizard.this.setCategories(Arrays.asList(BayesPmEditorWizard.this.presetStrings[this.getIndex()]));
                }
            };
            presetMenu.add(action);
        }
        presetMenu.addSeparator();
        AbstractAction sequence = new AbstractAction("x1, x2, x3, ..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList<String> categories = new ArrayList<String>();
                String ret = JOptionPane.showInputDialog(JOptionUtils.centeringComp(), "Please input a prefix string for the sequence: ", "category");
                int numCategories = BayesPmEditorWizard.this.numCategories();
                for (int i = 0; i < numCategories; ++i) {
                    categories.add(ret + (i + 1));
                }
                BayesPmEditorWizard.this.setCategories(categories);
            }
        };
        presetMenu.add(sequence);
        JMenu transfer = new JMenu("Transfer");
        JMenuItem copy = new JMenuItem("Copy categories");
        JMenuItem paste = new JMenuItem("Paste categories");
        copy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesPmEditorWizard.this.copyCategories();
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "<html>The categories for this node have been copied; to transfer <br>these categories, choose another node and paste. You may<br>paste multiple times.</html>");
            }
        });
        paste.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BayesPmEditorWizard.this.pasteCategories();
            }
        });
        copy.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        paste.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        transfer.add(copy);
        transfer.add(paste);
        menuBar.add(transfer);
        return menuBar;
    }

    private void copyCategories() {
        Node node = (Node)this.variableChooser.getSelectedItem();
        DiscreteVariable variable = (DiscreteVariable)this.bayesPm.getVariable(node);
        this.copiedCategories = variable.getCategories();
    }

    private void pasteCategories() {
        if (this.copiedCategories != null) {
            this.setCategories(this.copiedCategories);
        }
    }

    private void setCategories(List categories) {
        this.categoryEditor.setCategories(categories);
        this.spinnerModel.setValue(categories.size());
        this.firePropertyChange("modelChanged", null, null);
    }

    private void createVariableChooser(BayesPm bayesPm, GraphWorkbench workbench) {
        this.variableChooser = new SortingComboBox(){

            @Override
            public Dimension getMaximumSize() {
                return this.getPreferredSize();
            }
        };
        this.variableChooser.setBackground(Color.white);
        Dag graphModel = bayesPm.getDag();
        Iterator<Node> it = graphModel.getNodes().iterator();
        while (it.hasNext()) {
            this.variableChooser.addItem(it.next());
        }
        if (graphModel.getNodes().size() > 0) {
            this.variableChooser.setSelectedIndex(0);
        }
        workbench.scrollWorkbenchToNode((Node)this.variableChooser.getSelectedItem());
    }

    private void setNode(Node node) {
        this.categoryEditor.setNode(node);
        int numCategories = this.bayesPm.getNumCategories(node);
        this.spinnerModel.setValue(numCategories);
        this.firePropertyChange("modelChanged", null, null);
        this.enableByNodeType();
    }

    private GraphWorkbench workbench() {
        return this.workbench;
    }

    private int numCategories() {
        return this.getBayesPm().getNumCategories(this.getNode());
    }

    private BayesPm getBayesPm() {
        return this.bayesPm;
    }

    private Node getNode() {
        return (Node)this.variableChooser.getSelectedItem();
    }

    public boolean isEditingMeasuredVariablesAllowed() {
        return this.editingMeasuredVariablesAllowed;
    }

    public void setEditingMeasuredVariablesAllowed(boolean editingMeasuredVariablesAllowed) {
        this.editingMeasuredVariablesAllowed = editingMeasuredVariablesAllowed;
        this.setNode(this.categoryEditor.getNode());
        if (!editingMeasuredVariablesAllowed) {
            this.presetMenu.setEnabled(false);
        } else {
            this.presetMenu.setEnabled(true);
        }
    }

    public boolean isEditingLatentVariablesAllowed() {
        return this.editingLatentVariablesAllowed;
    }

    public void setEditingLatentVariablesAllowed(boolean editingLatentVariablesAllowed) {
        this.editingLatentVariablesAllowed = editingLatentVariablesAllowed;
        this.setNode(this.categoryEditor.getNode());
        if (!editingLatentVariablesAllowed) {
            this.presetMenu.setEnabled(false);
        }
    }

    static abstract class IndexedAction
    extends AbstractAction {
        private int index;

        public IndexedAction(String name, int index) {
            super(name);
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    class CategoryEditor
    extends JPanel {
        private BayesPm bayesPm;
        private Node node;
        private StringTextField[] categoryFields;
        private LinkedList focusTraveralOrder = new LinkedList();

        public CategoryEditor(BayesPm bayesPm, Node node) {
            if (bayesPm == null) {
                throw new NullPointerException();
            }
            this.setLayout(new BorderLayout());
            if (node == null) {
                return;
            }
            this.bayesPm = bayesPm;
            this.node = node;
            this.setNumCategories(this.numCategories());
        }

        public void setNumCategories(int numCategories) {
            this.removeAll();
            JComponent categoryFieldsPanel = this.createCategoryFieldsPanel(numCategories);
            this.add((Component)categoryFieldsPanel, "Center");
            this.revalidate();
            this.repaint();
            this.firePropertyChange("modelChanged", null, null);
        }

        public BayesPm getBayesPm() {
            return this.bayesPm;
        }

        private JComponent createCategoryFieldsPanel(int numCategories) {
            if (numCategories != this.bayesPm.getNumCategories(this.getNode())) {
                this.bayesPm.setNumCategories(this.getNode(), numCategories);
            }
            Box panel = Box.createVerticalBox();
            this.createCategoryFields();
            for (int i = 0; i < this.bayesPm.getNumCategories(this.getNode()); ++i) {
                Box row = Box.createHorizontalBox();
                row.add(Box.createRigidArea(new Dimension(10, 0)));
                row.add(new JLabel(i + 1 + "."));
                row.add(Box.createRigidArea(new Dimension(4, 0)));
                row.add(this.categoryFields[i]);
                row.add(Box.createHorizontalGlue());
                panel.add(row);
            }
            this.setLayout(new BorderLayout());
            this.add((Component)panel, "Center");
            this.setFocusTraversalPolicy(new FocusTraversalPolicy(){

                @Override
                public Component getComponentAfter(Container focusCycleRoot, Component aComponent) {
                    int index = CategoryEditor.this.focusTraveralOrder.indexOf(aComponent);
                    int size = CategoryEditor.this.focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)CategoryEditor.this.focusTraveralOrder.get((index + 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getComponentBefore(Container focusCycleRoot, Component aComponent) {
                    int index = CategoryEditor.this.focusTraveralOrder.indexOf(aComponent);
                    int size = CategoryEditor.this.focusTraveralOrder.size();
                    if (index != -1) {
                        return (Component)CategoryEditor.this.focusTraveralOrder.get((index - 1) % size);
                    }
                    return this.getFirstComponent(focusCycleRoot);
                }

                @Override
                public Component getFirstComponent(Container focusCycleRoot) {
                    return (Component)CategoryEditor.this.focusTraveralOrder.getFirst();
                }

                @Override
                public Component getLastComponent(Container focusCycleRoot) {
                    return (Component)CategoryEditor.this.focusTraveralOrder.getLast();
                }

                @Override
                public Component getDefaultComponent(Container focusCycleRoot) {
                    return this.getFirstComponent(focusCycleRoot);
                }
            });
            this.setFocusCycleRoot(true);
            return panel;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            for (StringTextField field : this.categoryFields) {
                field.setEnabled(enabled);
            }
        }

        private void createCategoryFields() {
            this.categoryFields = new StringTextField[this.numCategories()];
            for (int i = 0; i < this.numCategories(); ++i) {
                this.categoryFields[i] = new StringTextField(this.category(i), 10);
                final StringTextField _field = this.categoryFields[i];
                this.categoryFields[i].setFilter(new StringTextField.Filter(){

                    @Override
                    public String filter(String value, String oldValue) {
                        if (BayesPmEditorWizard.this.labels.get(_field) != null) {
                            int index = (Integer)BayesPmEditorWizard.this.labels.get(_field);
                            if (value == null) {
                                value = CategoryEditor.this.category(index);
                            }
                            for (int i = 0; i < CategoryEditor.this.numCategories(); ++i) {
                                if (i == index || !CategoryEditor.this.category(i).equals(value)) continue;
                                value = CategoryEditor.this.category(index);
                            }
                            CategoryEditor.this.setCategory(index, value);
                        }
                        return value;
                    }
                });
                BayesPmEditorWizard.this.labels.put(this.categoryFields[i], i);
                this.focusTraveralOrder.add(this.categoryFields[i]);
            }
        }

        private int numCategories() {
            return this.bayesPm.getNumCategories(this.getNode());
        }

        private String category(int index) {
            return this.bayesPm.getCategory(this.getNode(), index);
        }

        private void setCategory(int index, String value) {
            DiscreteVariable variable = (DiscreteVariable)this.bayesPm.getVariable(this.getNode());
            List<String> categories = variable.getCategories();
            categories.set(index, value);
            this.bayesPm.setCategories(this.node, categories);
            this.firePropertyChange("modelChanged", null, null);
        }

        public void setNode(Node node) {
            for (int i = 0; i < this.numCategories(); ++i) {
                this.categoryFields[i].setValue(this.categoryFields[i].getText());
            }
            this.node = node;
            this.setNumCategories(this.bayesPm.getNumCategories(node));
        }

        public void setCategories(List categories) {
            if (categories == null) {
                throw new NullPointerException();
            }
            if (categories.size() < 2) {
                throw new IllegalArgumentException("Number of categories must be >= 2: " + categories.size());
            }
            for (int i = 0; i < categories.size(); ++i) {
                if (categories.get(i) != null) continue;
                throw new NullPointerException();
            }
            this.removeAll();
            JComponent categoryFieldsPanel = this.createCategoryFieldsPanel(categories.size());
            for (int i = 0; i < categories.size(); ++i) {
                this.categoryFields[i].setValue((String)categories.get(i));
            }
            this.add((Component)categoryFieldsPanel, "Center");
            this.revalidate();
            this.repaint();
        }

        public Node getNode() {
            return this.node;
        }
    }
}

