/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.graph.Node;
import edu.cmu.tetrad.model.Params;
import edu.cmu.tetradapp.editor.CalculatorEditor;
import edu.cmu.tetradapp.editor.DataEditor;
import edu.cmu.tetradapp.editor.EditorWindow;
import edu.cmu.tetradapp.model.DataWrapper;
import edu.cmu.tetradapp.model.HasCalculatorParams;
import edu.cmu.tetradapp.model.calculator.Transformation;
import edu.cmu.tetradapp.util.DesktopController;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.JLayeredPane;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class CalculatorAction
extends AbstractAction {
    private DataWrapper wrapper;
    private DataEditor dataEditor;

    public CalculatorAction(DataWrapper wrapper) {
        super("Calculator ...");
        if (wrapper == null) {
            throw new NullPointerException("DataWrapper was null.");
        }
        this.wrapper = wrapper;
    }

    public CalculatorAction(DataEditor editor) {
        this(editor.getDataWrapper());
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        final CalculatorEditor editor = new CalculatorEditor();
        Params params = this.wrapper.getParams();
        if (params instanceof HasCalculatorParams) {
            params = ((HasCalculatorParams)((Object)params)).getCalculatorParams();
        }
        editor.setParams(params);
        editor.setParentModels(new Object[]{this.wrapper});
        editor.setup();
        EditorWindow editorWindow = new EditorWindow(editor, editor.getName(), "Save", true, this.dataEditor);
        DesktopController.getInstance().addEditorWindow(editorWindow, JLayeredPane.PALETTE_LAYER);
        editorWindow.pack();
        editorWindow.setVisible(true);
        editorWindow.addInternalFrameListener(new InternalFrameAdapter(){

            @Override
            public void internalFrameClosed(InternalFrameEvent e) {
                EditorWindow window = (EditorWindow)e.getSource();
                if (window.isCanceled()) {
                    return;
                }
                if (editor.finalizeEdit()) {
                    String[] displayEquations;
                    ArrayList<String> equations = new ArrayList<String>();
                    String _displayEquations = Preferences.userRoot().get("calculator_equations", "");
                    for (String equation : displayEquations = _displayEquations.split("///")) {
                        if (equation.contains("$")) {
                            for (Node node : editor.getDataSet().getVariables()) {
                                equations.add(equation.replace("$", node.getName()));
                            }
                            continue;
                        }
                        equations.add(equation);
                    }
                    String[] eqs = equations.toArray(new String[0]);
                    try {
                        Transformation.transform(editor.getDataSet(), eqs);
                    }
                    catch (ParseException e1) {
                        throw new IllegalStateException("Parse error while applying equations to dataset.");
                    }
                }
            }
        });
    }
}

