/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.tetradapp.editor;

import edu.cmu.tetrad.data.CorrelationMatrix;
import edu.cmu.tetrad.data.CovarianceMatrix;
import edu.cmu.tetrad.data.DataModel;
import edu.cmu.tetrad.data.DataModelList;
import edu.cmu.tetrad.data.DataSet;
import edu.cmu.tetrad.util.JOptionUtils;
import edu.cmu.tetradapp.editor.DataEditor;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

final class ConvertToCorrMatixAction
extends AbstractAction {
    private DataEditor dataEditor;

    public ConvertToCorrMatixAction(DataEditor editor) {
        super("Correlation Matrix");
        if (editor == null) {
            throw new NullPointerException();
        }
        this.dataEditor = editor;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataModel dataModel = this.getDataEditor().getSelectedDataModel();
        if (dataModel instanceof DataSet) {
            DataSet dataSet = (DataSet)dataModel;
            if (!dataSet.isContinuous()) {
                JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a continuous data set or a covariance (or correlation) matrix.");
                return;
            }
            CorrelationMatrix corrMatrix = new CorrelationMatrix(dataSet);
            DataModelList list = new DataModelList();
            list.add(corrMatrix);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else if (dataModel instanceof CovarianceMatrix) {
            CovarianceMatrix covarianceMatrix = (CovarianceMatrix)dataModel;
            CorrelationMatrix corrMatrix = new CorrelationMatrix(covarianceMatrix);
            DataModelList list = new DataModelList();
            list.add(corrMatrix);
            this.getDataEditor().reset(list);
            this.getDataEditor().selectFirstTab();
        } else {
            JOptionPane.showMessageDialog(JOptionUtils.centeringComp(), "Must be a continuous data set or a covariance (or correlation) matrix.");
        }
    }

    private DataEditor getDataEditor() {
        return this.dataEditor;
    }
}

